/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.software.http;

import brooklyn.config.ConfigKey;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.effector.AddSensor;
import brooklyn.event.feed.http.HttpFeed;
import brooklyn.event.feed.http.HttpPollConfig;
import brooklyn.event.feed.http.HttpValueFunctions;
import brooklyn.util.config.ConfigBag;
import com.google.common.annotations.Beta;
import com.google.common.base.Functions;
import com.google.common.base.Supplier;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public final class HttpRequestSensor<T>
extends AddSensor<T> {
    private static final Logger LOG = LoggerFactory.getLogger(HttpRequestSensor.class);
    public static final ConfigKey<String> SENSOR_URI = ConfigKeys.newStringConfigKey((String)"uri", (String)"HTTP URI to poll for JSON");
    public static final ConfigKey<String> JSON_PATH = ConfigKeys.newStringConfigKey((String)"jsonPath", (String)"JSON path to select in HTTP response; default $", (String)"$");
    public static final ConfigKey<String> USERNAME = ConfigKeys.newStringConfigKey((String)"username", (String)"Username for HTTP request, if required");
    public static final ConfigKey<String> PASSWORD = ConfigKeys.newStringConfigKey((String)"password", (String)"Password for HTTP request, if required");
    protected final Supplier<URI> uri;
    protected final String jsonPath;
    protected final String username;
    protected final String password;

    public HttpRequestSensor(final ConfigBag params) {
        super(params);
        this.uri = new Supplier<URI>(){

            public URI get() {
                return URI.create((String)params.get(SENSOR_URI));
            }
        };
        this.jsonPath = (String)params.get(JSON_PATH);
        this.username = (String)params.get(USERNAME);
        this.password = (String)params.get(PASSWORD);
    }

    public void apply(EntityLocal entity) {
        super.apply(entity);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding HTTP JSON sensor {} to {}", (Object)this.name, (Object)entity);
        }
        HttpPollConfig pollConfig = (HttpPollConfig)((HttpPollConfig)((HttpPollConfig)((HttpPollConfig)new HttpPollConfig(this.sensor).checkSuccess(HttpValueFunctions.responseCodeEquals((int)200))).onFailureOrException(Functions.constant((Object)null))).onSuccess(HttpValueFunctions.jsonContentsFromPath((String)this.jsonPath))).period(this.period);
        HttpFeed.builder().entity(entity).baseUri(this.uri).credentialsIfNotNull(this.username, this.password).poll(pollConfig).build();
    }
}

