/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.software;

import brooklyn.config.ConfigKey;
import brooklyn.entity.Effector;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.Attributes;
import brooklyn.entity.basic.BrooklynConfigKeys;
import brooklyn.entity.basic.BrooklynTaskTags;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.EffectorStartableImpl;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.EntityInternal;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.basic.Lifecycle;
import brooklyn.entity.basic.Sanitizer;
import brooklyn.entity.basic.ServiceStateLogic;
import brooklyn.entity.basic.SoftwareProcess;
import brooklyn.entity.effector.EffectorBody;
import brooklyn.entity.effector.Effectors;
import brooklyn.entity.software.ProvidesProvisioningFlags;
import brooklyn.entity.software.SshEffectorTasks;
import brooklyn.entity.trait.Startable;
import brooklyn.entity.trait.StartableMethods;
import brooklyn.event.feed.ConfigToAttributes;
import brooklyn.location.Location;
import brooklyn.location.MachineLocation;
import brooklyn.location.MachineProvisioningLocation;
import brooklyn.location.NoMachinesAvailableException;
import brooklyn.location.basic.AbstractLocation;
import brooklyn.location.basic.LocalhostMachineProvisioningLocation;
import brooklyn.location.basic.Locations;
import brooklyn.location.basic.Machines;
import brooklyn.location.basic.SshMachineLocation;
import brooklyn.management.ManagementContext;
import brooklyn.management.Task;
import brooklyn.management.TaskAdaptable;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.config.ConfigBag;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.guava.Maybe;
import brooklyn.util.net.UserAndHostAndPort;
import brooklyn.util.os.Os;
import brooklyn.util.ssh.BashCommands;
import brooklyn.util.task.DynamicTasks;
import brooklyn.util.task.Tasks;
import brooklyn.util.task.system.ProcessTaskWrapper;
import brooklyn.util.text.Strings;
import brooklyn.util.time.Duration;
import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public abstract class MachineLifecycleEffectorTasks {
    private static final Logger log = LoggerFactory.getLogger(MachineLifecycleEffectorTasks.class);
    public static final ConfigKey<Boolean> ON_BOX_BASE_DIR_RESOLVED = ConfigKeys.newBooleanConfigKey((String)"onbox.base.dir.resolved", (String)"Whether the on-box base directory has been resolved (for internal use)");
    public static final ConfigKey<Collection<? extends Location>> LOCATIONS = EffectorStartableImpl.StartParameters.LOCATIONS;
    public static final ConfigKey<Duration> STOP_PROCESS_TIMEOUT = ConfigKeys.newConfigKey(Duration.class, (String)"process.stop.timeout", (String)"How long to wait for the processes to be stopped; use null to mean forever", (Object)Duration.TWO_MINUTES);

    public void attachLifecycleEffectors(Entity entity) {
        ((EntityInternal)entity).getMutableEntityType().addEffector(this.newStartEffector());
        ((EntityInternal)entity).getMutableEntityType().addEffector(this.newRestartEffector());
        ((EntityInternal)entity).getMutableEntityType().addEffector(this.newStopEffector());
    }

    public Effector<Void> newStartEffector() {
        return Effectors.effector((Effector)Startable.START).impl(this.newStartEffectorTask()).build();
    }

    public Effector<Void> newRestartEffector() {
        return Effectors.effector((Effector)Startable.RESTART).parameter(SoftwareProcess.RestartSoftwareParameters.RESTART_CHILDREN).parameter(SoftwareProcess.RestartSoftwareParameters.RESTART_MACHINE).impl(this.newRestartEffectorTask()).build();
    }

    public Effector<Void> newStopEffector() {
        return Effectors.effector((Effector)Startable.STOP).parameter(SoftwareProcess.StopSoftwareParameters.STOP_PROCESS_MODE).parameter(SoftwareProcess.StopSoftwareParameters.STOP_MACHINE_MODE).impl(this.newStopEffectorTask()).build();
    }

    public EffectorBody<Void> newStartEffectorTask() {
        return new EffectorBody<Void>(){

            public Void call(ConfigBag parameters) {
                List locations = null;
                Object locationsRaw = parameters.getStringKey(LOCATIONS.getName());
                locations = Locations.coerceToCollection((ManagementContext)this.entity().getManagementContext(), (Object)locationsRaw);
                if (locations == null) {
                    locations = Collections.emptyList();
                }
                MachineLifecycleEffectorTasks.this.start(locations);
                return null;
            }
        };
    }

    public EffectorBody<Void> newRestartEffectorTask() {
        return new EffectorBody<Void>(){

            public Void call(ConfigBag parameters) {
                MachineLifecycleEffectorTasks.this.restart(parameters);
                return null;
            }
        };
    }

    public EffectorBody<Void> newStopEffectorTask() {
        return new EffectorBody<Void>(){

            public Void call(ConfigBag parameters) {
                MachineLifecycleEffectorTasks.this.stop(parameters);
                return null;
            }
        };
    }

    protected EntityInternal entity() {
        return (EntityInternal)BrooklynTaskTags.getTargetOrContextEntity((Task)Tasks.current());
    }

    protected Location getLocation(@Nullable Collection<? extends Location> locations) {
        Maybe ml;
        MachineProvisioningLocation provisioner;
        if (locations == null || locations.isEmpty()) {
            locations = this.entity().getLocations();
        }
        if (locations.isEmpty() && (provisioner = (MachineProvisioningLocation)this.entity().getAttribute(SoftwareProcess.PROVISIONING_LOCATION)) != null) {
            locations = Arrays.asList(provisioner);
        }
        if ((ml = Locations.findUniqueMachineLocation((Iterable)(locations = Locations.getLocationsCheckingAncestors((Collection)locations, (Entity)this.entity())))).isPresent()) {
            return (Location)ml.get();
        }
        if (locations.isEmpty()) {
            throw new IllegalArgumentException("No locations specified when starting " + this.entity());
        }
        if (locations.size() != 1 || Iterables.getOnlyElement(locations) == null) {
            throw new IllegalArgumentException("Ambiguous locations detected when starting " + this.entity() + ": " + locations);
        }
        return (Location)Iterables.getOnlyElement(locations);
    }

    public void start(Collection<? extends Location> locations) {
        ServiceStateLogic.setExpectedState((Entity)this.entity(), (Lifecycle)Lifecycle.STARTING);
        try {
            this.startInLocations(locations);
            DynamicTasks.waitForLast();
            ServiceStateLogic.setExpectedState((Entity)this.entity(), (Lifecycle)Lifecycle.RUNNING);
        }
        catch (Throwable t) {
            ServiceStateLogic.setExpectedState((Entity)this.entity(), (Lifecycle)Lifecycle.ON_FIRE);
            throw Exceptions.propagate((Throwable)t);
        }
    }

    protected void startInLocations(Collection<? extends Location> locations) {
        this.startInLocation(this.getLocation(locations));
    }

    protected void startInLocation(Location location) {
        Supplier locationS = null;
        if (location instanceof MachineProvisioningLocation) {
            Task<MachineLocation> machineTask = this.provisionAsync((MachineProvisioningLocation)location);
            locationS = Tasks.supplier(machineTask);
        } else if (location instanceof MachineLocation) {
            locationS = Suppliers.ofInstance((Object)((MachineLocation)location));
        }
        Preconditions.checkState((locationS != null ? 1 : 0) != 0, (Object)("Unsupported location " + location + ", when starting " + this.entity()));
        final Supplier locationSF = locationS;
        this.preStartAtMachineAsync((Supplier<MachineLocation>)locationSF);
        DynamicTasks.queue((String)"start (processes)", (Runnable)new Runnable(){

            @Override
            public void run() {
                MachineLifecycleEffectorTasks.this.startProcessesAtMachine((Supplier<MachineLocation>)locationSF);
            }
        });
        this.postStartAtMachineAsync();
    }

    protected Task<MachineLocation> provisionAsync(final MachineProvisioningLocation<?> location) {
        return (Task)DynamicTasks.queue((TaskAdaptable)Tasks.builder().name("provisioning (" + location.getDisplayName() + ")").body((Callable)new Callable<MachineLocation>(){

            @Override
            public MachineLocation call() throws Exception {
                MachineLocation machine;
                MachineLifecycleEffectorTasks.this.entity().getConfig(BrooklynConfigKeys.PROVISION_LATCH);
                final Map<String, Object> flags = MachineLifecycleEffectorTasks.this.obtainProvisioningFlags(location);
                if (!(location instanceof LocalhostMachineProvisioningLocation)) {
                    log.info("Starting {}, obtaining a new location instance in {} with ports {}", new Object[]{MachineLifecycleEffectorTasks.this.entity(), location, flags.get("inboundPorts")});
                }
                MachineLifecycleEffectorTasks.this.entity().setAttribute(SoftwareProcess.PROVISIONING_LOCATION, (Object)location);
                try {
                    machine = (MachineLocation)Tasks.withBlockingDetails((String)("Provisioning machine in " + location), (Callable)new Callable<MachineLocation>(){

                        @Override
                        public MachineLocation call() throws NoMachinesAvailableException {
                            return location.obtain(flags);
                        }
                    });
                    if (machine == null) {
                        throw new NoMachinesAvailableException("Failed to obtain machine in " + location.toString());
                    }
                }
                catch (Exception e) {
                    throw Exceptions.propagate((Throwable)e);
                }
                if (log.isDebugEnabled()) {
                    log.debug("While starting {}, obtained new location instance {}", (Object)MachineLifecycleEffectorTasks.this.entity(), (Object)(machine instanceof SshMachineLocation ? machine + ", details " + ((SshMachineLocation)machine).getUser() + ":" + Sanitizer.sanitize((ConfigBag)((SshMachineLocation)machine).config().getLocalBag()) : machine));
                }
                return machine;
            }
        }).build());
    }

    protected void preStartAtMachineAsync(final Supplier<MachineLocation> machineS) {
        DynamicTasks.queue((String)"pre-start", (Runnable)new Runnable(){

            @Override
            public void run() {
                ImmutableList oldSshLocs;
                MachineLocation machine = (MachineLocation)machineS.get();
                log.info("Starting {} on machine {}", (Object)MachineLifecycleEffectorTasks.this.entity(), (Object)machine);
                Collection oldLocs = MachineLifecycleEffectorTasks.this.entity().getLocations();
                if (!oldLocs.isEmpty() && !(oldSshLocs = ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)oldLocs, MachineLocation.class))).isEmpty()) {
                    log.debug("Entity " + MachineLifecycleEffectorTasks.this.entity() + " had machine locations " + oldSshLocs + " when starting at " + machine + "; checking if they are compatible");
                    for (MachineLocation oldLoc : oldSshLocs) {
                        if ("localhost".equals(machine.getConfig(AbstractLocation.ORIGINAL_SPEC))) continue;
                        MachineLifecycleEffectorTasks.this.checkLocationParametersCompatible(machine, oldLoc, "hostname", oldLoc.getAddress().getHostName(), machine.getAddress().getHostName());
                        MachineLifecycleEffectorTasks.this.checkLocationParametersCompatible(machine, oldLoc, "address", oldLoc.getAddress().getHostAddress(), machine.getAddress().getHostAddress());
                    }
                    log.debug("Entity " + MachineLifecycleEffectorTasks.this.entity() + " old machine locations " + oldSshLocs + " were compatible, removing them to start at " + machine);
                    MachineLifecycleEffectorTasks.this.entity().removeLocations((Collection)oldSshLocs);
                }
                MachineLifecycleEffectorTasks.this.entity().addLocations((Collection)ImmutableList.of((Object)machine));
                Maybe lh = Machines.getSubnetHostname((Location)machine);
                Maybe la = Machines.getSubnetIp((Location)machine);
                if (lh.isPresent()) {
                    MachineLifecycleEffectorTasks.this.entity().setAttribute(Attributes.SUBNET_HOSTNAME, lh.get());
                }
                if (la.isPresent()) {
                    MachineLifecycleEffectorTasks.this.entity().setAttribute(Attributes.SUBNET_ADDRESS, la.get());
                }
                MachineLifecycleEffectorTasks.this.entity().setAttribute(Attributes.HOSTNAME, (Object)machine.getAddress().getHostName());
                MachineLifecycleEffectorTasks.this.entity().setAttribute(Attributes.ADDRESS, (Object)machine.getAddress().getHostAddress());
                if (machine instanceof SshMachineLocation) {
                    SshMachineLocation sshMachine = (SshMachineLocation)machine;
                    UserAndHostAndPort sshAddress = UserAndHostAndPort.fromParts((String)sshMachine.getUser(), (String)sshMachine.getAddress().getHostName(), (int)sshMachine.getPort());
                    MachineLifecycleEffectorTasks.this.entity().setAttribute(Attributes.SSH_ADDRESS, (Object)sshAddress);
                }
                MachineLifecycleEffectorTasks.resolveOnBoxDir(MachineLifecycleEffectorTasks.this.entity(), machine);
                MachineLifecycleEffectorTasks.this.preStartCustom(machine);
            }
        });
    }

    public static String resolveOnBoxDir(EntityInternal entity, MachineLocation machine) {
        String base = (String)entity.getConfig(BrooklynConfigKeys.ONBOX_BASE_DIR);
        if (base == null) {
            base = (String)machine.getConfig(BrooklynConfigKeys.ONBOX_BASE_DIR);
        }
        if (base != null && Boolean.TRUE.equals(entity.getConfig(ON_BOX_BASE_DIR_RESOLVED))) {
            return base;
        }
        if (base == null) {
            base = (String)entity.getManagementContext().getConfig().getConfig(BrooklynConfigKeys.ONBOX_BASE_DIR);
        }
        if (base == null) {
            base = (String)entity.getConfig(BrooklynConfigKeys.BROOKLYN_DATA_DIR);
        }
        if (base == null) {
            base = (String)machine.getConfig(BrooklynConfigKeys.BROOKLYN_DATA_DIR);
        }
        if (base == null) {
            base = (String)entity.getManagementContext().getConfig().getConfig(BrooklynConfigKeys.BROOKLYN_DATA_DIR);
        }
        if (base == null) {
            base = "~/brooklyn-managed-processes";
        }
        if (base.equals("~")) {
            base = ".";
        }
        if (base.startsWith("~/")) {
            base = "." + base.substring(1);
        }
        String resolvedBase = null;
        if (((Boolean)entity.getConfig(BrooklynConfigKeys.SKIP_ON_BOX_BASE_DIR_RESOLUTION)).booleanValue() || ((Boolean)machine.getConfig(BrooklynConfigKeys.SKIP_ON_BOX_BASE_DIR_RESOLUTION)).booleanValue()) {
            if (log.isDebugEnabled()) {
                log.debug("Skipping on-box base dir resolution for " + entity + " at " + machine);
            }
            if (!Os.isAbsolutish((String)base)) {
                base = "~/" + base;
            }
            resolvedBase = Os.tidyPath((String)base);
        } else if (machine instanceof SshMachineLocation) {
            SshMachineLocation ms = (SshMachineLocation)machine;
            ProcessTaskWrapper baseTask = ((SshEffectorTasks.SshEffectorTaskFactory)((SshEffectorTasks.SshEffectorTaskFactory)((SshEffectorTasks.SshEffectorTaskFactory)SshEffectorTasks.ssh(BashCommands.alternatives((String[])new String[]{"mkdir -p \"${BASE_DIR}\"", BashCommands.chain((String[])new String[]{BashCommands.sudo((String)"mkdir -p \"${BASE_DIR}\""), BashCommands.sudo((String)("chown " + ms.getUser() + " \"${BASE_DIR}\""))})}), "cd ~", "cd ${BASE_DIR}", "echo BASE_DIR_RESULT':'`pwd`:BASE_DIR_RESULT").environmentVariable("BASE_DIR", base)).requiringExitCodeZero()).summary("initializing on-box base dir " + base)).newTask();
            DynamicTasks.queueIfPossible(baseTask).orSubmitAsync((Entity)entity);
            resolvedBase = Strings.getFragmentBetween((String)baseTask.block().getStdout(), (String)"BASE_DIR_RESULT:", (String)":BASE_DIR_RESULT");
        }
        if (resolvedBase == null) {
            if (!Os.isAbsolutish((String)base)) {
                base = "~/" + base;
            }
            resolvedBase = Os.tidyPath((String)base);
            log.warn("Could not resolve on-box directory for " + entity + " at " + machine + "; using " + resolvedBase + ", though this may not be accurate at the target (and may fail shortly)");
        }
        entity.setConfig(BrooklynConfigKeys.ONBOX_BASE_DIR, (Object)resolvedBase);
        entity.setConfig(ON_BOX_BASE_DIR_RESOLVED, (Object)true);
        return resolvedBase;
    }

    protected void checkLocationParametersCompatible(MachineLocation oldLoc, MachineLocation newLoc, String paramSummary, Object oldParam, Object newParam) {
        if (oldParam == null || newParam == null || !oldParam.equals(newParam)) {
            throw new IllegalStateException("Cannot start " + this.entity() + " in " + newLoc + " as it has already been started with incompatible location " + oldLoc + " " + "(" + paramSummary + " not compatible: " + oldParam + " / " + newParam + "); " + newLoc + " may require manual removal.");
        }
    }

    protected void preStartCustom(MachineLocation machine) {
        ConfigToAttributes.apply((EntityLocal)this.entity());
        Object val = this.entity().getConfig(SoftwareProcess.START_LATCH);
        if (val != null) {
            log.debug("{} finished waiting for start-latch; continuing...", (Object)this.entity(), val);
        }
    }

    protected Map<String, Object> obtainProvisioningFlags(MachineProvisioningLocation<?> location) {
        if (this.entity() instanceof ProvidesProvisioningFlags) {
            return ((ProvidesProvisioningFlags)this.entity()).obtainProvisioningFlags(location).getAllConfig();
        }
        return MutableMap.of();
    }

    protected abstract String startProcessesAtMachine(Supplier<MachineLocation> var1);

    protected void postStartAtMachineAsync() {
        DynamicTasks.queue((String)"post-start", (Runnable)new Runnable(){

            @Override
            public void run() {
                MachineLifecycleEffectorTasks.this.postStartCustom();
            }
        });
    }

    protected void postStartCustom() {
    }

    @Deprecated
    public void restart() {
        this.restart(ConfigBag.EMPTY);
    }

    protected boolean getDefaultRestartStopsMachine() {
        return false;
    }

    public void restart(ConfigBag parameters) {
        ServiceStateLogic.setExpectedState((Entity)this.entity(), (Lifecycle)Lifecycle.STOPPING);
        SoftwareProcess.RestartSoftwareParameters.RestartMachineMode isRestartMachine = (SoftwareProcess.RestartSoftwareParameters.RestartMachineMode)((Object)parameters.get(SoftwareProcess.RestartSoftwareParameters.RESTART_MACHINE_TYPED));
        if (isRestartMachine == null) {
            isRestartMachine = SoftwareProcess.RestartSoftwareParameters.RestartMachineMode.AUTO;
        }
        if (isRestartMachine == SoftwareProcess.RestartSoftwareParameters.RestartMachineMode.AUTO) {
            isRestartMachine = this.getDefaultRestartStopsMachine() ? SoftwareProcess.RestartSoftwareParameters.RestartMachineMode.TRUE : SoftwareProcess.RestartSoftwareParameters.RestartMachineMode.FALSE;
        }
        DynamicTasks.queue((String)"pre-restart", (Runnable)new Runnable(){

            @Override
            public void run() {
                MachineLifecycleEffectorTasks.this.preRestartCustom();
            }
        });
        if (isRestartMachine == SoftwareProcess.RestartSoftwareParameters.RestartMachineMode.FALSE) {
            DynamicTasks.queue((String)"stopping (process)", (Callable)new Callable<String>(){

                @Override
                public String call() {
                    DynamicTasks.markInessential();
                    MachineLifecycleEffectorTasks.this.stopProcessesAtMachine();
                    DynamicTasks.waitForLast();
                    return "Stop of process completed with no errors.";
                }
            });
        } else {
            DynamicTasks.queue((String)"stopping (machine)", (Callable)new Callable<String>(){

                @Override
                public String call() {
                    DynamicTasks.markInessential();
                    MachineLifecycleEffectorTasks.this.stop(ConfigBag.newInstance().configure(SoftwareProcess.StopSoftwareParameters.STOP_MACHINE_MODE, (Object)SoftwareProcess.StopSoftwareParameters.StopMode.IF_NOT_STOPPED));
                    DynamicTasks.waitForLast();
                    return "Stop of machine completed with no errors.";
                }
            });
        }
        DynamicTasks.queue((String)"starting", (Runnable)new Runnable(){

            @Override
            public void run() {
                ServiceStateLogic.setExpectedState((Entity)MachineLifecycleEffectorTasks.this.entity(), (Lifecycle)Lifecycle.STARTING);
                MachineLifecycleEffectorTasks.this.startInLocations(null);
            }
        });
        this.restartChildren(parameters);
        DynamicTasks.queue((String)"post-restart", (Runnable)new Runnable(){

            @Override
            public void run() {
                MachineLifecycleEffectorTasks.this.postRestartCustom();
            }
        });
        DynamicTasks.waitForLast();
        ServiceStateLogic.setExpectedState((Entity)this.entity(), (Lifecycle)Lifecycle.RUNNING);
    }

    protected void restartChildren(ConfigBag parameters) {
        Boolean isRestartChildren = (Boolean)parameters.get(SoftwareProcess.RestartSoftwareParameters.RESTART_CHILDREN);
        if (isRestartChildren == null || !isRestartChildren.booleanValue()) {
            return;
        }
        if (isRestartChildren.booleanValue()) {
            DynamicTasks.queue((TaskAdaptable)StartableMethods.restartingChildren((Entity)this.entity(), (ConfigBag)parameters));
            return;
        }
        throw new IllegalArgumentException("Invalid value '" + isRestartChildren + "' for " + SoftwareProcess.RestartSoftwareParameters.RESTART_CHILDREN.getName());
    }

    @Deprecated
    public void stop() {
        this.stop(ConfigBag.EMPTY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(ConfigBag parameters) {
        this.preStopConfirmCustom();
        log.info("Stopping {} in {}", (Object)this.entity(), (Object)this.entity().getLocations());
        SoftwareProcess.StopSoftwareParameters.StopMode stopMachineMode = MachineLifecycleEffectorTasks.getStopMachineMode(parameters);
        SoftwareProcess.StopSoftwareParameters.StopMode stopProcessMode = (SoftwareProcess.StopSoftwareParameters.StopMode)((Object)parameters.get(SoftwareProcess.StopSoftwareParameters.STOP_PROCESS_MODE));
        DynamicTasks.queue((String)"pre-stop", (Callable)new Callable<String>(){

            @Override
            public String call() {
                if (MachineLifecycleEffectorTasks.this.entity().getAttribute(SoftwareProcess.SERVICE_STATE_ACTUAL) == Lifecycle.STOPPED) {
                    log.debug("Skipping stop of entity " + MachineLifecycleEffectorTasks.this.entity() + " when already stopped");
                    return "Already stopped";
                }
                ServiceStateLogic.setExpectedState((Entity)MachineLifecycleEffectorTasks.this.entity(), (Lifecycle)Lifecycle.STOPPING);
                MachineLifecycleEffectorTasks.this.entity().setAttribute(SoftwareProcess.SERVICE_UP, (Object)false);
                MachineLifecycleEffectorTasks.this.preStopCustom();
                return null;
            }
        });
        Maybe machine = Machines.findUniqueMachineLocation((Iterable)this.entity().getLocations());
        Task stoppingProcess = null;
        if (MachineLifecycleEffectorTasks.canStop(stopProcessMode, (Entity)this.entity())) {
            stoppingProcess = DynamicTasks.queue((String)"stopping (process)", (Callable)new Callable<String>(){

                @Override
                public String call() {
                    DynamicTasks.markInessential();
                    MachineLifecycleEffectorTasks.this.stopProcessesAtMachine();
                    DynamicTasks.waitForLast();
                    return "Stop at machine completed with no errors.";
                }
            });
        }
        Task stoppingMachine = null;
        if (MachineLifecycleEffectorTasks.canStop(stopMachineMode, machine.isAbsent())) {
            stoppingMachine = DynamicTasks.queue((String)"stopping (machine)", (Callable)new Callable<StopMachineDetails<Integer>>(){

                @Override
                public StopMachineDetails<Integer> call() {
                    return MachineLifecycleEffectorTasks.this.stopAnyProvisionedMachines();
                }
            });
            DynamicTasks.drain((Duration)((Duration)this.entity().getConfig(STOP_PROCESS_TIMEOUT)), (boolean)false);
            Task task = stoppingMachine;
            synchronized (task) {
                if (!stoppingMachine.isSubmitted()) {
                    StringBuilder msg = new StringBuilder("Submitting machine stop early in background for ").append(this.entity());
                    if (stoppingProcess == null) {
                        msg.append(". Process stop skipped, pre-stop not finished?");
                    } else {
                        msg.append(" because process stop has ").append(stoppingProcess.isDone() ? "finished abnormally" : "not finished");
                    }
                    log.warn(msg.toString());
                    Entities.submit((Entity)this.entity(), (TaskAdaptable)stoppingMachine);
                }
            }
        }
        try {
            boolean checkStopProcesses;
            boolean bl = checkStopProcesses = stoppingProcess != null && (stoppingMachine == null || (Integer)((StopMachineDetails)stoppingMachine.get()).value == 0);
            if (checkStopProcesses) {
                DynamicTasks.waitForLast();
                if (machine.isPresent()) {
                    stoppingProcess.get();
                }
            }
        }
        catch (Throwable e) {
            ServiceStateLogic.setExpectedState((Entity)this.entity(), (Lifecycle)Lifecycle.ON_FIRE);
            Exceptions.propagate((Throwable)e);
        }
        this.entity().setAttribute(SoftwareProcess.SERVICE_UP, (Object)false);
        ServiceStateLogic.setExpectedState((Entity)this.entity(), (Lifecycle)Lifecycle.STOPPED);
        DynamicTasks.queue((String)"post-stop", (Callable)new Callable<Void>(){

            @Override
            public Void call() {
                MachineLifecycleEffectorTasks.this.postStopCustom();
                return null;
            }
        });
        if (log.isDebugEnabled()) {
            log.debug("Stopped software process entity " + this.entity());
        }
    }

    public static SoftwareProcess.StopSoftwareParameters.StopMode getStopMachineMode(ConfigBag parameters) {
        boolean hasStopMachine = parameters.containsKey(SoftwareProcess.StopSoftwareParameters.STOP_MACHINE);
        Boolean isStopMachine = (Boolean)parameters.get(SoftwareProcess.StopSoftwareParameters.STOP_MACHINE);
        boolean hasStopMachineMode = parameters.containsKey(SoftwareProcess.StopSoftwareParameters.STOP_MACHINE_MODE);
        SoftwareProcess.StopSoftwareParameters.StopMode stopMachineMode = (SoftwareProcess.StopSoftwareParameters.StopMode)((Object)parameters.get(SoftwareProcess.StopSoftwareParameters.STOP_MACHINE_MODE));
        if (hasStopMachine && isStopMachine != null) {
            MachineLifecycleEffectorTasks.checkCompatibleMachineModes(isStopMachine, hasStopMachineMode, stopMachineMode);
            if (isStopMachine.booleanValue()) {
                return SoftwareProcess.StopSoftwareParameters.StopMode.IF_NOT_STOPPED;
            }
            return SoftwareProcess.StopSoftwareParameters.StopMode.NEVER;
        }
        return stopMachineMode;
    }

    public static boolean canStop(SoftwareProcess.StopSoftwareParameters.StopMode stopMode, Entity entity) {
        boolean isEntityStopped = entity.getAttribute(SoftwareProcess.SERVICE_STATE_ACTUAL) == Lifecycle.STOPPED;
        return MachineLifecycleEffectorTasks.canStop(stopMode, isEntityStopped);
    }

    protected static boolean canStop(SoftwareProcess.StopSoftwareParameters.StopMode stopMode, boolean isStopped) {
        return stopMode == SoftwareProcess.StopSoftwareParameters.StopMode.ALWAYS || stopMode == SoftwareProcess.StopSoftwareParameters.StopMode.IF_NOT_STOPPED && !isStopped;
    }

    private static void checkCompatibleMachineModes(Boolean isStopMachine, boolean hasStopMachineMode, SoftwareProcess.StopSoftwareParameters.StopMode stopMachineMode) {
        if (hasStopMachineMode && (isStopMachine.booleanValue() && stopMachineMode != SoftwareProcess.StopSoftwareParameters.StopMode.IF_NOT_STOPPED || !isStopMachine.booleanValue() && stopMachineMode != SoftwareProcess.StopSoftwareParameters.StopMode.NEVER)) {
            throw new IllegalStateException("Incompatible values for " + SoftwareProcess.StopSoftwareParameters.STOP_MACHINE.getName() + " (" + isStopMachine + ") and " + SoftwareProcess.StopSoftwareParameters.STOP_MACHINE_MODE.getName() + " (" + (Object)((Object)stopMachineMode) + "). " + "Use only one of the parameters.");
        }
    }

    protected void preStopConfirmCustom() {
    }

    protected void preStopCustom() {
    }

    protected void postStopCustom() {
    }

    protected void preRestartCustom() {
    }

    protected void postRestartCustom() {
    }

    protected abstract String stopProcessesAtMachine();

    protected StopMachineDetails<Integer> stopAnyProvisionedMachines() {
        MachineProvisioningLocation provisioner = (MachineProvisioningLocation)this.entity().getAttribute(SoftwareProcess.PROVISIONING_LOCATION);
        if (Iterables.isEmpty((Iterable)this.entity().getLocations())) {
            log.debug("No machine decommissioning necessary for " + this.entity() + " - no locations");
            return new StopMachineDetails<Integer>("No machine decommissioning necessary - no locations", 0);
        }
        if (provisioner == null) {
            log.debug("No machine decommissioning necessary for " + this.entity() + " - did not provision");
            return new StopMachineDetails<Integer>("No machine decommissioning necessary - did not provision", 0);
        }
        Location machine = this.getLocation(null);
        if (!(machine instanceof MachineLocation)) {
            log.debug("No decommissioning necessary for " + this.entity() + " - not a machine location (" + machine + ")");
            return new StopMachineDetails<Integer>("No machine decommissioning necessary - not a machine (" + machine + ")", 0);
        }
        try {
            this.entity().removeLocations((Collection)ImmutableList.of((Object)machine));
            this.entity().setAttribute(Attributes.HOSTNAME, null);
            this.entity().setAttribute(Attributes.ADDRESS, null);
            this.entity().setAttribute(Attributes.SUBNET_HOSTNAME, null);
            this.entity().setAttribute(Attributes.SUBNET_ADDRESS, null);
            if (provisioner != null) {
                provisioner.release((MachineLocation)machine);
            }
        }
        catch (Throwable t) {
            throw Exceptions.propagate((Throwable)t);
        }
        return new StopMachineDetails<Integer>("Decommissioned " + machine, 1);
    }

    public static class StopMachineDetails<T>
    implements Serializable {
        private static final long serialVersionUID = 3256747214315895431L;
        final String message;
        final T value;

        protected StopMachineDetails(String message, T value) {
            this.message = message;
            this.value = value;
        }

        public String toString() {
            return this.message;
        }
    }
}

