/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.service;

import brooklyn.config.ConfigKey;
import brooklyn.enricher.basic.AbstractEnricher;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.Attributes;
import brooklyn.entity.basic.BrooklynTaskTags;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.basic.SoftwareProcess;
import brooklyn.entity.effector.EffectorTasks;
import brooklyn.entity.service.EntityLaunchListener;
import brooklyn.entity.service.SystemServiceInstallerFactory;
import brooklyn.event.Sensor;
import brooklyn.location.basic.SshMachineLocation;
import brooklyn.management.ExecutionContext;
import brooklyn.management.Task;
import brooklyn.management.TaskAdaptable;
import brooklyn.management.TaskFactory;
import brooklyn.policy.Enricher;
import brooklyn.util.net.Urls;
import brooklyn.util.task.BasicExecutionManager;
import brooklyn.util.task.DynamicTasks;
import brooklyn.util.task.TaskBuilder;
import brooklyn.util.task.ssh.SshPutTaskWrapper;
import brooklyn.util.task.ssh.SshTasks;
import brooklyn.util.task.system.ProcessTaskFactory;
import brooklyn.util.task.system.ProcessTaskWrapper;
import com.google.common.collect.ImmutableSet;
import java.util.Set;

public class SystemServiceEnricher
extends AbstractEnricher
implements Enricher {
    public static final String DEFAULT_ENRICHER_UNIQUE_TAG = "systemService.tag";
    protected static final Set<String> LAUNCH_EFFECTOR_NAMES = ImmutableSet.of((Object)"start", (Object)"restart");
    public static final ConfigKey<String> LAUNCH_SCRIPT_NAME = ConfigKeys.newStringConfigKey((String)"service.script_name", (String)"The name of the launch script to be created in the runtime directory of the entity.", (String)"service-launch.sh");
    public static final ConfigKey<String> SERVICE_NAME = ConfigKeys.newStringConfigKey((String)"service.name", (String)"The name of the system service. Can use ${entity_name} and ${id} variables to template the value.", (String)"${entity_name}-${id}");

    public void setEntity(EntityLocal entity) {
        super.setEntity(entity);
        this.subscribeLaunch();
        this.uniqueTag = DEFAULT_ENRICHER_UNIQUE_TAG;
    }

    private void subscribeLaunch() {
        this.subscribe((Entity)this.entity, (Sensor)Attributes.SERVICE_STATE_ACTUAL, new EntityLaunchListener(this));
    }

    public void onLaunched(Task<?> task) {
        BrooklynTaskTags.WrappedStream streamStdin = BrooklynTaskTags.stream(task, (String)"stdin");
        if (streamStdin == null) {
            return;
        }
        BrooklynTaskTags.WrappedStream streamEnv = BrooklynTaskTags.stream(task, (String)"env");
        String stdin = (String)streamStdin.streamContents.get();
        String env = (String)streamEnv.streamContents.get();
        final SshMachineLocation sshMachine = EffectorTasks.getSshMachine((Entity)this.entity);
        final String launchScriptPath = Urls.mergePaths((String[])new String[]{this.getRunDir(), this.getStartScriptName()});
        Task installerTask = TaskBuilder.builder().name("install (service)").description("Install as a system service").body(new Runnable(){

            @Override
            public void run() {
                boolean isInstalled;
                ProcessTaskFactory taskFactory = SshTasks.newSshExecTaskFactory((SshMachineLocation)sshMachine, (String[])new String[]{"[ -e '" + launchScriptPath + "' ]"}).summary("check installed").allowingNonZeroExitCode();
                boolean bl = isInstalled = (Integer)((ProcessTaskWrapper)DynamicTasks.queue((TaskFactory)taskFactory)).get() == 0;
                if (!isInstalled) {
                    Task<?> serviceInstallTask = SystemServiceInstallerFactory.of((Entity)SystemServiceEnricher.this.entity, SystemServiceEnricher.this).getServiceInstallTask();
                    DynamicTasks.queue(serviceInstallTask);
                }
            }
        }).build();
        SshPutTaskWrapper updateLaunchScriptTask = SshTasks.newSshPutTaskFactory((SshMachineLocation)sshMachine, (String)launchScriptPath).contents(this.getLaunchScript(stdin, env)).newTask();
        ProcessTaskWrapper makeExecutableTask = (ProcessTaskWrapper)SshTasks.newSshExecTaskFactory((SshMachineLocation)sshMachine, (String[])new String[]{"chmod +x " + launchScriptPath}).requiringExitCodeZero().newTask();
        Task udpateTask = TaskBuilder.builder().name("update-launch").description("Update launch script used by the system service").add((TaskAdaptable)updateLaunchScriptTask).add((TaskAdaptable)makeExecutableTask).build();
        Task updateService = TaskBuilder.builder().name("update-system-service").description("Update system service").add((TaskAdaptable)installerTask).add((TaskAdaptable)udpateTask).tag((Object)BrooklynTaskTags.tagForContextEntity((Entity)this.entity)).tag((Object)"NON-TRANSIENT").build();
        this.submitTopLevel((Task<Void>)updateService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitTopLevel(Task<Void> updateService) {
        Task currentTask = (Task)BasicExecutionManager.getPerThreadCurrentTask().get();
        BasicExecutionManager.getPerThreadCurrentTask().set(null);
        try {
            Entities.submit((Entity)this.entity, updateService);
        }
        finally {
            BasicExecutionManager.getPerThreadCurrentTask().set(currentTask);
        }
    }

    private String getLaunchScript(String stdin, String env) {
        return env.replaceAll("(?m)^", "export ") + "\n" + stdin;
    }

    private String getRunDir() {
        return (String)this.entity.getAttribute(SoftwareProcess.RUN_DIR);
    }

    private String getStartScriptName() {
        return (String)this.config().get(LAUNCH_SCRIPT_NAME);
    }

    ExecutionContext getEntityExecutionContext() {
        return this.getManagementContext().getExecutionContext((Entity)this.entity);
    }

    protected Entity getEntity() {
        return this.entity;
    }
}

