/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.pool;

import brooklyn.entity.Entity;
import brooklyn.entity.pool.ServerPoolLocation;
import brooklyn.location.Location;
import brooklyn.location.LocationRegistry;
import brooklyn.location.LocationResolver;
import brooklyn.location.LocationSpec;
import brooklyn.location.basic.BasicLocationRegistry;
import brooklyn.location.basic.LocationInternal;
import brooklyn.location.basic.LocationPropertiesFromBrooklynProperties;
import brooklyn.location.dynamic.DynamicLocation;
import brooklyn.management.ManagementContext;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.text.KeyValueParser;
import brooklyn.util.text.Strings;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerPoolLocationResolver
implements LocationResolver.EnableableLocationResolver {
    private static final Logger LOG = LoggerFactory.getLogger(ServerPoolLocationResolver.class);
    private static final String PREFIX = "pool";
    public static final String POOL_SPEC = "pool:%s";
    private static final Pattern PATTERN = Pattern.compile("(pool|" + "pool".toUpperCase() + ")" + ":([a-zA-Z0-9]+)" + "(:\\((.*)\\))?$");
    private static final Set<String> ACCEPTABLE_ARGS = ImmutableSet.of((Object)"name", (Object)"displayName");
    private ManagementContext managementContext;

    public boolean isEnabled() {
        return true;
    }

    public void init(ManagementContext managementContext) {
        this.managementContext = (ManagementContext)Preconditions.checkNotNull((Object)managementContext, (Object)"managementContext");
    }

    public String getPrefix() {
        return PREFIX;
    }

    public boolean accepts(String spec, LocationRegistry registry) {
        return BasicLocationRegistry.isResolverPrefixForSpec((LocationResolver)this, (String)spec, (boolean)true);
    }

    public Location newLocationFromString(Map locationFlags, String spec, LocationRegistry registry) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Resolving location '" + spec + "' with flags " + Joiner.on((String)",").withKeyValueSeparator("=").join(locationFlags));
        }
        String namedLocation = (String)locationFlags.get(LocationInternal.NAMED_SPEC_NAME.getName());
        Matcher matcher = PATTERN.matcher(spec);
        if (!matcher.matches()) {
            String m = String.format("Invalid location '%s'; must specify either %s:entityId or %s:entityId:(key=argument)", spec, PREFIX, PREFIX);
            throw new IllegalArgumentException(m);
        }
        String argsPart = matcher.group(4);
        Map argsMap = argsPart != null ? KeyValueParser.parseMap((String)argsPart) : Collections.emptyMap();
        String displayNamePart = (String)argsMap.get("displayName");
        String namePart = (String)argsMap.get("name");
        if (!ACCEPTABLE_ARGS.containsAll(argsMap.keySet())) {
            Sets.SetView illegalArgs = Sets.difference(argsMap.keySet(), ACCEPTABLE_ARGS);
            throw new IllegalArgumentException("Invalid location '" + spec + "'; illegal args " + illegalArgs + "; acceptable args are " + ACCEPTABLE_ARGS);
        }
        if (argsMap.containsKey("displayName") && Strings.isEmpty((CharSequence)displayNamePart)) {
            throw new IllegalArgumentException("Invalid location '" + spec + "'; if displayName supplied then value must be non-empty");
        }
        if (argsMap.containsKey("name") && Strings.isEmpty((CharSequence)namePart)) {
            throw new IllegalArgumentException("Invalid location '" + spec + "'; if name supplied then value must be non-empty");
        }
        Map filteredProperties = new LocationPropertiesFromBrooklynProperties().getLocationProperties(PREFIX, namedLocation, registry.getProperties());
        MutableMap flags = MutableMap.builder().putAll(filteredProperties).putAll(locationFlags).build();
        String poolId = matcher.group(2);
        if (Strings.isBlank((CharSequence)poolId)) {
            throw new IllegalArgumentException("Invalid location '" + spec + "'; pool's entity id must be non-empty");
        }
        String displayName = displayNamePart != null ? displayNamePart : "Server Pool " + poolId;
        String locationName = namePart != null ? namePart : "serverpool-" + poolId;
        Entity pool = this.managementContext.getEntityManager().getEntity(poolId);
        LocationSpec locationSpec = (LocationSpec)LocationSpec.create(ServerPoolLocation.class).configure((Map)flags).configure(DynamicLocation.OWNER, (Object)pool).configure(LocationInternal.NAMED_SPEC_NAME, (Object)locationName).displayName(displayName);
        return this.managementContext.getLocationManager().createLocation(locationSpec);
    }
}

