/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.pool;

import brooklyn.config.ConfigKey;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.pool.ServerPool;
import brooklyn.location.MachineLocation;
import brooklyn.location.MachineProvisioningLocation;
import brooklyn.location.NoMachinesAvailableException;
import brooklyn.location.basic.AbstractLocation;
import brooklyn.location.dynamic.DynamicLocation;
import brooklyn.util.flags.SetFromFlag;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerPoolLocation
extends AbstractLocation
implements MachineProvisioningLocation<MachineLocation>,
DynamicLocation<ServerPool, ServerPoolLocation> {
    private static final long serialVersionUID = -6771844611899475409L;
    private static final Logger LOG = LoggerFactory.getLogger(ServerPoolLocation.class);
    @SetFromFlag(value="owner")
    public static final ConfigKey<ServerPool> OWNER = ConfigKeys.newConfigKey(ServerPool.class, (String)"pool.location.owner");

    public void init() {
        LOG.debug("Initialising. Owner is: {}", Preconditions.checkNotNull((Object)this.getConfig(OWNER), (Object)OWNER.getName()));
        super.init();
    }

    public ServerPool getOwner() {
        return (ServerPool)this.getConfig(OWNER);
    }

    public MachineLocation obtain(Map<?, ?> flags) throws NoMachinesAvailableException {
        return this.getOwner().claimMachine(flags);
    }

    public MachineProvisioningLocation<MachineLocation> newSubLocation(Map<?, ?> newFlags) {
        throw new UnsupportedOperationException();
    }

    public void release(MachineLocation machine) {
        this.getOwner().releaseMachine(machine);
    }

    public Map<String, Object> getProvisioningFlags(Collection<String> tags) {
        return Maps.newLinkedHashMap();
    }
}

