/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.pool;

import brooklyn.catalog.Catalog;
import brooklyn.config.ConfigKey;
import brooklyn.entity.Entity;
import brooklyn.entity.annotation.Effector;
import brooklyn.entity.annotation.EffectorParam;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.MethodEffector;
import brooklyn.entity.group.DynamicCluster;
import brooklyn.entity.machine.MachineEntity;
import brooklyn.entity.pool.ServerPoolImpl;
import brooklyn.entity.pool.ServerPoolLocation;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.entity.proxying.ImplementedBy;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.Sensors;
import brooklyn.location.MachineLocation;
import brooklyn.location.NoMachinesAvailableException;
import brooklyn.location.dynamic.LocationOwner;
import com.google.common.annotations.Beta;
import java.util.Collection;
import java.util.Map;

@Catalog(name="Server Pool", description="Creates a pre-allocated server pool, which other applications can deploy to")
@ImplementedBy(value=ServerPoolImpl.class)
@Beta
public interface ServerPool
extends DynamicCluster,
LocationOwner<ServerPoolLocation, ServerPool> {
    public static final ConfigKey<Integer> INITIAL_SIZE = ConfigKeys.newConfigKeyWithDefault((ConfigKey)DynamicCluster.INITIAL_SIZE, (Object)2);
    public static final AttributeSensor<Integer> AVAILABLE_COUNT = Sensors.newIntegerSensor((String)"pool.available", (String)"The number of locations in the pool that are unused");
    public static final AttributeSensor<Integer> CLAIMED_COUNT = Sensors.newIntegerSensor((String)"pool.claimed", (String)"The number of locations in the pool that are in use");
    public static final ConfigKey<EntitySpec<?>> MEMBER_SPEC = ConfigKeys.newConfigKeyWithDefault((ConfigKey)DynamicCluster.MEMBER_SPEC, (Object)EntitySpec.create(MachineEntity.class));
    public static final MethodEffector<Collection<Entity>> ADD_MACHINES_FROM_SPEC = new MethodEffector(ServerPool.class, "addExistingMachinesFromSpec");

    public MachineLocation claimMachine(Map<?, ?> var1) throws NoMachinesAvailableException;

    public void releaseMachine(MachineLocation var1);

    public Entity addExistingMachine(MachineLocation var1);

    @Effector(description="Adds additional machines to the pool by resolving the given spec.")
    public Collection<Entity> addExistingMachinesFromSpec(@EffectorParam(name="spec", description="Spec") String var1);
}

