/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.machine;

import brooklyn.entity.Entity;
import brooklyn.entity.basic.AbstractSoftwareProcessSshDriver;
import brooklyn.entity.basic.EmptySoftwareProcessDriver;
import brooklyn.entity.basic.EmptySoftwareProcessImpl;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.machine.MachineAttributes;
import brooklyn.entity.machine.MachineEntity;
import brooklyn.entity.software.SshEffectorTasks;
import brooklyn.event.feed.ssh.SshFeed;
import brooklyn.event.feed.ssh.SshPollConfig;
import brooklyn.event.feed.ssh.SshPollValue;
import brooklyn.location.basic.Machines;
import brooklyn.location.basic.SshMachineLocation;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.task.DynamicTasks;
import brooklyn.util.task.system.ProcessTaskWrapper;
import brooklyn.util.text.Strings;
import brooklyn.util.time.Duration;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Splitter;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MachineEntityImpl
extends EmptySoftwareProcessImpl
implements MachineEntity {
    private static final Logger LOG = LoggerFactory.getLogger(MachineEntityImpl.class);
    private transient SshFeed sensorFeed;

    @Override
    public void init() {
        LOG.info("Starting server pool machine with id {}", (Object)this.getId());
        super.init();
    }

    @Override
    protected void connectSensors() {
        super.connectSensors();
        if (!this.getMachine().getMachineDetails().getOsDetails().isLinux()) {
            return;
        }
        this.sensorFeed = SshFeed.builder().entity((EntityLocal)this).period(Duration.THIRTY_SECONDS).poll((SshPollConfig)((SshPollConfig)new SshPollConfig(UPTIME).command("cat /proc/uptime").onFailureOrException(Functions.constant(null))).onSuccess((Function)new Function<SshPollValue, Duration>(){

            public Duration apply(SshPollValue input) {
                return Duration.seconds((Number)Double.valueOf(Strings.getFirstWord((String)input.getStdout())));
            }
        })).poll((SshPollConfig)((SshPollConfig)new SshPollConfig(LOAD_AVERAGE).command("uptime").onFailureOrException(Functions.constant((Object)-1.0))).onSuccess((Function)new Function<SshPollValue, Double>(){

            public Double apply(SshPollValue input) {
                String loadAverage = Strings.getFirstWordAfter((String)input.getStdout(), (String)"load average:").replace(",", "");
                return Double.valueOf(loadAverage);
            }
        })).poll((SshPollConfig)((SshPollConfig)new SshPollConfig(CPU_USAGE).command("cat /proc/stat").onFailureOrException(Functions.constant((Object)-1.0))).onSuccess((Function)new Function<SshPollValue, Double>(){

            public Double apply(SshPollValue input) {
                List cpuData = Splitter.on((String)" ").omitEmptyStrings().splitToList((CharSequence)Strings.getFirstLine((String)input.getStdout()));
                Integer system = Integer.parseInt((String)cpuData.get(1));
                Integer user = Integer.parseInt((String)cpuData.get(3));
                Integer idle = Integer.parseInt((String)cpuData.get(4));
                return (double)(system + user) / (double)(system + user + idle);
            }
        })).poll((SshPollConfig)((SshPollConfig)new SshPollConfig(USED_MEMORY).command("free | grep Mem:").onFailureOrException(Functions.constant((Object)-1L))).onSuccess((Function)new Function<SshPollValue, Long>(){

            public Long apply(SshPollValue input) {
                List memoryData = Splitter.on((String)" ").omitEmptyStrings().splitToList((CharSequence)Strings.getFirstLine((String)input.getStdout()));
                return Long.parseLong((String)memoryData.get(2));
            }
        })).poll((SshPollConfig)((SshPollConfig)new SshPollConfig(FREE_MEMORY).command("free | grep Mem:").onFailureOrException(Functions.constant((Object)-1L))).onSuccess((Function)new Function<SshPollValue, Long>(){

            public Long apply(SshPollValue input) {
                List memoryData = Splitter.on((String)" ").omitEmptyStrings().splitToList((CharSequence)Strings.getFirstLine((String)input.getStdout()));
                return Long.parseLong((String)memoryData.get(3));
            }
        })).poll((SshPollConfig)((SshPollConfig)new SshPollConfig(TOTAL_MEMORY).command("free | grep Mem:").onFailureOrException(Functions.constant((Object)-1L))).onSuccess((Function)new Function<SshPollValue, Long>(){

            public Long apply(SshPollValue input) {
                List memoryData = Splitter.on((String)" ").omitEmptyStrings().splitToList((CharSequence)Strings.getFirstLine((String)input.getStdout()));
                return Long.parseLong((String)memoryData.get(1));
            }
        })).build();
    }

    @Override
    public void disconnectSensors() {
        if (this.sensorFeed != null) {
            this.sensorFeed.stop();
        }
        super.disconnectSensors();
    }

    @Override
    public Class<?> getDriverInterface() {
        return EmptySoftwareProcessDriver.class;
    }

    public SshMachineLocation getMachine() {
        return (SshMachineLocation)Machines.findUniqueSshMachineLocation((Iterable)this.getLocations()).get();
    }

    @Override
    public String execCommand(String command) {
        return this.execCommandTimeout(command, Duration.ONE_MINUTE);
    }

    @Override
    public String execCommandTimeout(String command, Duration timeout) {
        ProcessTaskWrapper task = ((SshEffectorTasks.SshEffectorTaskFactory)((SshEffectorTasks.SshEffectorTaskFactory)((SshEffectorTasks.SshEffectorTaskFactory)SshEffectorTasks.ssh(command).environmentVariables(((AbstractSoftwareProcessSshDriver)this.getDriver()).getShellEnvironment())).requiringZeroAndReturningStdout().machine(this.getMachine())).summary(command)).newTask();
        try {
            String result = (String)DynamicTasks.queueIfPossible(task).executionContext((Entity)this).orSubmitAsync().asTask().get(timeout);
            return result;
        }
        catch (TimeoutException te) {
            throw new IllegalStateException("Timed out running command: " + command);
        }
        catch (Exception e) {
            Integer exitCode = task.getExitCode();
            LOG.warn("Command failed, return code {}: {}", (Object)(exitCode == null ? -1 : exitCode), (Object)task.getStderr());
            throw Exceptions.propagate((Throwable)e);
        }
    }

    static {
        MachineAttributes.init();
    }
}

