/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.machine;

import brooklyn.catalog.Catalog;
import brooklyn.entity.annotation.Effector;
import brooklyn.entity.annotation.EffectorParam;
import brooklyn.entity.basic.EmptySoftwareProcess;
import brooklyn.entity.basic.MethodEffector;
import brooklyn.entity.machine.MachineAttributes;
import brooklyn.entity.machine.MachineEntityImpl;
import brooklyn.entity.proxying.ImplementedBy;
import brooklyn.event.AttributeSensor;
import brooklyn.util.time.Duration;

@Catalog(name="Machine Entity", description="Represents a machine, providing metrics about it (e.g. obtained from ssh)")
@ImplementedBy(value=MachineEntityImpl.class)
public interface MachineEntity
extends EmptySoftwareProcess {
    public static final AttributeSensor<Duration> UPTIME = MachineAttributes.UPTIME;
    public static final AttributeSensor<Double> LOAD_AVERAGE = MachineAttributes.LOAD_AVERAGE;
    public static final AttributeSensor<Double> CPU_USAGE = MachineAttributes.CPU_USAGE;
    public static final AttributeSensor<Long> FREE_MEMORY = MachineAttributes.FREE_MEMORY;
    public static final AttributeSensor<Long> TOTAL_MEMORY = MachineAttributes.TOTAL_MEMORY;
    public static final AttributeSensor<Long> USED_MEMORY = MachineAttributes.USED_MEMORY;
    public static final MethodEffector<String> EXEC_COMMAND = new MethodEffector(MachineEntity.class, "execCommand");
    public static final MethodEffector<String> EXEC_COMMAND_TIMEOUT = new MethodEffector(MachineEntity.class, "execCommandTimeout");

    @Effector(description="Execute a command and return the output")
    public String execCommand(@EffectorParam(name="command", description="Command") String var1);

    @Effector(description="Execute a command and return the output")
    public String execCommandTimeout(@EffectorParam(name="command", description="Command") String var1, @EffectorParam(name="timeout", description="Timeout") Duration var2);
}

