/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.java;

import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.basic.lifecycle.ScriptHelper;
import brooklyn.entity.java.JavaSoftwareProcessSshDriver;
import brooklyn.entity.java.VanillaJavaApp;
import brooklyn.entity.java.VanillaJavaAppDriver;
import brooklyn.entity.java.VanillaJavaAppImpl;
import brooklyn.location.basic.SshMachineLocation;
import brooklyn.management.ExecutionContext;
import brooklyn.util.collections.MutableList;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.file.ArchiveBuilder;
import brooklyn.util.file.ArchiveUtils;
import brooklyn.util.internal.ssh.SshTool;
import brooklyn.util.net.Urls;
import brooklyn.util.os.Os;
import brooklyn.util.task.Tasks;
import brooklyn.util.text.StringEscapes;
import brooklyn.util.text.Strings;
import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class VanillaJavaAppSshDriver
extends JavaSoftwareProcessSshDriver
implements VanillaJavaAppDriver {
    static final int NUM_RETRIES_FOR_COPYING = 4;

    public VanillaJavaAppSshDriver(VanillaJavaAppImpl entity, SshMachineLocation machine) {
        super((EntityLocal)entity, machine);
    }

    public VanillaJavaAppImpl getEntity() {
        return (VanillaJavaAppImpl)super.getEntity();
    }

    @Override
    protected String getLogFileLocation() {
        return Os.mergePathsUnix((String[])new String[]{this.getRunDir(), "console"});
    }

    @Override
    public void install() {
        this.newScript("installing").execute();
    }

    @Override
    public void customize() {
        this.newScript((String)"customizing").body.append((CharSequence)String.format("mkdir -p %s/lib", this.getRunDir())).failOnNonZeroResultCode().execute();
        SshMachineLocation machine = this.getMachine();
        VanillaJavaAppImpl entity = this.getEntity();
        for (String entry : entity.getClasspath()) {
            if (Urls.isDirectory((String)entry)) {
                File jarFile = ArchiveBuilder.jar().addDirContentsAt(new File(entry), "").create();
                entry = jarFile.getAbsolutePath();
            }
            String destFile = entry.contains("?") ? entry.substring(0, entry.indexOf(63)) : entry;
            destFile = destFile.substring(destFile.lastIndexOf(47) + 1);
            ArchiveUtils.deploy((Map)MutableMap.of(), (String)entry, (SshMachineLocation)machine, (String)this.getRunDir(), (String)Os.mergePaths((String[])new String[]{this.getRunDir(), "lib"}), (String)destFile);
        }
        ScriptHelper helper = this.newScript((String)"customizing-classpath").body.append((CharSequence)String.format("ls -1 \"%s\"", Os.mergePaths((String[])new String[]{this.getRunDir(), "lib"}))).gatherOutput();
        helper.setFlag(SshTool.PROP_NO_EXTRA_OUTPUT, true);
        int result = helper.execute();
        if (result != 0) {
            throw new IllegalStateException("Error listing classpath files: " + helper.getResultStderr());
        }
        String stdout = helper.getResultStdout();
        if (Strings.isBlank((CharSequence)stdout)) {
            this.getEntity().setAttribute(VanillaJavaApp.CLASSPATH_FILES, ImmutableList.of((Object)Os.mergePaths((String[])new String[]{this.getRunDir(), "lib"})));
        } else {
            Iterable lines = Splitter.on((CharMatcher)CharMatcher.BREAKING_WHITESPACE).omitEmptyStrings().trimResults().split((CharSequence)stdout);
            Iterable files = Iterables.transform((Iterable)lines, (Function)new Function<String, String>(){

                public String apply(@Nullable String input) {
                    return Os.mergePathsUnix((String[])new String[]{VanillaJavaAppSshDriver.this.getRunDir(), "lib", input});
                }
            });
            this.getEntity().setAttribute(VanillaJavaApp.CLASSPATH_FILES, ImmutableList.copyOf((Iterable)files));
        }
    }

    public String getClasspath() {
        List files = (List)this.getEntity().getAttribute(VanillaJavaApp.CLASSPATH_FILES);
        if (files == null || files.isEmpty()) {
            return null;
        }
        return Joiner.on((String)":").join((Iterable)files);
    }

    @Override
    public void launch() {
        String clazz = this.getEntity().getMainClass();
        String args = this.getArgs();
        this.newScript(MutableMap.of((Object)"usePidFile", (Object)Boolean.valueOf((boolean)true)), (String)"launching").body.append(String.format("echo \"launching: java $JAVA_OPTS %s %s\"", clazz, args), String.format("java $JAVA_OPTS -cp \"%s\" %s %s >> %s/console 2>&1 </dev/null &", this.getClasspath(), clazz, args, this.getRunDir())).execute();
    }

    public String getArgs() {
        List args = (List)this.getEntity().getConfig(VanillaJavaApp.ARGS);
        StringBuilder sb = new StringBuilder();
        Iterator it = args.iterator();
        while (it.hasNext()) {
            Object argO = it.next();
            try {
                String arg = (String)Tasks.resolveValue(argO, String.class, (ExecutionContext)this.getEntity().getExecutionContext());
                StringEscapes.BashStringEscapes.assertValidForDoubleQuotingInBash((String)arg);
                sb.append(String.format("\"%s\"", arg));
            }
            catch (Exception e) {
                throw Exceptions.propagate((Throwable)e);
            }
            if (!it.hasNext()) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    @Override
    public boolean isRunning() {
        int result = this.newScript((Map<String, ?>)MutableMap.of((Object)"usePidFile", (Object)true), "check-running").execute();
        return result == 0;
    }

    @Override
    public void stop() {
        this.newScript((Map<String, ?>)MutableMap.of((Object)"usePidFile", (Object)true), "stopping").execute();
    }

    @Override
    public void kill() {
        this.newScript((Map<String, ?>)MutableMap.of((Object)"usePidFile", (Object)true), "killing").execute();
    }

    @Override
    protected Map getCustomJavaSystemProperties() {
        return MutableMap.builder().putAll(super.getCustomJavaSystemProperties()).putAll(this.getEntity().getJvmDefines()).build();
    }

    @Override
    protected List<String> getCustomJavaConfigOptions() {
        return MutableList.builder().addAll(super.getCustomJavaConfigOptions()).addAll((Iterable)this.getEntity().getJvmXArgs()).build();
    }

    @Override
    public Map<String, String> getShellEnvironment() {
        return MutableMap.builder().putAll(super.getShellEnvironment()).putIfNotNull((Object)"CLASSPATH", (Object)this.getClasspath()).build();
    }
}

