/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.java;

import brooklyn.config.ConfigKey;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.SoftwareProcess;
import brooklyn.entity.java.UsesJava;
import brooklyn.entity.java.UsesJavaMXBeans;
import brooklyn.entity.java.UsesJmx;
import brooklyn.entity.java.VanillaJavaAppImpl;
import brooklyn.entity.proxying.ImplementedBy;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.Sensors;
import brooklyn.util.collections.MutableList;
import brooklyn.util.flags.SetFromFlag;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;

@ImplementedBy(value=VanillaJavaAppImpl.class)
public interface VanillaJavaApp
extends SoftwareProcess,
UsesJava,
UsesJmx,
UsesJavaMXBeans {
    @SetFromFlag(value="args")
    public static final ConfigKey<List> ARGS = ConfigKeys.newConfigKey(List.class, (String)"vanillaJavaApp.args", (String)"Arguments for launching the java app", (Object)Lists.newArrayList());
    @SetFromFlag(value="main", nullable=false)
    public static final ConfigKey<String> MAIN_CLASS = ConfigKeys.newStringConfigKey((String)"vanillaJavaApp.mainClass", (String)"class to launch");
    @SetFromFlag(value="classpath")
    public static final ConfigKey<List> CLASSPATH = ConfigKeys.newConfigKey(List.class, (String)"vanillaJavaApp.classpath", (String)"classpath to use, as list of URL entries; these URLs are copied to lib/ and expanded in the case of tar/tgz/zip", (Object)Lists.newArrayList());
    public static final AttributeSensor<List> CLASSPATH_FILES = Sensors.newSensor(List.class, (String)"vanillaJavaApp.classpathFiles", (String)"classpath used, list of files");
    @SetFromFlag(value="jvmXArgs")
    public static final ConfigKey<List> JVM_XARGS = ConfigKeys.newConfigKey(List.class, (String)"vanillaJavaApp.jvmXArgs", (String)"JVM -X args for the java app (e.g. memory)", (Object)MutableList.of((Object)"-Xms128m", (Object)"-Xmx512m", (Object[])new String[]{"-XX:MaxPermSize=512m"}));
    @SetFromFlag(value="jvmDefines")
    public static final ConfigKey<Map> JVM_DEFINES = ConfigKeys.newConfigKey(Map.class, (String)"vanillaJavaApp.jvmDefines", (String)"JVM system property definitions for the app", (Object)Maps.newLinkedHashMap());

    public String getMainClass();

    public List<String> getClasspath();

    public List<String> getClasspathFiles();

    public Map getJvmDefines();

    public List getJvmXArgs();

    public String getRunDir();

    public void kill();
}

