/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.java;

import brooklyn.config.ConfigKey;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.java.UsesJava;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.AttributeSensorAndConfigKey;
import brooklyn.event.basic.BasicAttributeSensorAndConfigKey;
import brooklyn.event.basic.BasicConfigKey;
import brooklyn.event.basic.PortAttributeSensorAndConfigKey;
import brooklyn.location.PortRange;
import brooklyn.location.basic.PortRanges;
import brooklyn.util.flags.SetFromFlag;
import java.security.PrivateKey;
import java.security.cert.Certificate;

public interface UsesJmx
extends UsesJava {
    public static final int DEFAULT_JMX_PORT = 1099;
    @SetFromFlag(value="useJmx")
    public static final ConfigKey<Boolean> USE_JMX = ConfigKeys.newConfigKey((String)"jmx.enabled", (String)"JMX enabled", (Object)Boolean.TRUE);
    @SetFromFlag(value="jmxPort")
    public static final PortAttributeSensorAndConfigKey JMX_PORT = new PortAttributeSensorAndConfigKey("jmx.direct.port", "JMX direct/private port (e.g. JMX RMI server port, or JMXMP port, but not RMI registry port)", (Object)PortRanges.fromString((String)"31001+"));
    @Deprecated
    public static final PortAttributeSensorAndConfigKey JMX_PORT_LEGACY = new PortAttributeSensorAndConfigKey("jmx.direct.port.legacy.NOT_USED", "Legacy definition JMX direct/private port (e.g. JMX RMI server port, or JMXMP port, but not RMI registry port)", null){
        private static final long serialVersionUID = 3846846080809179437L;

        protected Integer convertConfigToSensor(PortRange value, Entity entity) {
            return super.convertConfigToSensor(value, entity);
        }
    };
    @SetFromFlag(value="rmiRegistryPort")
    public static final PortAttributeSensorAndConfigKey RMI_REGISTRY_PORT = ConfigKeys.newPortSensorAndConfigKey((String)"rmi.registry.port", (String)"RMI registry port, used for discovering JMX (private) port", (Object)PortRanges.fromString((String)"1099,19099+"));
    @SetFromFlag(value="jmxContext")
    public static final AttributeSensorAndConfigKey<String, String> JMX_CONTEXT = ConfigKeys.newStringSensorAndConfigKey((String)"jmx.context", (String)"JMX context path", (String)"jmxrmi");
    public static final AttributeSensor<String> JMX_URL = new BasicAttributeSensorAndConfigKey(String.class, "jmx.service.url", "The URL for connecting to the MBean Server");
    @SetFromFlag(value="jmxSecure")
    public static final ConfigKey<Boolean> JMX_SSL_ENABLED = ConfigKeys.newBooleanConfigKey((String)"jmx.ssl.enabled", (String)"JMX over JMXMP enabled with SSL/TLS", (Boolean)Boolean.FALSE);
    @SetFromFlag(value="jmxAgentMode")
    public static final ConfigKey<JmxAgentModes> JMX_AGENT_MODE = ConfigKeys.newConfigKey((String)"jmx.agent.mode", (String)"What type of JMX agent to use; defaults to null (autodetect) which means JMXMP_AND_RMI allowing firewall access through a single port as well as local access supporting jconsole (unless JMX_SSL_ENABLED is set, in which case it is JMXMP only)", (Object)((Object)JmxAgentModes.AUTODETECT));
    public static final AttributeSensorAndConfigKey<String, String> JMX_USER = ConfigKeys.newStringSensorAndConfigKey((String)"jmx.user", (String)"JMX username");
    public static final AttributeSensorAndConfigKey<String, String> JMX_PASSWORD = ConfigKeys.newStringSensorAndConfigKey((String)"jmx.password", (String)"JMX password");
    public static final AttributeSensorAndConfigKey<String, String> JMX_AGENT_LOCAL_PATH = ConfigKeys.newStringSensorAndConfigKey((String)"jmx.agent.local.path", (String)"Path to JMX driver on the local machine");
    public static final ConfigKey<PrivateKey> JMX_SSL_ACCESS_KEY = new BasicConfigKey(PrivateKey.class, "jmx.ssl.access.key", "key used to access a JMX agent (typically per entity, embedded in the managed JVM)", null);
    public static final ConfigKey<Certificate> JMX_SSL_ACCESS_CERT = new BasicConfigKey(Certificate.class, "jmx.ssl.access.cert", "certificate of key used to access a JMX agent", null);

    public static enum JmxAgentModes {
        AUTODETECT,
        JMXMP,
        JMXMP_AND_RMI,
        JMX_RMI_CUSTOM_AGENT,
        JMX_RMI,
        NONE;

    }
}

