/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.java;

import brooklyn.config.render.RendererHints;
import brooklyn.enricher.RollingTimeWindowMeanEnricher;
import brooklyn.enricher.TimeFractionDeltaEnricher;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.java.UsesJavaMXBeans;
import brooklyn.event.feed.http.HttpValueFunctions;
import brooklyn.event.feed.jmx.JmxAttributePollConfig;
import brooklyn.event.feed.jmx.JmxFeed;
import brooklyn.policy.Enricher;
import brooklyn.util.JavaGroovyEquivalents;
import brooklyn.util.math.MathFunctions;
import brooklyn.util.text.ByteSizeStrings;
import brooklyn.util.time.Duration;
import brooklyn.util.time.Time;
import com.google.common.base.Function;
import java.lang.management.MemoryUsage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.management.openmbean.CompositeData;

public class JavaAppUtils {
    private static final AtomicBoolean initialized = new AtomicBoolean(false);

    public static boolean isEntityMxBeanStatsEnabled(Entity entity) {
        return JavaGroovyEquivalents.groovyTruth((Object)entity.getConfig(UsesJavaMXBeans.MXBEAN_STATS_ENABLED));
    }

    @Nullable
    public static JmxFeed connectMXBeanSensors(EntityLocal entity) {
        if (JavaAppUtils.isEntityMxBeanStatsEnabled((Entity)entity)) {
            return JavaAppUtils.getMxBeanSensorsBuilder(entity).build();
        }
        return null;
    }

    @Nullable
    public static JmxFeed connectMXBeanSensors(EntityLocal entity, long jmxPollPeriodMs) {
        if (JavaAppUtils.isEntityMxBeanStatsEnabled((Entity)entity)) {
            return JavaAppUtils.getMxBeanSensorsBuilder(entity, jmxPollPeriodMs).build();
        }
        return null;
    }

    @Nullable
    public static JmxFeed connectMXBeanSensors(EntityLocal entity, Duration jmxPollPeriod) {
        if (JavaAppUtils.isEntityMxBeanStatsEnabled((Entity)entity)) {
            return JavaAppUtils.getMxBeanSensorsBuilder(entity, jmxPollPeriod).build();
        }
        return null;
    }

    public static void connectJavaAppServerPolicies(EntityLocal entity) {
        JavaAppUtils.connectJavaAppServerPolicies(entity, Duration.TEN_SECONDS);
    }

    public static void connectJavaAppServerPolicies(EntityLocal entity, Duration windowPeriod) {
        entity.addEnricher((Enricher)new TimeFractionDeltaEnricher((Entity)entity, UsesJavaMXBeans.PROCESS_CPU_TIME, UsesJavaMXBeans.PROCESS_CPU_TIME_FRACTION_LAST, TimeUnit.MILLISECONDS));
        entity.addEnricher((Enricher)new RollingTimeWindowMeanEnricher((Entity)entity, UsesJavaMXBeans.PROCESS_CPU_TIME_FRACTION_LAST, UsesJavaMXBeans.PROCESS_CPU_TIME_FRACTION_IN_WINDOW, windowPeriod));
    }

    @Nonnull
    public static JmxFeed.Builder getMxBeanSensorsBuilder(EntityLocal entity) {
        return JavaAppUtils.getMxBeanSensorsBuilder(entity, Duration.TEN_SECONDS);
    }

    @Nonnull
    public static JmxFeed.Builder getMxBeanSensorsBuilder(EntityLocal entity, long jmxPollPeriod) {
        return JavaAppUtils.getMxBeanSensorsBuilder(entity, Duration.millis((Number)jmxPollPeriod));
    }

    @Nonnull
    public static JmxFeed.Builder getMxBeanSensorsBuilder(EntityLocal entity, Duration jmxPollPeriod) {
        JmxFeed.Builder builder = JmxFeed.builder().entity(entity).period(jmxPollPeriod);
        if (JavaAppUtils.isEntityMxBeanStatsEnabled((Entity)entity)) {
            builder.pollAttribute((JmxAttributePollConfig)new JmxAttributePollConfig<Long>(UsesJavaMXBeans.USED_HEAP_MEMORY).objectName("java.lang:type=Memory").attributeName("HeapMemoryUsage").onSuccess(HttpValueFunctions.chain(JavaAppUtils.compositeDataToMemoryUsage(), (Function)new Function<MemoryUsage, Long>(){

                public Long apply(MemoryUsage input) {
                    return input == null ? null : Long.valueOf(input.getUsed());
                }
            }))).pollAttribute((JmxAttributePollConfig)new JmxAttributePollConfig<Long>(UsesJavaMXBeans.INIT_HEAP_MEMORY).objectName("java.lang:type=Memory").attributeName("HeapMemoryUsage").onSuccess(HttpValueFunctions.chain(JavaAppUtils.compositeDataToMemoryUsage(), (Function)new Function<MemoryUsage, Long>(){

                public Long apply(MemoryUsage input) {
                    return input == null ? null : Long.valueOf(input.getInit());
                }
            }))).pollAttribute((JmxAttributePollConfig)new JmxAttributePollConfig<Long>(UsesJavaMXBeans.COMMITTED_HEAP_MEMORY).objectName("java.lang:type=Memory").attributeName("HeapMemoryUsage").onSuccess(HttpValueFunctions.chain(JavaAppUtils.compositeDataToMemoryUsage(), (Function)new Function<MemoryUsage, Long>(){

                public Long apply(MemoryUsage input) {
                    return input == null ? null : Long.valueOf(input.getCommitted());
                }
            }))).pollAttribute((JmxAttributePollConfig)new JmxAttributePollConfig<Long>(UsesJavaMXBeans.MAX_HEAP_MEMORY).objectName("java.lang:type=Memory").attributeName("HeapMemoryUsage").onSuccess(HttpValueFunctions.chain(JavaAppUtils.compositeDataToMemoryUsage(), (Function)new Function<MemoryUsage, Long>(){

                public Long apply(MemoryUsage input) {
                    return input == null ? null : Long.valueOf(input.getMax());
                }
            }))).pollAttribute((JmxAttributePollConfig)new JmxAttributePollConfig<Long>(UsesJavaMXBeans.NON_HEAP_MEMORY_USAGE).objectName("java.lang:type=Memory").attributeName("NonHeapMemoryUsage").onSuccess(HttpValueFunctions.chain(JavaAppUtils.compositeDataToMemoryUsage(), (Function)new Function<MemoryUsage, Long>(){

                public Long apply(MemoryUsage input) {
                    return input == null ? null : Long.valueOf(input.getUsed());
                }
            }))).pollAttribute(new JmxAttributePollConfig<Integer>(UsesJavaMXBeans.CURRENT_THREAD_COUNT).objectName("java.lang:type=Threading").attributeName("ThreadCount")).pollAttribute(new JmxAttributePollConfig<Integer>(UsesJavaMXBeans.PEAK_THREAD_COUNT).objectName("java.lang:type=Threading").attributeName("PeakThreadCount")).pollAttribute(((JmxAttributePollConfig)new JmxAttributePollConfig<Long>(UsesJavaMXBeans.START_TIME).objectName("java.lang:type=Runtime").period(60L, TimeUnit.SECONDS)).attributeName("StartTime")).pollAttribute(((JmxAttributePollConfig)new JmxAttributePollConfig<Long>(UsesJavaMXBeans.UP_TIME).objectName("java.lang:type=Runtime").period(60L, TimeUnit.SECONDS)).attributeName("Uptime")).pollAttribute((JmxAttributePollConfig)new JmxAttributePollConfig<Double>(UsesJavaMXBeans.PROCESS_CPU_TIME).objectName("java.lang:type=OperatingSystem").attributeName("ProcessCpuTime").onSuccess(MathFunctions.times((double)1.0E-6))).pollAttribute(new JmxAttributePollConfig<Double>(UsesJavaMXBeans.SYSTEM_LOAD_AVERAGE).objectName("java.lang:type=OperatingSystem").attributeName("SystemLoadAverage")).pollAttribute(((JmxAttributePollConfig)new JmxAttributePollConfig<Integer>(UsesJavaMXBeans.AVAILABLE_PROCESSORS).objectName("java.lang:type=OperatingSystem").period(60L, TimeUnit.SECONDS)).attributeName("AvailableProcessors")).pollAttribute(((JmxAttributePollConfig)new JmxAttributePollConfig<Long>(UsesJavaMXBeans.TOTAL_PHYSICAL_MEMORY_SIZE).objectName("java.lang:type=OperatingSystem").period(60L, TimeUnit.SECONDS)).attributeName("TotalPhysicalMemorySize")).pollAttribute(((JmxAttributePollConfig)new JmxAttributePollConfig<Long>(UsesJavaMXBeans.FREE_PHYSICAL_MEMORY_SIZE).objectName("java.lang:type=OperatingSystem").period(60L, TimeUnit.SECONDS)).attributeName("FreePhysicalMemorySize"));
        }
        return builder;
    }

    @Deprecated
    public static Function<Number, Double> times(double x) {
        return MathFunctions.times((double)x);
    }

    public static Function<CompositeData, MemoryUsage> compositeDataToMemoryUsage() {
        return new Function<CompositeData, MemoryUsage>(){

            public MemoryUsage apply(CompositeData input) {
                return input == null ? null : MemoryUsage.from(input);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        if (initialized.get()) {
            return;
        }
        AtomicBoolean atomicBoolean = initialized;
        synchronized (atomicBoolean) {
            if (initialized.get()) {
                return;
            }
            RendererHints.register(UsesJavaMXBeans.USED_HEAP_MEMORY, (RendererHints.Hint)RendererHints.displayValue((Function)ByteSizeStrings.metric()));
            RendererHints.register(UsesJavaMXBeans.INIT_HEAP_MEMORY, (RendererHints.Hint)RendererHints.displayValue((Function)ByteSizeStrings.metric()));
            RendererHints.register(UsesJavaMXBeans.MAX_HEAP_MEMORY, (RendererHints.Hint)RendererHints.displayValue((Function)ByteSizeStrings.metric()));
            RendererHints.register(UsesJavaMXBeans.COMMITTED_HEAP_MEMORY, (RendererHints.Hint)RendererHints.displayValue((Function)ByteSizeStrings.metric()));
            RendererHints.register(UsesJavaMXBeans.NON_HEAP_MEMORY_USAGE, (RendererHints.Hint)RendererHints.displayValue((Function)ByteSizeStrings.metric()));
            RendererHints.register(UsesJavaMXBeans.TOTAL_PHYSICAL_MEMORY_SIZE, (RendererHints.Hint)RendererHints.displayValue((Function)ByteSizeStrings.metric()));
            RendererHints.register(UsesJavaMXBeans.FREE_PHYSICAL_MEMORY_SIZE, (RendererHints.Hint)RendererHints.displayValue((Function)ByteSizeStrings.metric()));
            RendererHints.register(UsesJavaMXBeans.START_TIME, (RendererHints.Hint)RendererHints.displayValue((Function)Time.toDateString()));
            RendererHints.register(UsesJavaMXBeans.UP_TIME, (RendererHints.Hint)RendererHints.displayValue((Function)Duration.millisToStringRounded()));
            RendererHints.register(UsesJavaMXBeans.PROCESS_CPU_TIME, (RendererHints.Hint)RendererHints.displayValue((Function)Duration.millisToStringRounded()));
            RendererHints.register(UsesJavaMXBeans.PROCESS_CPU_TIME_FRACTION_LAST, (RendererHints.Hint)RendererHints.displayValue((Function)MathFunctions.percent((int)4)));
            RendererHints.register(UsesJavaMXBeans.PROCESS_CPU_TIME_FRACTION_IN_WINDOW, (RendererHints.Hint)RendererHints.displayValue((Function)MathFunctions.percent((int)4)));
            initialized.set(true);
        }
    }

    static {
        JavaAppUtils.init();
    }
}

