/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.chef;

import brooklyn.entity.chef.ChefBashCommands;
import brooklyn.entity.chef.ChefTasks;
import brooklyn.entity.software.SshEffectorTasks;
import brooklyn.management.TaskFactory;
import brooklyn.util.ssh.BashCommands;
import com.google.common.annotations.Beta;
import java.util.Map;

@Beta
public class ChefSoloTasks {
    public static TaskFactory<?> installChef(String chefDirectory, boolean force) {
        String installCmd = ChefSoloTasks.cdAndRun(chefDirectory, ChefBashCommands.INSTALL_FROM_OPSCODE);
        if (!force) {
            installCmd = BashCommands.alternatives((String[])new String[]{"which chef-solo", installCmd});
        }
        return SshEffectorTasks.ssh(installCmd).summary("install chef");
    }

    public static TaskFactory<?> installCookbooks(String chefDirectory, Map<String, String> cookbooksAndUrls, boolean force) {
        return ChefTasks.installCookbooks(chefDirectory, cookbooksAndUrls, force);
    }

    public static TaskFactory<?> installCookbook(String chefDirectory, String cookbookName, String cookbookArchiveUrl, boolean force) {
        return ChefTasks.installCookbook(chefDirectory, cookbookName, cookbookArchiveUrl, force);
    }

    protected static String cdAndRun(String targetDirectory, String command) {
        return BashCommands.chain((String[])new String[]{"mkdir -p " + targetDirectory, "cd " + targetDirectory, command});
    }

    public static TaskFactory<?> buildChefFile(String runDirectory, String chefDirectory, String phase, Iterable<? extends String> runList, Map<String, Object> optionalAttributes) {
        return ChefTasks.buildChefFile(runDirectory, chefDirectory, phase, runList, optionalAttributes);
    }

    public static TaskFactory<?> runChef(String runDir, String phase) {
        return ChefSoloTasks.runChef(runDir, phase, false);
    }

    public static TaskFactory<?> runChef(String runDir, String phase, Boolean twice) {
        String cmd = "sudo chef-solo -c " + phase + ".rb -j " + phase + ".json -ldebug";
        if (twice != null && twice.booleanValue()) {
            cmd = BashCommands.alternatives((String[])new String[]{cmd, cmd});
        }
        return ((SshEffectorTasks.SshEffectorTaskFactory)SshEffectorTasks.ssh(ChefSoloTasks.cdAndRun(runDir, cmd)).summary("run chef for " + phase)).requiringExitCodeZero();
    }
}

