/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.chef;

import brooklyn.config.ConfigKey;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.Attributes;
import brooklyn.entity.basic.Lifecycle;
import brooklyn.entity.basic.SoftwareProcess;
import brooklyn.entity.chef.ChefConfig;
import brooklyn.entity.chef.ChefServerTasks;
import brooklyn.entity.chef.ChefSoloTasks;
import brooklyn.entity.chef.KnifeTaskFactory;
import brooklyn.entity.software.MachineLifecycleEffectorTasks;
import brooklyn.entity.software.SshEffectorTasks;
import brooklyn.location.MachineLocation;
import brooklyn.location.basic.Machines;
import brooklyn.management.ExecutionContext;
import brooklyn.management.TaskAdaptable;
import brooklyn.management.TaskFactory;
import brooklyn.util.collections.Jsonya;
import brooklyn.util.config.ConfigBag;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.net.Urls;
import brooklyn.util.ssh.BashCommands;
import brooklyn.util.task.DynamicTasks;
import brooklyn.util.task.TaskTags;
import brooklyn.util.task.Tasks;
import brooklyn.util.task.system.ProcessTaskWrapper;
import brooklyn.util.text.Strings;
import brooklyn.util.time.Duration;
import brooklyn.util.time.Time;
import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class ChefLifecycleEffectorTasks
extends MachineLifecycleEffectorTasks
implements ChefConfig {
    private static final Logger log = LoggerFactory.getLogger(ChefLifecycleEffectorTasks.class);
    protected String _pidFile;
    protected String _serviceName;
    protected String _windowsServiceName;

    public ChefLifecycleEffectorTasks usePidFile(String pidFile) {
        this._pidFile = pidFile;
        return this;
    }

    public ChefLifecycleEffectorTasks useService(String serviceName) {
        this._serviceName = serviceName;
        return this;
    }

    public ChefLifecycleEffectorTasks useWindowsService(String serviceName) {
        this._windowsServiceName = serviceName;
        return this;
    }

    public String getPidFile() {
        if (this._pidFile != null) {
            return this._pidFile;
        }
        this._pidFile = (String)this.entity().getConfig(ChefConfig.PID_FILE);
        return this._pidFile;
    }

    public String getServiceName() {
        if (this._serviceName != null) {
            return this._serviceName;
        }
        this._serviceName = (String)this.entity().getConfig(ChefConfig.SERVICE_NAME);
        return this._serviceName;
    }

    protected String getNodeName() {
        String nodeName = (String)this.entity().getConfig(ChefConfig.CHEF_NODE_NAME);
        if (Strings.isNonBlank((CharSequence)nodeName)) {
            return Strings.makeValidFilename((String)nodeName);
        }
        return this.entity().getId();
    }

    public String getWindowsServiceName() {
        if (this._windowsServiceName != null) {
            return this._windowsServiceName;
        }
        this._windowsServiceName = (String)this.entity().getConfig(ChefConfig.WINDOWS_SERVICE_NAME);
        return this._windowsServiceName;
    }

    @Override
    public void attachLifecycleEffectors(Entity entity) {
        if (this.getPidFile() == null && this.getServiceName() == null && this.getClass().equals(ChefLifecycleEffectorTasks.class)) {
            log.warn("Uses of " + this.getClass() + " must define a PID file or a service name (or subclass and override {start,stop} methods as per javadoc) " + "in order for check-running and stop to work");
        }
        super.attachLifecycleEffectors(entity);
    }

    public static ChefConfig.ChefModes detectChefMode(Entity entity) {
        ChefConfig.ChefModes mode = (ChefConfig.ChefModes)((Object)entity.getConfig(ChefConfig.CHEF_MODE));
        if (mode == ChefConfig.ChefModes.AUTODETECT) {
            ProcessTaskWrapper installCheck = (ProcessTaskWrapper)DynamicTasks.queue(ChefServerTasks.isKnifeInstalled());
            mode = (Boolean)installCheck.get() != false ? ChefConfig.ChefModes.KNIFE : ChefConfig.ChefModes.SOLO;
            log.debug("Using Chef in " + (Object)((Object)mode) + " mode due to autodetect exit code " + installCheck.getExitCode());
        }
        Preconditions.checkNotNull((Object)((Object)mode), (Object)("Non-null " + ChefConfig.CHEF_MODE + " required for " + entity));
        return mode;
    }

    @Override
    protected String startProcessesAtMachine(Supplier<MachineLocation> machineS) {
        ChefConfig.ChefModes mode = ChefLifecycleEffectorTasks.detectChefMode((Entity)this.entity());
        switch (mode) {
            case KNIFE: {
                this.startWithKnifeAsync();
                break;
            }
            case SOLO: {
                this.startWithChefSoloAsync();
                break;
            }
            default: {
                throw new IllegalStateException("Unknown Chef mode " + (Object)((Object)mode) + " when starting processes for " + this.entity());
            }
        }
        return "chef start tasks submitted (" + (Object)((Object)mode) + ")";
    }

    protected String getPrimaryCookbook() {
        return (String)this.entity().getConfig(CHEF_COOKBOOK_PRIMARY_NAME);
    }

    protected void startWithChefSoloAsync() {
        String baseDir = MachineLifecycleEffectorTasks.resolveOnBoxDir(this.entity(), (MachineLocation)Machines.findUniqueSshMachineLocation((Iterable)this.entity().getLocations()).get());
        String installDir = Urls.mergePaths((String[])new String[]{baseDir, "installs/chef"});
        Map cookbooks = ConfigBag.newInstance((Map)((Map)this.entity().getConfig((ConfigKey)CHEF_COOKBOOK_URLS))).putIfAbsent((Map)this.entity().getConfig((ConfigKey)CHEF_COOKBOOKS)).getAllConfig();
        if (cookbooks.isEmpty()) {
            log.warn("No cookbook_urls set for " + this.entity() + "; launch will likely fail subsequently");
        }
        DynamicTasks.queue(ChefSoloTasks.installChef(installDir, false), ChefSoloTasks.installCookbooks(installDir, cookbooks, false), (TaskFactory[])new TaskFactory[0]);
        String primary = this.getPrimaryCookbook();
        Jsonya.Navigator attrs = Jsonya.newInstancePrimitive().at((Object)"brooklyn", new Object[0]);
        if (Strings.isNonBlank((CharSequence)primary)) {
            attrs.at((Object)primary, new Object[0]);
        }
        attrs.at((Object)"config", new Object[0]);
        attrs.put(this.entity().getAllConfigBag().getAllConfig());
        try {
            attrs.root().put((Map)Tasks.resolveDeepValue((Object)this.entity().getConfig((ConfigKey)CHEF_LAUNCH_ATTRIBUTES), Object.class, (ExecutionContext)this.entity().getExecutionContext()));
        }
        catch (Exception e) {
            Exceptions.propagate((Throwable)e);
        }
        Collection runList = (Collection)this.entity().getConfig((ConfigKey)CHEF_LAUNCH_RUN_LIST);
        if (runList == null) {
            runList = (Collection)this.entity().getConfig((ConfigKey)CHEF_RUN_LIST);
        }
        if (runList == null) {
            if (Strings.isNonBlank((CharSequence)primary)) {
                runList = ImmutableList.of((Object)(primary + "::" + "start"));
            } else {
                throw new IllegalStateException("Require a primary cookbook or a run_list to effect start on " + this.entity());
            }
        }
        String runDir = Urls.mergePaths((String[])new String[]{baseDir, "apps/" + this.entity().getApplicationId() + "/chef/entities/" + this.entity().getEntityType().getSimpleName() + "_" + this.entity().getId()});
        DynamicTasks.queue(ChefSoloTasks.buildChefFile(runDir, installDir, "launch", runList, (Map)attrs.root().get()));
        DynamicTasks.queue(ChefSoloTasks.runChef(runDir, "launch", (Boolean)this.entity().getConfig(CHEF_RUN_CONVERGE_TWICE)));
    }

    protected void startWithKnifeAsync() {
        String primary = this.getPrimaryCookbook();
        Jsonya.Navigator attrs = Jsonya.newInstancePrimitive().at((Object)"brooklyn", new Object[0]);
        if (Strings.isNonBlank((CharSequence)primary)) {
            attrs.at((Object)primary, new Object[0]);
        }
        attrs.at((Object)"config", new Object[0]);
        attrs.put(this.entity().getAllConfigBag().getAllConfig());
        try {
            attrs.root().put((Map)Tasks.resolveDeepValue((Object)this.entity().getConfig((ConfigKey)CHEF_LAUNCH_ATTRIBUTES), Object.class, (ExecutionContext)this.entity().getExecutionContext()));
        }
        catch (Exception e) {
            Exceptions.propagate((Throwable)e);
        }
        Collection runList = (Collection)this.entity().getConfig((ConfigKey)CHEF_LAUNCH_RUN_LIST);
        if (runList == null) {
            runList = (Collection)this.entity().getConfig((ConfigKey)CHEF_RUN_LIST);
        }
        if (runList == null) {
            if (Strings.isNonBlank((CharSequence)primary)) {
                runList = ImmutableList.of((Object)(primary + "::" + "start"));
            } else {
                throw new IllegalStateException("Require a primary cookbook or a run_list to effect start on " + this.entity());
            }
        }
        DynamicTasks.queue(ChefServerTasks.knifeConvergeTask().knifeNodeName(this.getNodeName()).knifeRunList(Strings.join((Iterable)runList, (String)",")).knifeAddAttributes((Map)attrs.root().get()).knifeRunTwice((Boolean)this.entity().getConfig(CHEF_RUN_CONVERGE_TWICE)));
    }

    @Override
    protected void postStartCustom() {
        boolean result = false;
        result |= this.tryCheckStartPid();
        result |= this.tryCheckStartService();
        if (!(result |= this.tryCheckStartWindowsService())) {
            log.warn("No way to check whether " + this.entity() + " is running; assuming yes");
        }
        this.entity().setAttribute(SoftwareProcess.SERVICE_UP, (Object)true);
    }

    protected boolean tryCheckStartPid() {
        if (this.getPidFile() == null) {
            return false;
        }
        Time.sleep((Duration)Duration.FIVE_SECONDS);
        if (!((Boolean)((ProcessTaskWrapper)DynamicTasks.queue((TaskFactory)SshEffectorTasks.isPidFromFileRunning(this.getPidFile()).runAsRoot())).get()).booleanValue()) {
            throw new IllegalStateException("The process for " + this.entity() + " appears not to be running (pid file " + this.getPidFile() + ")");
        }
        this.entity().setAttribute(Attributes.PID, (Object)Integer.parseInt(((ProcessTaskWrapper)DynamicTasks.queue((TaskFactory)SshEffectorTasks.ssh("cat " + this.getPidFile()).runAsRoot())).block().getStdout().trim()));
        return true;
    }

    protected boolean tryCheckStartService() {
        if (this.getServiceName() == null) {
            return false;
        }
        Time.sleep((Duration)Duration.FIVE_SECONDS);
        if (!Integer.valueOf(0).equals(((ProcessTaskWrapper)DynamicTasks.queue((TaskFactory)SshEffectorTasks.ssh("/etc/init.d/" + this.getServiceName() + " status").runAsRoot())).get())) {
            throw new IllegalStateException("The process for " + this.entity() + " appears not to be running (service " + this.getServiceName() + ")");
        }
        return true;
    }

    protected boolean tryCheckStartWindowsService() {
        if (this.getWindowsServiceName() == null) {
            return false;
        }
        Time.sleep((Duration)Duration.FIVE_SECONDS);
        if (!Integer.valueOf(0).equals(((ProcessTaskWrapper)DynamicTasks.queue((TaskFactory)SshEffectorTasks.ssh("sc query \"" + this.getWindowsServiceName() + "\" | find \"RUNNING\"").runAsCommand())).get())) {
            throw new IllegalStateException("The process for " + this.entity() + " appears not to be running (windowsService " + this.getWindowsServiceName() + ")");
        }
        return true;
    }

    @Override
    protected String stopProcessesAtMachine() {
        boolean result = false;
        result |= this.tryStopService();
        result |= this.tryStopWindowsService();
        if (!(result |= this.tryStopPid())) {
            throw new IllegalStateException("The process for " + this.entity() + " could not be stopped (no impl!)");
        }
        return "stopped";
    }

    @Override
    protected MachineLifecycleEffectorTasks.StopMachineDetails<Integer> stopAnyProvisionedMachines() {
        if (ChefLifecycleEffectorTasks.detectChefMode((Entity)this.entity()) == ChefConfig.ChefModes.KNIFE) {
            DynamicTasks.queue((TaskAdaptable)TaskTags.markInessential(((KnifeTaskFactory)((KnifeTaskFactory)new KnifeTaskFactory("delete node and client registration at chef server").add(new String[]{"knife node delete " + this.getNodeName() + " -y"})).add(new String[]{"knife client delete " + this.getNodeName() + " -y"})).requiringZeroAndReturningStdout().newTask()));
        }
        return super.stopAnyProvisionedMachines();
    }

    protected boolean tryStopService() {
        if (this.getServiceName() == null) {
            return false;
        }
        int result = (Integer)((ProcessTaskWrapper)DynamicTasks.queue((TaskFactory)SshEffectorTasks.ssh("/etc/init.d/" + this.getServiceName() + " stop").runAsRoot())).get();
        if (0 == result) {
            return true;
        }
        if (this.entity().getAttribute(Attributes.SERVICE_STATE_ACTUAL) != Lifecycle.RUNNING) {
            return true;
        }
        throw new IllegalStateException("The process for " + this.entity() + " appears could not be stopped (exit code " + result + " to service stop)");
    }

    protected boolean tryStopWindowsService() {
        if (this.getWindowsServiceName() == null) {
            return false;
        }
        int result = (Integer)((ProcessTaskWrapper)DynamicTasks.queue((TaskFactory)SshEffectorTasks.ssh("sc query \"" + this.getWindowsServiceName() + "\"").runAsCommand())).get();
        if (0 == result) {
            return true;
        }
        if (this.entity().getAttribute(Attributes.SERVICE_STATE_ACTUAL) != Lifecycle.RUNNING) {
            return true;
        }
        throw new IllegalStateException("The process for " + this.entity() + " appears could not be stopped (exit code " + result + " to service stop)");
    }

    protected boolean tryStopPid() {
        Integer pid = (Integer)this.entity().getAttribute(Attributes.PID);
        if (pid == null) {
            if (this.entity().getAttribute(Attributes.SERVICE_STATE_ACTUAL) == Lifecycle.RUNNING && this.getPidFile() == null) {
                log.warn("No PID recorded for " + this.entity() + " when running, with PID file " + this.getPidFile() + "; skipping kill in " + Tasks.current());
            } else if (log.isDebugEnabled()) {
                log.debug("No PID recorded for " + this.entity() + "; skipping (" + this.entity().getAttribute(Attributes.SERVICE_STATE_ACTUAL) + " / " + this.getPidFile() + ")");
            }
            return false;
        }
        ((ProcessTaskWrapper)DynamicTasks.queue((TaskFactory)((SshEffectorTasks.SshEffectorTaskFactory)SshEffectorTasks.ssh("kill " + pid, "sleep 5", BashCommands.ok((String)("kill -9 " + pid))).allowingNonZeroExitCode()).runAsRoot())).block();
        if (((Boolean)((ProcessTaskWrapper)DynamicTasks.queue((TaskFactory)SshEffectorTasks.isPidRunning(pid).runAsRoot())).get()).booleanValue()) {
            throw new IllegalStateException("Process for " + this.entity() + " in " + pid + " still running after kill");
        }
        this.entity().setAttribute(Attributes.PID, null);
        return true;
    }
}

