/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.chef;

import brooklyn.config.ConfigKey;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.EntityInternal;
import brooklyn.entity.chef.ChefConfig;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.event.basic.MapConfigKey;
import brooklyn.event.basic.SetConfigKey;
import brooklyn.util.git.GithubUrls;
import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.Map;

@Beta
public class ChefConfigs {
    public static void addToLaunchRunList(EntitySpec<?> entity, String ... recipes) {
        for (String recipe : recipes) {
            entity.configure(ChefConfig.CHEF_LAUNCH_RUN_LIST, (Object)SetConfigKey.SetModifications.addItem((Object)recipe));
        }
    }

    public static void addToLaunchRunList(EntityInternal entity, String ... recipes) {
        for (String recipe : recipes) {
            entity.setConfig(ChefConfig.CHEF_LAUNCH_RUN_LIST, (Object)SetConfigKey.SetModifications.addItem((Object)recipe));
        }
    }

    public static void addToCookbooksFromGithub(EntitySpec<?> entity, String ... cookbookNames) {
        for (String cookbookName : cookbookNames) {
            ChefConfigs.addToCookbooksFromGithub(entity, cookbookName, ChefConfigs.getGithubOpscodeRepo(cookbookName));
        }
    }

    public static void addToCookbooksFromGithub(EntityInternal entity, String ... cookbookNames) {
        for (String cookbookName : cookbookNames) {
            ChefConfigs.addToCookbooksFromGithub(entity, cookbookName, ChefConfigs.getGithubOpscodeRepo(cookbookName));
        }
    }

    public static String getGithubOpscodeRepo(String cookbookName) {
        return ChefConfigs.getGithubOpscodeRepo(cookbookName, "master");
    }

    public static String getGithubOpscodeRepo(String cookbookName, String tag) {
        return GithubUrls.tgz((String)"opscode-cookbooks", (String)cookbookName, (String)tag);
    }

    public static void addToCookbooksFromGithub(EntitySpec<?> entity, String cookbookName, String cookbookUrl) {
        entity.configure(ChefConfig.CHEF_COOKBOOK_URLS.subKey(cookbookName), (Object)cookbookUrl);
    }

    public static void addToCookbooksFromGithub(EntityInternal entity, String cookbookName, String cookbookUrl) {
        entity.setConfig(ChefConfig.CHEF_COOKBOOK_URLS.subKey(cookbookName), (Object)cookbookUrl);
    }

    public static void addLaunchAttributes(EntitySpec<?> entity, Map<? extends Object, ? extends Object> attributesMap) {
        entity.configure(ChefConfig.CHEF_LAUNCH_ATTRIBUTES, (Object)MapConfigKey.MapModifications.add(attributesMap));
    }

    public static void addLaunchAttributes(EntityInternal entity, Map<? extends Object, ? extends Object> attributesMap) {
        entity.setConfig(ChefConfig.CHEF_LAUNCH_ATTRIBUTES, (Object)MapConfigKey.MapModifications.add(attributesMap));
    }

    public static void setLaunchAttribute(EntitySpec<?> entity, String rootAttribute, Object value) {
        entity.configure(ChefConfig.CHEF_LAUNCH_ATTRIBUTES.subKey(rootAttribute), value);
    }

    public static void setLaunchAttribute(EntityInternal entity, String rootAttribute, Object value) {
        entity.setConfig(ChefConfig.CHEF_LAUNCH_ATTRIBUTES.subKey(rootAttribute), value);
    }

    public static <T> T getRequiredConfig(Entity entity, ConfigKey<T> key) {
        return (T)Preconditions.checkNotNull((Object)((Entity)Preconditions.checkNotNull((Object)entity, (Object)"Entity must be supplied")).getConfig(key), (Object)("Key " + key + " is required on " + entity));
    }
}

