/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.brooklynnode.effector;

import brooklyn.entity.Effector;
import brooklyn.entity.Entity;
import brooklyn.entity.Group;
import brooklyn.entity.basic.EntityPredicates;
import brooklyn.entity.brooklynnode.BrooklynCluster;
import brooklyn.entity.brooklynnode.BrooklynNode;
import brooklyn.entity.effector.EffectorBody;
import brooklyn.entity.effector.Effectors;
import brooklyn.management.TaskAdaptable;
import brooklyn.management.ha.HighAvailabilityMode;
import brooklyn.management.ha.ManagementNodeState;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.config.ConfigBag;
import brooklyn.util.repeat.Repeater;
import brooklyn.util.task.DynamicTasks;
import brooklyn.util.time.Duration;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectMasterEffectorBody
extends EffectorBody<Void>
implements BrooklynCluster.SelectMasterEffector {
    public static final Effector<Void> SELECT_MASTER = Effectors.effector(BrooklynCluster.SelectMasterEffector.SELECT_MASTER).impl((EffectorBody)new SelectMasterEffectorBody()).build();
    private static final Logger LOG = LoggerFactory.getLogger(SelectMasterEffectorBody.class);
    private static final int HA_STANDBY_PRIORITY = 0;
    private static final int HA_MASTER_PRIORITY = 1;
    private AtomicBoolean selectMasterInProgress = new AtomicBoolean();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Void call(ConfigBag parameters) {
        if (!this.selectMasterInProgress.compareAndSet(false, true)) {
            throw new IllegalStateException("A master change is already in progress.");
        }
        try {
            this.selectMaster(parameters);
        }
        finally {
            this.selectMasterInProgress.set(false);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectMaster(ConfigBag parameters) {
        String newMasterId = (String)parameters.get(NEW_MASTER_ID);
        Preconditions.checkNotNull((Object)newMasterId, (Object)(NEW_MASTER_ID.getName() + " parameter is required"));
        Entity oldMaster = (Entity)this.entity().getAttribute(BrooklynCluster.MASTER_NODE);
        if (oldMaster != null && oldMaster.getId().equals(newMasterId)) {
            LOG.info(newMasterId + " is already the current master, no change needed.");
            return;
        }
        Entity newMaster = this.getMember(newMasterId);
        this.toggleNodePriority(newMaster, 1);
        try {
            DynamicTasks.swallowChildrenFailures();
            if (oldMaster != null) {
                this.demoteOldMaster(oldMaster, HighAvailabilityMode.HOT_STANDBY);
            }
            this.waitMasterHandover(oldMaster, newMaster);
        }
        finally {
            this.toggleNodePriority(newMaster, 0);
        }
        this.checkMasterSelected(newMaster);
    }

    private void waitMasterHandover(final Entity oldMaster, Entity newMaster) {
        boolean masterChanged = Repeater.create().backoff(Duration.millis((Number)50), 1.5, Duration.FIVE_SECONDS).limitTimeTo(Duration.ONE_MINUTE).until((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                Entity master = SelectMasterEffectorBody.this.getMasterNode();
                return !Objects.equal((Object)master, (Object)oldMaster) && master != null;
            }
        }).run();
        if (!masterChanged) {
            LOG.warn("Timeout waiting for node to become master: " + newMaster + ".");
        }
    }

    private void demoteOldMaster(Entity oldMaster, HighAvailabilityMode mode) {
        ManagementNodeState oldState = (ManagementNodeState)DynamicTasks.queue((TaskAdaptable)Effectors.invocation((Entity)oldMaster, BrooklynNode.SET_HIGH_AVAILABILITY_MODE, (Map)MutableMap.of(BrooklynNode.SetHighAvailabilityModeEffector.MODE, (Object)mode))).asTask().getUnchecked();
        if (oldState != ManagementNodeState.MASTER) {
            LOG.warn("The previous HA state on node " + oldMaster.getId() + " was " + oldState + ", while the expected value is " + ManagementNodeState.MASTER + ".");
        }
    }

    private void toggleNodePriority(Entity node, int newPriority) {
        Integer expectedPriority;
        Integer oldPriority = (Integer)DynamicTasks.queue((TaskAdaptable)Effectors.invocation((Entity)node, BrooklynNode.SET_HIGH_AVAILABILITY_PRIORITY, (Map)MutableMap.of(BrooklynNode.SetHighAvailabilityPriorityEffector.PRIORITY, (Object)newPriority))).asTask().getUnchecked();
        if (oldPriority != (expectedPriority = Integer.valueOf(newPriority == 1 ? 0 : 1))) {
            LOG.warn("The previous HA priority on node " + node.getId() + " was " + oldPriority + ", while the expected value is " + expectedPriority + " (while setting priority " + newPriority + ").");
        }
    }

    private void checkMasterSelected(Entity newMaster) {
        Entity actualMaster = this.getMasterNode();
        if (actualMaster != newMaster) {
            throw new IllegalStateException("Expected node " + newMaster + " to be master, but found that " + "master is " + actualMaster + " instead.");
        }
    }

    private Entity getMember(String memberId) {
        Group cluster = (Group)this.entity();
        try {
            return (Entity)Iterables.find((Iterable)cluster.getMembers(), (Predicate)EntityPredicates.idEqualTo((String)memberId));
        }
        catch (NoSuchElementException e) {
            throw new IllegalStateException(memberId + " is not an ID of brooklyn node in this cluster");
        }
    }

    private Entity getMasterNode() {
        return (Entity)this.entity().getAttribute(BrooklynCluster.MASTER_NODE);
    }
}

