/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.brooklynnode.effector;

import brooklyn.entity.Effector;
import brooklyn.entity.Entity;
import brooklyn.entity.Group;
import brooklyn.entity.basic.Attributes;
import brooklyn.entity.basic.EntityPredicates;
import brooklyn.entity.basic.EntityTasks;
import brooklyn.entity.basic.Lifecycle;
import brooklyn.entity.brooklynnode.BrooklynCluster;
import brooklyn.entity.brooklynnode.BrooklynNode;
import brooklyn.entity.brooklynnode.effector.BrooklynNodeUpgradeEffectorBody;
import brooklyn.entity.effector.EffectorBody;
import brooklyn.entity.effector.Effectors;
import brooklyn.entity.group.DynamicCluster;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.event.AttributeSensor;
import brooklyn.management.TaskAdaptable;
import brooklyn.management.ha.HighAvailabilityMode;
import brooklyn.management.ha.ManagementNodeState;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.config.ConfigBag;
import brooklyn.util.net.Urls;
import brooklyn.util.task.DynamicTasks;
import brooklyn.util.task.Tasks;
import brooklyn.util.time.Duration;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrooklynClusterUpgradeEffectorBody
extends EffectorBody<Void>
implements BrooklynCluster.UpgradeClusterEffector {
    private static final Logger log = LoggerFactory.getLogger(BrooklynClusterUpgradeEffectorBody.class);
    public static final Effector<Void> UPGRADE_CLUSTER = Effectors.effector(BrooklynCluster.UpgradeClusterEffector.UPGRADE_CLUSTER).impl((EffectorBody)new BrooklynClusterUpgradeEffectorBody()).build();
    private final AtomicBoolean upgradeInProgress = new AtomicBoolean();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Void call(ConfigBag parameters) {
        if (!this.upgradeInProgress.compareAndSet(false, true)) {
            throw new IllegalStateException("An upgrade is already in progress.");
        }
        EntitySpec origMemberSpec = (EntitySpec)this.entity().getConfig(BrooklynCluster.MEMBER_SPEC);
        Preconditions.checkNotNull((Object)origMemberSpec, (Object)(BrooklynCluster.MEMBER_SPEC.getName() + " is required for " + BrooklynCluster.UpgradeClusterEffector.class.getName()));
        log.debug("Upgrading " + this.entity() + ", changing " + BrooklynCluster.MEMBER_SPEC + " from " + origMemberSpec + " / " + origMemberSpec.getConfig());
        boolean success = false;
        try {
            String newDownloadUrl = (String)parameters.get(DOWNLOAD_URL);
            EntitySpec newMemberSpec = EntitySpec.create((EntitySpec)origMemberSpec);
            ConfigBag newConfig = ConfigBag.newInstance();
            newConfig.putIfNotNull(DOWNLOAD_URL, (Object)newDownloadUrl);
            newConfig.put(BrooklynNode.DISTRO_UPLOAD_URL, (Object)this.inferUploadUrl(newDownloadUrl));
            newConfig.putAll(ConfigBag.newInstance((Map)((Map)parameters.get(EXTRA_CONFIG))).getAllConfigAsConfigKeyMap());
            newMemberSpec.configure(newConfig.getAllConfigAsConfigKeyMap());
            this.entity().setConfig(BrooklynCluster.MEMBER_SPEC, (Object)newMemberSpec);
            log.debug("Upgrading " + this.entity() + ", new " + BrooklynCluster.MEMBER_SPEC + ": " + newMemberSpec + " / " + newMemberSpec.getConfig() + " (adding: " + newConfig + ")");
            this.upgrade(parameters);
            success = true;
        }
        finally {
            if (!success) {
                log.debug("Upgrading " + this.entity() + " failed, will rethrow after restoring " + BrooklynCluster.MEMBER_SPEC + " to: " + origMemberSpec);
                this.entity().setConfig(BrooklynCluster.MEMBER_SPEC, (Object)origMemberSpec);
            }
            this.upgradeInProgress.set(false);
        }
        return null;
    }

    private String inferUploadUrl(String newDownloadUrl) {
        boolean isLocal;
        if (newDownloadUrl == null) {
            return null;
        }
        boolean bl = isLocal = "file".equals(Urls.getProtocol((String)newDownloadUrl)) || new File(newDownloadUrl).exists();
        if (isLocal) {
            return newDownloadUrl;
        }
        return null;
    }

    protected void upgrade(ConfigBag parameters) {
        Group cluster = (Group)this.entity();
        Collection initialMembers = cluster.getMembers();
        int initialClusterSize = initialMembers.size();
        if (!BrooklynNodeUpgradeEffectorBody.isPersistenceModeEnabled((Entity)cluster)) {
            DynamicTasks.queue((TaskAdaptable)Tasks.warning((String)"Check persistence", (Throwable)new IllegalStateException("Persistence does not appear to be enabled at this cluster. Cluster upgrade will not succeed unless a custom launch script enables it.")));
        }
        TaskAdaptable initialNodeTask = DynamicTasks.queue(this.newCreateNodesTask(1, "Creating first upgraded version node"));
        TaskAdaptable remainingNodesTask = DynamicTasks.queue(this.newCreateNodesTask(initialClusterSize - 1, "Creating remaining upgraded version nodes (" + (initialClusterSize - 1) + ")"));
        DynamicTasks.queue((TaskAdaptable)Effectors.invocation((Entity)cluster, BrooklynCluster.SELECT_MASTER, (Map)MutableMap.of(BrooklynCluster.SelectMasterEffector.NEW_MASTER_ID, (Object)((Entity)Iterables.getOnlyElement((Iterable)((Iterable)initialNodeTask.asTask().getUnchecked()))).getId()))).asTask().getUnchecked();
        DynamicTasks.queue((TaskAdaptable)Effectors.invocation(BrooklynNode.STOP_NODE_BUT_LEAVE_APPS, Collections.emptyMap(), (Iterable)initialMembers)).asTask().getUnchecked();
    }

    private TaskAdaptable<Collection<Entity>> newCreateNodesTask(int size, String name) {
        return Tasks.builder().name(name).body((Callable)new CreateNodesCallable(size)).build();
    }

    protected Collection<Entity> createNodes(int nodeCnt) {
        DynamicCluster cluster = (DynamicCluster)this.entity();
        Collection newNodes = cluster.resizeByDelta(nodeCnt);
        DynamicTasks.queue((TaskAdaptable)EntityTasks.requiringAttributeEventually((Iterable)newNodes, (AttributeSensor)Attributes.SERVICE_STATE_ACTUAL, (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)Lifecycle.STARTING)), (Duration)Duration.minutes((Number)30)));
        DynamicTasks.queue((TaskAdaptable)Effectors.invocation(BrooklynNode.SET_HIGH_AVAILABILITY_MODE, (Map)MutableMap.of(BrooklynNode.SetHighAvailabilityModeEffector.MODE, (Object)HighAvailabilityMode.HOT_STANDBY), (Iterable)newNodes)).asTask().getUnchecked();
        DynamicTasks.queue((TaskAdaptable)EntityTasks.requiringAttributeEventually((Iterable)newNodes, BrooklynNode.MANAGEMENT_NODE_STATE, (Predicate)Predicates.equalTo((Object)ManagementNodeState.HOT_STANDBY), (Duration)Duration.FIVE_MINUTES));
        Collection failedNodes = Collections2.filter((Collection)newNodes, (Predicate)EntityPredicates.attributeEqualTo((AttributeSensor)BrooklynNode.SERVICE_UP, (Object)Boolean.FALSE));
        if (!failedNodes.isEmpty()) {
            throw new IllegalStateException("Nodes " + failedNodes + " are not " + BrooklynNode.SERVICE_UP + " though successfully in " + ManagementNodeState.HOT_STANDBY);
        }
        return newNodes;
    }

    protected class CreateNodesCallable
    implements Callable<Collection<Entity>> {
        private final int size;

        public CreateNodesCallable(int size) {
            this.size = size;
        }

        @Override
        public Collection<Entity> call() throws Exception {
            return BrooklynClusterUpgradeEffectorBody.this.createNodes(this.size);
        }
    }
}

