/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.brooklynnode;

import brooklyn.config.ConfigKey;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.BrooklynTaskTags;
import brooklyn.entity.brooklynnode.BrooklynNode;
import brooklyn.entity.brooklynnode.EntityHttpClient;
import brooklyn.event.AttributeSensor;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.http.HttpTool;
import brooklyn.util.http.HttpToolResponse;
import brooklyn.util.net.Urls;
import brooklyn.util.stream.Streams;
import brooklyn.util.task.Tasks;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.io.ByteArrayOutputStream;
import java.net.URI;
import java.util.Map;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityHttpClientImpl
implements EntityHttpClient {
    private static final Logger LOG = LoggerFactory.getLogger(EntityHttpClientImpl.class);
    protected Entity entity;
    protected AttributeSensor<?> urlSensor;
    protected ConfigKey<?> urlConfig;
    protected Predicate<Integer> responseSuccess = EntityHttpClient.ResponseCodePredicates.success();

    protected EntityHttpClientImpl(Entity entity, AttributeSensor<?> urlSensor) {
        this.entity = entity;
        this.urlSensor = urlSensor;
    }

    protected EntityHttpClientImpl(Entity entity, ConfigKey<?> urlConfig) {
        this.entity = entity;
        this.urlConfig = urlConfig;
    }

    @Override
    public HttpTool.HttpClientBuilder getHttpClientForBrooklynNode() {
        String baseUrl = this.getEntityUrl();
        HttpTool.HttpClientBuilder builder = HttpTool.httpClientBuilder().trustAll().laxRedirect(true).uri(baseUrl);
        if (this.entity.getConfig(BrooklynNode.MANAGEMENT_USER) != null) {
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials((String)this.entity.getConfig(BrooklynNode.MANAGEMENT_USER), (String)this.entity.getConfig(BrooklynNode.MANAGEMENT_PASSWORD));
            builder.credentials((Credentials)credentials);
        }
        return builder;
    }

    @Override
    public EntityHttpClient responseSuccess(Predicate<Integer> responseSuccess) {
        this.responseSuccess = (Predicate)Preconditions.checkNotNull(responseSuccess, (Object)"responseSuccess");
        return this;
    }

    protected HttpToolResponse exec(String path, HttpCall httpCall) {
        HttpToolResponse result;
        HttpClient client = ((HttpTool.HttpClientBuilder)Preconditions.checkNotNull((Object)this.getHttpClientForBrooklynNode(), (Object)("No address info for " + this.entity))).build();
        String baseUri = this.getEntityUrl();
        URI uri = URI.create(Urls.mergePaths((String[])new String[]{baseUri, path}));
        try {
            result = httpCall.call(client, uri);
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            throw new IllegalStateException("Invalid response invoking " + uri + ": " + e, e);
        }
        Tasks.addTagDynamically((Object)BrooklynTaskTags.tagForStream((String)"http_response", (ByteArrayOutputStream)Streams.byteArray((byte[])result.getContent())));
        if (!this.responseSuccess.apply((Object)result.getResponseCode())) {
            LOG.warn("Invalid response invoking {}: response code {}\n{}: {}", new Object[]{uri, result.getResponseCode(), result, new String(result.getContent())});
            throw new IllegalStateException("Invalid response invoking " + uri + ": response code " + result.getResponseCode());
        }
        return result;
    }

    @Override
    public HttpToolResponse get(String path) {
        return this.exec(path, new HttpCall(){

            @Override
            public HttpToolResponse call(HttpClient client, URI uri) {
                return HttpTool.httpGet((HttpClient)client, (URI)uri, (Map)MutableMap.of());
            }
        });
    }

    @Override
    public HttpToolResponse post(String path, final Map<String, String> headers, final byte[] body) {
        return this.exec(path, new HttpCall(){

            @Override
            public HttpToolResponse call(HttpClient client, URI uri) {
                return HttpTool.httpPost((HttpClient)client, (URI)uri, (Map)headers, (byte[])body);
            }
        });
    }

    @Override
    public HttpToolResponse post(String path, final Map<String, String> headers, final Map<String, String> formParams) {
        return this.exec(path, new HttpCall(){

            @Override
            public HttpToolResponse call(HttpClient client, URI uri) {
                return HttpTool.httpPost((HttpClient)client, (URI)uri, (Map)headers, (Map)formParams);
            }
        });
    }

    protected String getEntityUrl() {
        Preconditions.checkState((boolean)(this.urlSensor == null ^ this.urlConfig == null), (Object)("Exactly one of urlSensor and urlConfig should be non-null for entity " + this.entity));
        Object url = null;
        if (this.urlSensor != null) {
            url = this.entity.getAttribute(this.urlSensor);
        } else if (this.urlConfig != null) {
            url = this.entity.getConfig(this.urlConfig);
        }
        Preconditions.checkNotNull((Object)url, (Object)("URL sensor " + this.urlSensor + " for entity " + this.entity + " is empty"));
        return url.toString();
    }

    @Override
    public HttpToolResponse delete(String path, final Map<String, String> headers) {
        return this.exec(path, new HttpCall(){

            @Override
            public HttpToolResponse call(HttpClient client, URI uri) {
                return HttpTool.httpDelete((HttpClient)client, (URI)uri, (Map)headers);
            }
        });
    }

    protected static interface HttpCall {
        public HttpToolResponse call(HttpClient var1, URI var2);
    }
}

