/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.brooklynnode;

import brooklyn.BrooklynVersion;
import brooklyn.catalog.Catalog;
import brooklyn.config.ConfigKey;
import brooklyn.entity.Effector;
import brooklyn.entity.basic.BrooklynConfigKeys;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.SoftwareProcess;
import brooklyn.entity.brooklynnode.BrooklynNodeImpl;
import brooklyn.entity.brooklynnode.EntityHttpClient;
import brooklyn.entity.effector.Effectors;
import brooklyn.entity.java.UsesJava;
import brooklyn.entity.proxying.ImplementedBy;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.BasicAttributeSensor;
import brooklyn.event.basic.BasicAttributeSensorAndConfigKey;
import brooklyn.event.basic.MapConfigKey;
import brooklyn.event.basic.PortAttributeSensorAndConfigKey;
import brooklyn.event.basic.Sensors;
import brooklyn.management.ha.HighAvailabilityMode;
import brooklyn.management.ha.ManagementNodeState;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.flags.SetFromFlag;
import brooklyn.util.net.Networking;
import brooklyn.util.time.Duration;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import java.net.InetAddress;
import java.net.URI;
import java.util.List;
import java.util.Map;

@Catalog(name="Brooklyn Node", description="Deploys a Brooklyn management server")
@ImplementedBy(value=BrooklynNodeImpl.class)
public interface BrooklynNode
extends SoftwareProcess,
UsesJava {
    @SetFromFlag(value="copyToRundir")
    public static final BasicAttributeSensorAndConfigKey<Map<String, String>> COPY_TO_RUNDIR = new BasicAttributeSensorAndConfigKey((TypeToken)new TypeToken<Map<String, String>>(){}, "brooklynnode.copytorundir", "URLs of resources to be copied across to the server, giving the path they are to be copied to", (Object)MutableMap.of());
    @SetFromFlag(value="version")
    public static final ConfigKey<String> SUGGESTED_VERSION = ConfigKeys.newConfigKeyWithDefault((ConfigKey)BrooklynConfigKeys.SUGGESTED_VERSION, (Object)"0.7.0-20150614.2158");
    @SetFromFlag(value="distroUploadUrl")
    public static final ConfigKey<String> DISTRO_UPLOAD_URL = ConfigKeys.newStringConfigKey((String)"brooklynnode.distro.uploadurl", (String)"URL for uploading the brooklyn distro (retrieved locally and pushed to remote install location)", null);
    @SetFromFlag(value="downloadUrl")
    public static final BasicAttributeSensorAndConfigKey<String> DOWNLOAD_URL = new BasicAttributeSensorAndConfigKey.StringAttributeSensorAndConfigKey(SoftwareProcess.DOWNLOAD_URL, "<#if version?contains(\"SNAPSHOT\")>https://repository.apache.org/service/local/artifact/maven/redirect?r=snapshots&g=org.apache.brooklyn&v=${version}&a=brooklyn-dist&c=dist&e=tar.gz<#else>http://search.maven.org/remotecontent?filepath=org/apache/brooklyn/brooklyn-dist/${version}/brooklyn-dist-${version}-dist.tar.gz</#if>");
    @SetFromFlag(value="subpathInArchive")
    public static final ConfigKey<String> SUBPATH_IN_ARCHIVE = ConfigKeys.newStringConfigKey((String)"brooklynnode.download.archive.subpath", (String)("Path to the main directory in the archive being supplied for installation; to use the root of an archive, specify '.'; default value taken based on download URL (e.g. 'name' for 'http://path/name.tgz' or 'http://path/name-dist.tgz') falling back to an appropriate value for brooklyn, e.g. 'brooklyn-" + BrooklynVersion.INSTANCE.getVersion() + "'"), null);
    @SetFromFlag(value="managementUser")
    public static final ConfigKey<String> MANAGEMENT_USER = ConfigKeys.newConfigKey((String)"brooklynnode.managementUser", (String)"The user for logging into the brooklyn web-console (also used for health-checks)", (Object)"admin");
    @SetFromFlag(value="managementPassword")
    public static final ConfigKey<String> MANAGEMENT_PASSWORD = ConfigKeys.newStringConfigKey((String)"brooklynnode.managementPassword", (String)"Password for MANAGEMENT_USER", null);
    @SetFromFlag(value="extraCustomizationScript")
    public static final ConfigKey<String> EXTRA_CUSTOMIZATION_SCRIPT = ConfigKeys.newStringConfigKey((String)"brooklynnode.customization.extraScript", (String)"Optional additional script commands to run as part of customization; this might e.g. ensure id_rsa is set up", null);
    @SetFromFlag(value="onExistingProperties")
    public static final ConfigKey<ExistingFileBehaviour> ON_EXISTING_PROPERTIES_FILE = ConfigKeys.newConfigKey(ExistingFileBehaviour.class, (String)"brooklynnode.properties.file.ifExists", (String)"What to do in the case where a global brooklyn.properties already exists", (Object)((Object)ExistingFileBehaviour.FAIL));
    @SetFromFlag(value="launchCommand")
    public static final ConfigKey<String> LAUNCH_COMMAND = ConfigKeys.newStringConfigKey((String)"brooklynnode.launch.command", (String)"Path to the script to launch Brooklyn / the app relative to the subpath in the archive, defaulting to 'bin/brooklyn'", (String)"bin/brooklyn");
    @SetFromFlag(value="launchParameters")
    public static final ConfigKey<String> EXTRA_LAUNCH_PARAMETERS = ConfigKeys.newStringConfigKey((String)"brooklynnode.launch.parameters.extra", (String)"Launch parameters passed on the CLI, in addition to 'launch' and parameters implied by other config keys (and placed afterwards on the command line)");
    @SetFromFlag(value="launchCommandCreatesPidFile")
    public static final ConfigKey<Boolean> LAUNCH_COMMAND_CREATES_PID_FILE = ConfigKeys.newBooleanConfigKey((String)"brooklynnode.launch.command.pid.updated", (String)"Whether the launch script creates/updates the PID file, if not the entity will do so, but note it will not necessarily kill sub-processes", (Boolean)true);
    @SetFromFlag(value="app")
    public static final BasicAttributeSensorAndConfigKey<String> APP = new BasicAttributeSensorAndConfigKey(String.class, "brooklynnode.app", "Application (fully qualified class name) to launch using the brooklyn CLI", null);
    @SetFromFlag(value="locations")
    public static final BasicAttributeSensorAndConfigKey<String> LOCATIONS = new BasicAttributeSensorAndConfigKey(String.class, "brooklynnode.locations", "Locations to use when launching the app", null);
    @SetFromFlag(value="brooklynGlobalPropertiesRemotePath")
    @VisibleForTesting
    public static final ConfigKey<String> BROOKLYN_GLOBAL_PROPERTIES_REMOTE_PATH = ConfigKeys.newStringConfigKey((String)"brooklynnode.brooklynproperties.global.remotepath", (String)"Remote path for the global brooklyn.properties file to be uploaded", (String)"${HOME}/.brooklyn/brooklyn.properties; only useful for testing as this path will not be used on the remote system");
    @SetFromFlag(value="brooklynGlobalPropertiesUri")
    public static final ConfigKey<String> BROOKLYN_GLOBAL_PROPERTIES_URI = ConfigKeys.newStringConfigKey((String)"brooklynnode.brooklynproperties.global.uri", (String)"URI for the global brooklyn properties file (uploaded to ~/.brooklyn/brooklyn.properties)", null);
    @SetFromFlag(value="brooklynGlobalPropertiesContents")
    public static final ConfigKey<String> BROOKLYN_GLOBAL_PROPERTIES_CONTENTS = ConfigKeys.newStringConfigKey((String)"brooklynnode.brooklynproperties.global.contents", (String)"Contents for the global brooklyn properties file (uploaded to ~/.brooklyn/brooklyn.properties)", null);
    @SetFromFlag(value="brooklynLocalPropertiesRemotePath")
    public static final ConfigKey<String> BROOKLYN_LOCAL_PROPERTIES_REMOTE_PATH = ConfigKeys.newStringConfigKey((String)"brooklynnode.brooklynproperties.local.remotepath", (String)"Remote path for the launch-specific brooklyn.properties file to be uploaded", (String)"${driver.runDir}/brooklyn-local.properties");
    @SetFromFlag(value="brooklynLocalPropertiesUri")
    public static final ConfigKey<String> BROOKLYN_LOCAL_PROPERTIES_URI = ConfigKeys.newStringConfigKey((String)"brooklynnode.brooklynproperties.local.uri", (String)"URI for the launch-specific brooklyn properties file", null);
    @SetFromFlag(value="brooklynLocalPropertiesContents")
    public static final ConfigKey<String> BROOKLYN_LOCAL_PROPERTIES_CONTENTS = ConfigKeys.newStringConfigKey((String)"brooklynnode.brooklynproperties.local.contents", (String)"Contents for the launch-specific brooklyn properties file", null);
    @Deprecated
    @SetFromFlag(value="brooklynCatalogRemotePath")
    public static final ConfigKey<String> BROOKLYN_CATALOG_REMOTE_PATH = ConfigKeys.newStringConfigKey((String)"brooklynnode.brooklyncatalog.remotepath", (String)"Remote path for the brooklyn catalog.xml file to be uploaded", (String)"${HOME}/.brooklyn/catalog.xml");
    @Deprecated
    @SetFromFlag(value="brooklynCatalogUri")
    public static final ConfigKey<String> BROOKLYN_CATALOG_URI = ConfigKeys.newStringConfigKey((String)"brooklynnode.brooklyncatalog.uri", (String)"URI for the brooklyn catalog.xml file (uploaded to ~/.brooklyn/catalog.xml)", null);
    @Deprecated
    @SetFromFlag(value="brooklynCatalogContents")
    public static final ConfigKey<String> BROOKLYN_CATALOG_CONTENTS = ConfigKeys.newStringConfigKey((String)"brooklynnode.brooklyncatalog.contents", (String)"Contents for the brooklyn catalog.xml file (uploaded to ~/.brooklyn/catalog.xml)", null);
    @SetFromFlag(value="enabledHttpProtocols")
    public static final BasicAttributeSensorAndConfigKey<List<String>> ENABLED_HTTP_PROTOCOLS = new BasicAttributeSensorAndConfigKey(List.class, "brooklynnode.webconsole.enabledHttpProtocols", "List of enabled protocols (e.g. http, https)", (Object)ImmutableList.of((Object)"http"));
    @SetFromFlag(value="httpPort")
    public static final PortAttributeSensorAndConfigKey HTTP_PORT = new PortAttributeSensorAndConfigKey("brooklynnode.webconsole.httpPort", "HTTP Port for the brooklyn web-console", (Object)"8081+");
    @SetFromFlag(value="httpsPort")
    public static final PortAttributeSensorAndConfigKey HTTPS_PORT = new PortAttributeSensorAndConfigKey("brooklynnode.webconsole.httpsPort", "HTTPS Port for the brooklyn web-console", (Object)"8443+");
    @SetFromFlag(value="noWebConsoleSecurity")
    public static final BasicAttributeSensorAndConfigKey<Boolean> NO_WEB_CONSOLE_AUTHENTICATION = new BasicAttributeSensorAndConfigKey(Boolean.class, "brooklynnode.webconsole.nosecurity", "Whether to start the web console with no security", (Object)false);
    @SetFromFlag(value="bindAddress")
    public static final BasicAttributeSensorAndConfigKey<InetAddress> WEB_CONSOLE_BIND_ADDRESS = new BasicAttributeSensorAndConfigKey(InetAddress.class, "brooklynnode.webconsole.address.bind", "Specifies the IP address of the NIC to bind the Brooklyn Management Console to (default 0.0.0.0)", (Object)Networking.ANY_NIC);
    @SetFromFlag(value="publicAddress")
    public static final BasicAttributeSensorAndConfigKey<InetAddress> WEB_CONSOLE_PUBLIC_ADDRESS = new BasicAttributeSensorAndConfigKey(InetAddress.class, "brooklynnode.webconsole.address.public", "Specifies the public IP address or hostname for the Brooklyn Management Console");
    public static final AttributeSensor<Boolean> WEB_CONSOLE_ACCESSIBLE = Sensors.newBooleanSensor((String)"brooklynnode.webconsole.up", (String)"Whether the web console is responding normally");
    @SetFromFlag(value="classpath")
    public static final BasicAttributeSensorAndConfigKey<List<String>> CLASSPATH = new BasicAttributeSensorAndConfigKey(List.class, "brooklynnode.classpath", "classpath to use, as list of URL entries", (Object)Lists.newArrayList());
    @SetFromFlag(value="portMapper")
    public static final ConfigKey<Function<? super Integer, ? extends Integer>> PORT_MAPPER = ConfigKeys.newConfigKey(Function.class, (String)"brooklynnode.webconsole.portMapper", (String)"Function for mapping private to public ports, for use in inferring the brooklyn URI", (Object)Functions.identity());
    public static final AttributeSensor<URI> WEB_CONSOLE_URI = new BasicAttributeSensor(URI.class, "brooklynnode.webconsole.url", "URL of the brooklyn web-console");
    public static final AttributeSensor<ManagementNodeState> MANAGEMENT_NODE_STATE = new BasicAttributeSensor(ManagementNodeState.class, "brooklynnode.ha.state", "High-availability state of the management node (MASTER, HOT_STANDBY, etc)");
    public static final ConfigKey<Duration> POLL_PERIOD = ConfigKeys.newConfigKey(Duration.class, (String)"brooklynnode.poll_period", (String)"Frequency to poll for client sensors", (Object)Duration.seconds((Number)2));
    @Deprecated
    @SetFromFlag(value="noShutdownOnExit")
    public static final ConfigKey<Boolean> NO_SHUTDOWN_ON_EXIT = ConfigKeys.newBooleanConfigKey((String)"brooklynnode.noshutdownonexit", (String)"Whether to pass the (deprecated) noShutdownOnExit flag to the process", (Boolean)false);
    public static final Effector<String> DEPLOY_BLUEPRINT = DeployBlueprintEffector.DEPLOY_BLUEPRINT;
    public static final Effector<Void> SHUTDOWN = ShutdownEffector.SHUTDOWN;
    public static final Effector<Void> STOP_NODE_BUT_LEAVE_APPS = StopNodeButLeaveAppsEffector.STOP_NODE_BUT_LEAVE_APPS;
    public static final Effector<Void> STOP_NODE_AND_KILL_APPS = StopNodeAndKillAppsEffector.STOP_NODE_AND_KILL_APPS;
    public static final Effector<Integer> SET_HIGH_AVAILABILITY_PRIORITY = SetHighAvailabilityPriorityEffector.SET_HIGH_AVAILABILITY_PRIORITY;
    public static final Effector<ManagementNodeState> SET_HIGH_AVAILABILITY_MODE = SetHighAvailabilityModeEffector.SET_HIGH_AVAILABILITY_MODE;

    public EntityHttpClient http();

    public static interface SetHighAvailabilityModeEffector {
        public static final ConfigKey<HighAvailabilityMode> MODE = ConfigKeys.newConfigKey(HighAvailabilityMode.class, (String)"mode", (String)"HA mode");
        public static final Effector<ManagementNodeState> SET_HIGH_AVAILABILITY_MODE = Effectors.effector(ManagementNodeState.class, (String)"setHighAvailabilityMode").description("Set the HA mode on the node, returning the existing state").parameter(MODE).buildAbstract();
    }

    public static interface SetHighAvailabilityPriorityEffector {
        public static final ConfigKey<Integer> PRIORITY = ConfigKeys.newIntegerConfigKey((String)"priority", (String)"HA priority");
        public static final Effector<Integer> SET_HIGH_AVAILABILITY_PRIORITY = Effectors.effector(Integer.class, (String)"setHighAvailabilityPriority").description("Set the HA priority on the node, returning the old priority").parameter(PRIORITY).buildAbstract();
    }

    public static interface StopNodeAndKillAppsEffector {
        public static final ConfigKey<Duration> TIMEOUT = ConfigKeys.newConfigKey(Duration.class, (String)"timeout", (String)"How long to wait before giving up on stopping the node", (Object)Duration.ONE_HOUR);
        public static final Effector<Void> STOP_NODE_AND_KILL_APPS = Effectors.effector(Void.class, (String)"stopNodeAndKillApps").description("Stop all apps managed by the Brooklyn process, stop the process, and any VM created, and unmanage this entity").parameter(TIMEOUT).buildAbstract();
    }

    public static interface StopNodeButLeaveAppsEffector {
        public static final ConfigKey<Duration> TIMEOUT = ConfigKeys.newConfigKey(Duration.class, (String)"timeout", (String)"How long to wait before giving up on stopping the node", (Object)Duration.ONE_HOUR);
        public static final Effector<Void> STOP_NODE_BUT_LEAVE_APPS = Effectors.effector(Void.class, (String)"stopNodeButLeaveApps").description("Stop the Brooklyn process, and any VM created, and unmanage this entity; but if it was managing other applications, leave them running").parameter(TIMEOUT).buildAbstract();
    }

    public static interface ShutdownEffector {
        public static final ConfigKey<Boolean> STOP_APPS_FIRST = ConfigKeys.newBooleanConfigKey((String)"stopAppsFirst", (String)"Whether to stop apps before shutting down");
        public static final ConfigKey<Boolean> FORCE_SHUTDOWN_ON_ERROR = ConfigKeys.newBooleanConfigKey((String)"forceShutdownOnError", (String)"Force shutdown if apps fail to stop or timeout");
        public static final ConfigKey<Duration> SHUTDOWN_TIMEOUT = ConfigKeys.newConfigKey(Duration.class, (String)"shutdownTimeout", (String)"A maximum delay to wait for apps to gracefully stop before giving up or forcibly exiting");
        public static final ConfigKey<Duration> REQUEST_TIMEOUT = ConfigKeys.newConfigKey(Duration.class, (String)"requestTimeout", (String)"Maximum time to block the request for the shutdown to finish, 0 to wait infinitely");
        public static final ConfigKey<Duration> DELAY_FOR_HTTP_RETURN = ConfigKeys.newConfigKey(Duration.class, (String)"delayForHttpReturn", (String)"The delay before exiting the process, to permit the REST response to be returned");
        public static final Effector<Void> SHUTDOWN = Effectors.effector(Void.class, (String)"shutdown").description("Shutdown the remote brooklyn instance (stops via the REST API only; leaves any VM)").parameter(STOP_APPS_FIRST).parameter(FORCE_SHUTDOWN_ON_ERROR).parameter(SHUTDOWN_TIMEOUT).parameter(REQUEST_TIMEOUT).parameter(DELAY_FOR_HTTP_RETURN).buildAbstract();
    }

    public static interface DeployBlueprintEffector {
        public static final ConfigKey<Map<String, Object>> BLUEPRINT_CAMP_PLAN = new MapConfigKey(Object.class, "blueprintPlan", "CAMP plan for the blueprint to be deployed; currently only supports Java map or JSON string (not yet YAML)");
        public static final ConfigKey<String> BLUEPRINT_TYPE = ConfigKeys.newStringConfigKey((String)"blueprintType");
        public static final ConfigKey<Map<String, Object>> BLUEPRINT_CONFIG = new MapConfigKey(Object.class, "blueprintConfig");
        public static final Effector<String> DEPLOY_BLUEPRINT = Effectors.effector(String.class, (String)"deployBlueprint").description("Deploy a blueprint, either given a plan (as Java map or JSON string for a map), or given URL and optional config").parameter(BLUEPRINT_TYPE).parameter(BLUEPRINT_CONFIG).parameter(BLUEPRINT_CAMP_PLAN).buildAbstract();
    }

    public static enum ExistingFileBehaviour {
        DO_NOT_USE,
        USE_EXISTING,
        OVERWRITE,
        FAIL;

    }
}

