/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.brooklynnode;

import brooklyn.entity.Effector;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.AbstractEntity;
import brooklyn.entity.basic.Attributes;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.EntityDynamicType;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.basic.Lifecycle;
import brooklyn.entity.basic.ServiceStateLogic;
import brooklyn.entity.brooklynnode.BrooklynEntityMirror;
import brooklyn.entity.brooklynnode.BrooklynNode;
import brooklyn.entity.brooklynnode.EntityHttpClient;
import brooklyn.entity.brooklynnode.EntityHttpClientImpl;
import brooklyn.entity.brooklynnode.RemoteEffectorBuilder;
import brooklyn.entity.effector.EffectorBody;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.Sensors;
import brooklyn.event.feed.http.HttpFeed;
import brooklyn.event.feed.http.HttpPollConfig;
import brooklyn.management.TaskAdaptable;
import brooklyn.util.collections.Jsonya;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.config.ConfigBag;
import brooklyn.util.http.HttpToolResponse;
import brooklyn.util.net.Urls;
import brooklyn.util.task.DynamicTasks;
import brooklyn.util.task.Tasks;
import brooklyn.util.time.Duration;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.net.MediaType;
import com.google.gson.Gson;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;

public class BrooklynEntityMirrorImpl
extends AbstractEntity
implements BrooklynEntityMirror {
    private HttpFeed mirror;

    protected void initEnrichers() {
    }

    public void init() {
        super.init();
        this.connectSensorsAsync();
        this.setAttribute(Attributes.SERVICE_STATE_ACTUAL, Lifecycle.STARTING);
    }

    public void rebind() {
        super.rebind();
        this.connectSensorsAsync();
    }

    protected void connectSensorsAsync() {
        Callable<Void> asyncTask = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String mirroredEntityUrl = (String)BrooklynEntityMirrorImpl.this.getConfig(BrooklynEntityMirror.MIRRORED_ENTITY_URL);
                Preconditions.checkNotNull((Object)mirroredEntityUrl, (Object)("Required config: " + BrooklynEntityMirror.MIRRORED_ENTITY_URL));
                BrooklynEntityMirrorImpl.this.connectSensors(mirroredEntityUrl);
                return null;
            }
        };
        DynamicTasks.queueIfPossible((TaskAdaptable)Tasks.builder().name("Start entity mirror feed").body((Callable)asyncTask).build()).orSubmitAsync((Entity)this);
    }

    protected void connectSensors(String mirroredEntityUrl) {
        Function<HttpToolResponse, Void> mirrorSensors = new Function<HttpToolResponse, Void>(){

            public Void apply(HttpToolResponse input) {
                Map sensors = (Map)new Gson().fromJson(input.getContentAsString(), Map.class);
                for (Map.Entry kv : sensors.entrySet()) {
                    BrooklynEntityMirrorImpl.this.setAttribute(Sensors.newSensor(Object.class, (String)("" + kv.getKey())), kv.getValue());
                }
                BrooklynEntityMirrorImpl.this.setAttribute(BrooklynEntityMirror.MIRROR_STATUS, "normal");
                return null;
            }
        };
        final BrooklynEntityMirrorImpl self = this;
        this.mirror = HttpFeed.builder().entity((EntityLocal)this).baseUri(mirroredEntityUrl).credentialsIfNotNull((String)this.getConfig(BrooklynNode.MANAGEMENT_USER), (String)this.getConfig(BrooklynNode.MANAGEMENT_PASSWORD)).period((Duration)this.getConfig(POLL_PERIOD)).poll((HttpPollConfig)((HttpPollConfig)HttpPollConfig.forMultiple().suburl("/sensors/current-state").onSuccess((Function)mirrorSensors)).onFailureOrException((Function)new Function<Object, Void>(){

            public Void apply(Object input) {
                int responseCode;
                ServiceStateLogic.updateMapSensorEntry((EntityLocal)self, (AttributeSensor)Attributes.SERVICE_PROBLEMS, (Object)"mirror-feed", (Object)"error contacting service");
                if (input instanceof HttpToolResponse && (responseCode = ((HttpToolResponse)input).getResponseCode()) == 404) {
                    Entities.unmanage((Entity)self);
                }
                return null;
            }
        })).poll((HttpPollConfig)HttpPollConfig.forSensor((AttributeSensor)MIRROR_SUMMARY).onSuccess((Function)new MirrorSummary())).build();
        this.populateEffectors();
    }

    private void populateEffectors() {
        HttpToolResponse result = this.http().get("/effectors");
        Collection cfgEffectors = (Collection)new Gson().fromJson(result.getContentAsString(), Collection.class);
        Collection<Effector<String>> remoteEntityEffectors = RemoteEffectorBuilder.of(cfgEffectors);
        EntityDynamicType mutableEntityType = this.getMutableEntityType();
        for (Effector<String> eff : remoteEntityEffectors) {
            if ("start".equals(eff.getName())) continue;
            mutableEntityType.addEffector(eff);
        }
    }

    protected void disconnectSensors() {
        if (this.mirror != null) {
            this.mirror.stop();
        }
    }

    public void destroy() {
        this.disconnectSensors();
    }

    @Override
    public EntityHttpClient http() {
        return new EntityHttpClientImpl((Entity)this, MIRRORED_ENTITY_URL);
    }

    public static class RemoteEffector<T>
    extends EffectorBody<T> {
        public final String remoteEffectorName;
        public final Function<HttpToolResponse, T> resultParser;

        public RemoteEffector(String remoteEffectorName, @Nullable Function<HttpToolResponse, T> resultParser) {
            this.remoteEffectorName = remoteEffectorName;
            this.resultParser = resultParser;
        }

        public T call(ConfigBag parameters) {
            MutableMap headers = MutableMap.of((Object)"Content-Type", (Object)MediaType.JSON_UTF_8.toString());
            byte[] httpBody = Jsonya.of((Map)parameters.getAllConfig()).toString().getBytes();
            String effectorUrl = Urls.mergePaths((String[])new String[]{"effectors", Urls.encode((String)this.remoteEffectorName)});
            HttpToolResponse result = ((BrooklynEntityMirror)this.entity()).http().post(effectorUrl, (Map<String, String>)headers, httpBody);
            if (this.resultParser != null) {
                return (T)this.resultParser.apply((Object)result);
            }
            return null;
        }
    }

    private class MirrorSummary
    implements Function<HttpToolResponse, Map> {
        private MirrorSummary() {
        }

        public Map apply(HttpToolResponse input) {
            Map entitySummary = (Map)new Gson().fromJson(input.getContentAsString(), Map.class);
            String catalogItemId = (String)entitySummary.get("catalogItemId");
            BrooklynEntityMirrorImpl.this.setAttribute(BrooklynEntityMirror.MIRROR_CATALOG_ITEM_ID, catalogItemId);
            return entitySummary;
        }
    }
}

