/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.brooklynnode;

import brooklyn.catalog.Catalog;
import brooklyn.config.ConfigKey;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.brooklynnode.BrooklynEntityMirrorImpl;
import brooklyn.entity.brooklynnode.BrooklynNode;
import brooklyn.entity.brooklynnode.EntityHttpClient;
import brooklyn.entity.proxying.ImplementedBy;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.Sensors;
import brooklyn.util.time.Duration;
import java.util.Map;

@Catalog(name="Brooklyn Entity Mirror", description="Provides an entity which can sit in one brooklyn domain and reflect the status of an entity via the REST API of another domain.")
@ImplementedBy(value=BrooklynEntityMirrorImpl.class)
public interface BrooklynEntityMirror
extends Entity {
    public static final ConfigKey<String> MIRRORED_ENTITY_URL = ConfigKeys.newStringConfigKey((String)"brooklyn.mirror.entity_url", (String)"URL for the entity in the remote Brooklyn mgmt endpoint");
    public static final ConfigKey<String> MIRRORED_ENTITY_ID = ConfigKeys.newStringConfigKey((String)"brooklyn.mirror.entity_id", (String)"Brooklyn ID of the entity being mirrored");
    public static final ConfigKey<String> MANAGEMENT_USER = BrooklynNode.MANAGEMENT_USER;
    public static final ConfigKey<String> MANAGEMENT_PASSWORD = BrooklynNode.MANAGEMENT_PASSWORD;
    public static final ConfigKey<Duration> POLL_PERIOD = ConfigKeys.newConfigKey(Duration.class, (String)"brooklyn.mirror.poll_period", (String)"Frequency to poll for client sensors", (Object)Duration.FIVE_SECONDS);
    public static final AttributeSensor<String> MIRROR_STATUS = Sensors.newStringSensor((String)"brooklyn.mirror.monitoring_status");
    public static final AttributeSensor<Map> MIRROR_SUMMARY = Sensors.newSensor(Map.class, (String)"brooklyn.mirror.summary", (String)"The json map returned by the entity rest endpoint (ie the EntitySummary model)");
    public static final AttributeSensor<String> MIRROR_CATALOG_ITEM_ID = Sensors.newStringSensor((String)"brooklyn.mirror.catalog_item_id", (String)"The catalog item id of the mirrored entity in the remote brooklyn");

    public EntityHttpClient http();
}

