/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.brooklynnode;

import brooklyn.enricher.Enrichers;
import brooklyn.entity.Feed;
import brooklyn.entity.basic.EntityFunctions;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.basic.EntityPredicates;
import brooklyn.entity.basic.ServiceStateLogic;
import brooklyn.entity.brooklynnode.BrooklynCluster;
import brooklyn.entity.brooklynnode.BrooklynNode;
import brooklyn.entity.brooklynnode.effector.BrooklynClusterUpgradeEffectorBody;
import brooklyn.entity.brooklynnode.effector.SelectMasterEffectorBody;
import brooklyn.entity.group.DynamicClusterImpl;
import brooklyn.event.Sensor;
import brooklyn.event.feed.function.FunctionFeed;
import brooklyn.event.feed.function.FunctionPollConfig;
import brooklyn.management.ha.ManagementNodeState;
import brooklyn.util.time.Duration;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrooklynClusterImpl
extends DynamicClusterImpl
implements BrooklynCluster {
    private static final String MSG_NO_MASTER = "No master node in cluster";
    private static final String MSG_TOO_MANY_MASTERS = "Too many master nodes in cluster";
    private static final Logger LOG = LoggerFactory.getLogger(BrooklynClusterImpl.class);

    public void init() {
        super.init();
        this.getMutableEntityType().addEffector(SelectMasterEffectorBody.SELECT_MASTER);
        this.getMutableEntityType().addEffector(BrooklynClusterUpgradeEffectorBody.UPGRADE_CLUSTER);
        ServiceStateLogic.ServiceProblemsLogic.updateProblemsIndicator((EntityLocal)this, (Sensor)MASTER_NODE, (Object)MSG_NO_MASTER);
        this.addFeed((Feed)FunctionFeed.builder().entity((EntityLocal)this).poll(((FunctionPollConfig)new FunctionPollConfig(MASTER_NODE).period(Duration.ONE_SECOND)).callable((Callable)new MasterChildFinder())).build());
        this.addEnricher(((Enrichers.TransformerBuilder)((Enrichers.TransformerBuilder)Enrichers.builder().transforming(MASTER_NODE).uniqueTag("master-node-web-uri")).publishing(BrooklynNode.WEB_CONSOLE_URI).computing(EntityFunctions.attribute(BrooklynNode.WEB_CONSOLE_URI))).build());
    }

    BrooklynNode findMasterChild() {
        ImmutableList masters = FluentIterable.from((Iterable)this.getMembers()).filter(EntityPredicates.attributeEqualTo(BrooklynNode.MANAGEMENT_NODE_STATE, (Object)ManagementNodeState.MASTER)).toList();
        if (masters.size() == 0) {
            ServiceStateLogic.ServiceProblemsLogic.updateProblemsIndicator((EntityLocal)this, (Sensor)MASTER_NODE, (Object)MSG_NO_MASTER);
            return null;
        }
        if (masters.size() == 1) {
            ServiceStateLogic.ServiceProblemsLogic.clearProblemsIndicator((EntityLocal)this, (Sensor)MASTER_NODE);
            return (BrooklynNode)Iterables.getOnlyElement((Iterable)masters);
        }
        if (masters.size() == 2) {
            LOG.warn("Two masters detected, probably a handover just occured: " + masters);
            return (BrooklynNode)masters.iterator().next();
        }
        ServiceStateLogic.ServiceProblemsLogic.updateProblemsIndicator((EntityLocal)this, (Sensor)MASTER_NODE, (Object)MSG_TOO_MANY_MASTERS);
        String msg = "Multiple (>=3) master nodes in cluster: " + masters;
        LOG.error(msg);
        throw new IllegalStateException(msg);
    }

    private final class MasterChildFinder
    implements Callable<BrooklynNode> {
        private MasterChildFinder() {
        }

        @Override
        public BrooklynNode call() throws Exception {
            return BrooklynClusterImpl.this.findMasterChild();
        }
    }
}

