/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.brooklynnode;

import brooklyn.config.ConfigKey;
import brooklyn.entity.Effector;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.brooklynnode.BrooklynClusterImpl;
import brooklyn.entity.brooklynnode.BrooklynNode;
import brooklyn.entity.brooklynnode.effector.BrooklynNodeUpgradeEffectorBody;
import brooklyn.entity.effector.Effectors;
import brooklyn.entity.group.DynamicCluster;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.entity.proxying.ImplementedBy;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.Sensors;
import java.util.Map;

@ImplementedBy(value=BrooklynClusterImpl.class)
public interface BrooklynCluster
extends DynamicCluster {
    public static final ConfigKey<EntitySpec<?>> MEMBER_SPEC = ConfigKeys.newConfigKeyWithDefault((ConfigKey)DynamicCluster.MEMBER_SPEC, (Object)EntitySpec.create(BrooklynNode.class));
    public static final AttributeSensor<BrooklynNode> MASTER_NODE = Sensors.newSensor(BrooklynNode.class, (String)"brooklyncluster.master", (String)"Pointer to the child node with MASTER state in the cluster");
    public static final Effector<Void> SELECT_MASTER = SelectMasterEffector.SELECT_MASTER;
    public static final Effector<Void> UPGRADE_CLUSTER = UpgradeClusterEffector.UPGRADE_CLUSTER;

    public static interface UpgradeClusterEffector {
        public static final ConfigKey<String> DOWNLOAD_URL = BrooklynNode.DOWNLOAD_URL.getConfigKey();
        public static final ConfigKey<Map<String, Object>> EXTRA_CONFIG = BrooklynNodeUpgradeEffectorBody.EXTRA_CONFIG;
        public static final Effector<Void> UPGRADE_CLUSTER = Effectors.effector(Void.class, (String)"upgradeCluster").description("Upgrade the cluster with new distribution version, by provisioning new nodes with the new version, failing over, and then deprovisioning the original nodes").parameter(BrooklynNode.SUGGESTED_VERSION).parameter(DOWNLOAD_URL).parameter(EXTRA_CONFIG).buildAbstract();
    }

    public static interface SelectMasterEffector {
        public static final ConfigKey<String> NEW_MASTER_ID = ConfigKeys.newStringConfigKey((String)"brooklyncluster.new_master_id", (String)"The ID of the node to become master", null);
        public static final Effector<Void> SELECT_MASTER = Effectors.effector(Void.class, (String)"selectMaster").description("Select a new master in the cluster").parameter(NEW_MASTER_ID).buildAbstract();
    }
}

