/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.basic.lifecycle;

import brooklyn.entity.basic.lifecycle.ScriptHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class ScriptPart {
    protected ScriptHelper helper;
    protected List<String> lines = new LinkedList<String>();

    public ScriptPart(ScriptHelper helper) {
        this.helper = helper;
    }

    public ScriptHelper append(CharSequence line) {
        this.lines.add(line.toString());
        return this.helper;
    }

    public ScriptHelper append(Collection<? extends CharSequence> lines) {
        for (CharSequence charSequence : lines) {
            this.append(charSequence);
        }
        return this.helper;
    }

    public ScriptHelper append(CharSequence ... lines) {
        return this.append(Arrays.asList(lines));
    }

    public ScriptHelper prepend(CharSequence line) {
        this.lines.add(0, line.toString());
        return this.helper;
    }

    public ScriptHelper prepend(Collection<? extends CharSequence> lines) {
        ArrayList<? extends CharSequence> reversedLines = new ArrayList<CharSequence>(lines);
        Collections.reverse(reversedLines);
        for (CharSequence charSequence : reversedLines) {
            this.prepend(charSequence);
        }
        return this.helper;
    }

    public ScriptHelper prepend(CharSequence ... lines) {
        return this.prepend(Arrays.asList(lines));
    }

    public ScriptHelper reset(CharSequence line) {
        return this.reset(Arrays.asList(line));
    }

    public ScriptHelper reset(List<? extends CharSequence> ll) {
        this.lines.clear();
        return this.append(ll);
    }

    public boolean isEmpty() {
        return this.lines.isEmpty();
    }
}

