/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.basic;

import brooklyn.config.ConfigKey;
import brooklyn.entity.basic.AbstractSoftwareProcessWinRmDriver;
import brooklyn.entity.basic.Attributes;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.basic.VanillaWindowsProcess;
import brooklyn.entity.basic.VanillaWindowsProcessDriver;
import brooklyn.location.basic.WinRmMachineLocation;
import brooklyn.util.net.UserAndHostAndPort;

public class VanillaWindowsProcessWinRmDriver
extends AbstractSoftwareProcessWinRmDriver
implements VanillaWindowsProcessDriver {
    public VanillaWindowsProcessWinRmDriver(EntityLocal entity, WinRmMachineLocation location) {
        super(entity, location);
    }

    @Override
    public void start() {
        WinRmMachineLocation machine = (WinRmMachineLocation)this.location;
        UserAndHostAndPort winrmAddress = UserAndHostAndPort.fromParts((String)machine.getUser(), (String)machine.getAddress().getHostName(), (int)((Integer)machine.config().get(WinRmMachineLocation.WINRM_PORT)));
        this.getEntity().setAttribute(Attributes.WINRM_ADDRESS, (Object)winrmAddress);
        super.start();
    }

    @Override
    public void preInstall() {
        super.preInstall();
        this.executeCommand((ConfigKey<String>)VanillaWindowsProcess.PRE_INSTALL_COMMAND, VanillaWindowsProcess.PRE_INSTALL_POWERSHELL_COMMAND, true);
        if (((Boolean)this.entity.getConfig(VanillaWindowsProcess.PRE_INSTALL_REBOOT_REQUIRED)).booleanValue()) {
            this.rebootAndWait();
        }
    }

    @Override
    public void install() {
        this.executeCommand(VanillaWindowsProcess.INSTALL_COMMAND, VanillaWindowsProcess.INSTALL_POWERSHELL_COMMAND, true);
        if (((Boolean)this.entity.getConfig(VanillaWindowsProcess.INSTALL_REBOOT_REQUIRED)).booleanValue()) {
            this.rebootAndWait();
        }
    }

    @Override
    public void customize() {
        this.executeCommand(VanillaWindowsProcess.CUSTOMIZE_COMMAND, VanillaWindowsProcess.CUSTOMIZE_POWERSHELL_COMMAND, true);
        if (((Boolean)this.entity.getConfig(VanillaWindowsProcess.CUSTOMIZE_REBOOT_REQUIRED)).booleanValue()) {
            this.rebootAndWait();
        }
    }

    @Override
    public void launch() {
        this.executeCommand((ConfigKey<String>)VanillaWindowsProcess.LAUNCH_COMMAND, VanillaWindowsProcess.LAUNCH_POWERSHELL_COMMAND, true);
    }

    @Override
    public boolean isRunning() {
        return this.executeCommand((ConfigKey<String>)VanillaWindowsProcess.CHECK_RUNNING_COMMAND, VanillaWindowsProcess.CHECK_RUNNING_POWERSHELL_COMMAND, false).getStatusCode() == 0;
    }

    @Override
    public void stop() {
        this.executeCommand((ConfigKey<String>)VanillaWindowsProcess.STOP_COMMAND, VanillaWindowsProcess.STOP_POWERSHELL_COMMAND, true);
    }
}

