/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.basic;

import brooklyn.config.ConfigKey;
import brooklyn.entity.basic.AbstractVanillaProcess;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.SoftwareProcess;
import brooklyn.entity.basic.VanillaWindowsProcessImpl;
import brooklyn.entity.proxying.ImplementedBy;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.Sensors;
import brooklyn.util.time.Duration;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;

@ImplementedBy(value=VanillaWindowsProcessImpl.class)
public interface VanillaWindowsProcess
extends AbstractVanillaProcess {
    public static final ConfigKey<Collection<Integer>> REQUIRED_OPEN_LOGIN_PORTS = ConfigKeys.newConfigKeyWithDefault(SoftwareProcess.REQUIRED_OPEN_LOGIN_PORTS, (Object)ImmutableSet.of((Object)5985, (Object)3389));
    public static final ConfigKey<String> PRE_INSTALL_POWERSHELL_COMMAND = ConfigKeys.newStringConfigKey((String)"pre.install.powershell.command", (String)"powershell command to run during the pre-install phase");
    public static final ConfigKey<Boolean> PRE_INSTALL_REBOOT_REQUIRED = ConfigKeys.newBooleanConfigKey((String)"pre.install.reboot.required", (String)"indicates that a reboot should be performed after the pre-install command is run", (Boolean)false);
    public static final ConfigKey<Boolean> INSTALL_REBOOT_REQUIRED = ConfigKeys.newBooleanConfigKey((String)"install.reboot.required", (String)"indicates that a reboot should be performed after the install command is run", (Boolean)false);
    public static final ConfigKey<Boolean> CUSTOMIZE_REBOOT_REQUIRED = ConfigKeys.newBooleanConfigKey((String)"customize.reboot.required", (String)"indicates that a reboot should be performed after the customize command is run", (Boolean)false);
    public static final ConfigKey<String> LAUNCH_POWERSHELL_COMMAND = ConfigKeys.newStringConfigKey((String)"launch.powershell.command", (String)"command to run to launch the process");
    public static final ConfigKey<String> CHECK_RUNNING_POWERSHELL_COMMAND = ConfigKeys.newStringConfigKey((String)"checkRunning.powershell.command", (String)"command to determine whether the process is running");
    public static final ConfigKey<String> STOP_POWERSHELL_COMMAND = ConfigKeys.newStringConfigKey((String)"stop.powershell.command", (String)"command to run to stop the process");
    public static final ConfigKey<String> CUSTOMIZE_COMMAND = ConfigKeys.newStringConfigKey((String)"customize.command", (String)"command to run during the customization phase");
    public static final ConfigKey<String> CUSTOMIZE_POWERSHELL_COMMAND = ConfigKeys.newStringConfigKey((String)"customize.powershell.command", (String)"powershell command to run during the customization phase");
    public static final ConfigKey<String> INSTALL_COMMAND = ConfigKeys.newStringConfigKey((String)"install.command", (String)"command to run during the install phase");
    public static final ConfigKey<String> INSTALL_POWERSHELL_COMMAND = ConfigKeys.newStringConfigKey((String)"install.powershell.command", (String)"powershell command to run during the install phase");
    public static final ConfigKey<Duration> REBOOT_BEGUN_TIMEOUT = ConfigKeys.newDurationConfigKey((String)"reboot.begun.timeout", (String)"duration to wait whilst waiting for a machine to begin rebooting, and thus become unavailable", (Duration)Duration.TWO_MINUTES);
    public static final ConfigKey<Duration> REBOOT_COMPLETED_TIMEOUT = ConfigKeys.newDurationConfigKey((String)"reboot.completed.timeout", (String)"duration to wait whilst waiting for a machine to finish rebooting, and thus to become available again", (Duration)Duration.minutes((Number)30));
    public static final AttributeSensor<Integer> RDP_PORT = Sensors.newIntegerSensor((String)"rdpPort");
    public static final AttributeSensor<Integer> WINRM_PORT = Sensors.newIntegerSensor((String)"winrmPort");
}

