/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.basic;

import brooklyn.entity.basic.AbstractSoftwareProcessSshDriver;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.basic.SoftwareProcess;
import brooklyn.entity.basic.VanillaSoftwareProcess;
import brooklyn.entity.basic.VanillaSoftwareProcessDriver;
import brooklyn.entity.basic.lifecycle.ScriptHelper;
import brooklyn.entity.drivers.EntityDriver;
import brooklyn.entity.drivers.downloads.DownloadResolver;
import brooklyn.location.basic.SshMachineLocation;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.file.ArchiveUtils;
import brooklyn.util.guava.Maybe;
import brooklyn.util.net.Urls;
import brooklyn.util.os.Os;
import brooklyn.util.ssh.BashCommands;
import brooklyn.util.text.Identifiers;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class VanillaSoftwareProcessSshDriver
extends AbstractSoftwareProcessSshDriver
implements VanillaSoftwareProcessDriver {
    String downloadedFilename = null;

    public VanillaSoftwareProcessSshDriver(EntityLocal entity, SshMachineLocation machine) {
        super(entity, machine);
    }

    @Override
    protected String getInstallLabelExtraSalt() {
        Maybe url = this.getEntity().getConfigRaw(SoftwareProcess.DOWNLOAD_URL, true);
        if (url.isAbsent()) {
            return null;
        }
        return Identifiers.makeIdFromHash((long)url.get().hashCode());
    }

    @Override
    public void install() {
        Maybe url = this.getEntity().getConfigRaw(SoftwareProcess.DOWNLOAD_URL, true);
        if (url.isPresentAndNonNull()) {
            DownloadResolver resolver = Entities.newDownloader((EntityDriver)this);
            List urls = resolver.getTargets();
            this.downloadedFilename = resolver.getFilename();
            LinkedList commands = new LinkedList();
            commands.addAll(BashCommands.commandsToDownloadUrlsAs((List)urls, (String)this.downloadedFilename));
            commands.addAll(ArchiveUtils.installCommands((String)this.downloadedFilename));
            int result = this.newScript((String)"installing").failOnNonZeroResultCode((boolean)false).body.append(commands).execute();
            if (result != 0) {
                for (String urlI : urls) {
                    result = ArchiveUtils.install((SshMachineLocation)this.getMachine(), (String)urlI, (String)Urls.mergePaths((String[])new String[]{this.getInstallDir(), this.downloadedFilename}));
                    if (result != 0) continue;
                    break;
                }
                if (result != 0) {
                    throw new IllegalStateException("Error installing archive: " + this.downloadedFilename);
                }
            }
        }
    }

    @Override
    public void customize() {
        if (this.downloadedFilename != null) {
            this.newScript((String)"customizing").failOnNonZeroResultCode().environmentVariablesReset().body.append(ArchiveUtils.extractCommands((String)this.downloadedFilename, (String)this.getInstallDir())).execute();
        }
    }

    @Override
    public Map<String, String> getShellEnvironment() {
        return MutableMap.copyOf(super.getShellEnvironment()).add((Object)"PID_FILE", (Object)this.getPidFile());
    }

    public String getPidFile() {
        return Os.mergePathsUnix((String[])new String[]{this.getRunDir(), "pid.txt"});
    }

    @Override
    public void launch() {
        this.newScript((String)"launching").failOnNonZeroResultCode().body.append((CharSequence)this.getEntity().getConfig(VanillaSoftwareProcess.LAUNCH_COMMAND)).execute();
    }

    @Override
    public boolean isRunning() {
        String customCommand = (String)this.getEntity().getConfig(VanillaSoftwareProcess.CHECK_RUNNING_COMMAND);
        ScriptHelper script = null;
        script = customCommand == null ? this.newScript((Map<String, ?>)MutableMap.of((Object)"usePidFile", (Object)this.getPidFile()), "check-running") : this.newScript((String)"check-running").body.append((CharSequence)customCommand);
        return script.execute() == 0;
    }

    @Override
    public void stop() {
        String customCommand = (String)this.getEntity().getConfig(VanillaSoftwareProcess.STOP_COMMAND);
        ScriptHelper script = null;
        script = customCommand == null ? this.newScript((Map<String, ?>)MutableMap.of((Object)"usePidFile", (Object)this.getPidFile()), "stopping") : this.newScript((String)"stopping").body.append((CharSequence)customCommand);
        script.execute();
    }
}

