/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.basic;

import brooklyn.config.ConfigKey;
import brooklyn.enricher.basic.AbstractEnricher;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.AbstractEntity;
import brooklyn.entity.basic.AbstractSoftwareProcessDriver;
import brooklyn.entity.basic.Attributes;
import brooklyn.entity.basic.BrooklynConfigKeys;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.basic.Lifecycle;
import brooklyn.entity.basic.ServiceStateLogic;
import brooklyn.entity.basic.SoftwareProcess;
import brooklyn.entity.basic.SoftwareProcessDriver;
import brooklyn.entity.basic.SoftwareProcessDriverLifecycleEffectorTasks;
import brooklyn.entity.drivers.DriverDependentEntity;
import brooklyn.entity.drivers.EntityDriverManager;
import brooklyn.event.Sensor;
import brooklyn.event.SensorEvent;
import brooklyn.event.SensorEventListener;
import brooklyn.event.feed.function.FunctionFeed;
import brooklyn.event.feed.function.FunctionPollConfig;
import brooklyn.location.Location;
import brooklyn.location.MachineLocation;
import brooklyn.location.MachineProvisioningLocation;
import brooklyn.location.PortRange;
import brooklyn.location.basic.LocationConfigKeys;
import brooklyn.location.basic.Machines;
import brooklyn.location.cloud.CloudLocationConfig;
import brooklyn.management.Task;
import brooklyn.management.TaskAdaptable;
import brooklyn.policy.EnricherSpec;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.collections.MutableSet;
import brooklyn.util.config.ConfigBag;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.task.DynamicTasks;
import brooklyn.util.task.Tasks;
import brooklyn.util.time.CountdownTimer;
import brooklyn.util.time.Duration;
import brooklyn.util.time.Time;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import groovy.time.TimeDuration;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SoftwareProcessImpl
extends AbstractEntity
implements SoftwareProcess,
DriverDependentEntity {
    private static final Logger log = LoggerFactory.getLogger(SoftwareProcessImpl.class);
    private transient SoftwareProcessDriver driver;
    private volatile FunctionFeed serviceProcessIsRunning;
    private static final SoftwareProcessDriverLifecycleEffectorTasks LIFECYCLE_TASKS = new SoftwareProcessDriverLifecycleEffectorTasks();
    protected boolean connectedSensors = false;

    public SoftwareProcessImpl() {
        super((Map)MutableMap.of(), null);
    }

    public SoftwareProcessImpl(Entity parent) {
        this((Map)MutableMap.of(), parent);
    }

    public SoftwareProcessImpl(Map properties) {
        this(properties, null);
    }

    public SoftwareProcessImpl(Map properties, Entity parent) {
        super(properties, parent);
    }

    protected void setProvisioningLocation(MachineProvisioningLocation val) {
        if (this.getAttribute(PROVISIONING_LOCATION) != null) {
            throw new IllegalStateException("Cannot change provisioning location: existing=" + this.getAttribute(PROVISIONING_LOCATION) + "; new=" + val);
        }
        this.setAttribute(PROVISIONING_LOCATION, val);
    }

    protected MachineProvisioningLocation getProvisioningLocation() {
        return (MachineProvisioningLocation)this.getAttribute(PROVISIONING_LOCATION);
    }

    public SoftwareProcessDriver getDriver() {
        return this.driver;
    }

    protected SoftwareProcessDriver newDriver(MachineLocation loc) {
        EntityDriverManager entityDriverManager = this.getManagementContext().getEntityDriverManager();
        return (SoftwareProcessDriver)entityDriverManager.build((DriverDependentEntity)this, (Location)loc);
    }

    protected MachineLocation getMachineOrNull() {
        return (MachineLocation)Iterables.get((Iterable)Iterables.filter((Iterable)this.getLocations(), MachineLocation.class), (int)0, null);
    }

    public void init() {
        super.init();
        LIFECYCLE_TASKS.attachLifecycleEffectors(this);
    }

    protected void initEnrichers() {
        super.initEnrichers();
        ServiceStateLogic.ServiceNotUpLogic.updateNotUpIndicator((EntityLocal)this, (Sensor)SERVICE_PROCESS_IS_RUNNING, (Object)"No information yet on whether this service is running");
        this.addEnricher(EnricherSpec.create(UpdatingNotUpFromServiceProcessIsRunning.class).uniqueTag("service-process-is-running-updating-not-up"));
    }

    protected void preStart() {
    }

    protected void postDriverStart() {
        this.waitForEntityStart();
    }

    protected void connectSensors() {
        this.connectedSensors = true;
    }

    protected void connectServiceUpIsRunning() {
        this.serviceProcessIsRunning = FunctionFeed.builder().entity((EntityLocal)this).period(Duration.FIVE_SECONDS).poll(((FunctionPollConfig)new FunctionPollConfig(SERVICE_PROCESS_IS_RUNNING).onException(Functions.constant((Object)Boolean.FALSE))).callable((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return SoftwareProcessImpl.this.getDriver().isRunning();
            }
        })).build();
    }

    protected void disconnectServiceUpIsRunning() {
        if (this.serviceProcessIsRunning != null) {
            this.serviceProcessIsRunning.stop();
        }
        this.setAttribute(SERVICE_PROCESS_IS_RUNNING, null);
        this.removeAttribute(SERVICE_PROCESS_IS_RUNNING);
    }

    protected void postStart() {
    }

    protected void preStopConfirmCustom() {
    }

    protected void preStop() {
        log.debug("disconnecting sensors for " + this + " in entity.preStop");
        this.disconnectSensors();
        this.setAttribute(SoftwareProcess.SERVICE_PROCESS_IS_RUNNING, false);
    }

    protected void postStop() {
    }

    protected void preRestart() {
    }

    protected void postRestart() {
    }

    protected void disconnectSensors() {
        this.connectedSensors = false;
    }

    protected void postRebind() {
    }

    protected void callRebindHooks() {
        Duration configuredMaxDelay = (Duration)this.getConfig(MAXIMUM_REBIND_SENSOR_CONNECT_DELAY);
        if (configuredMaxDelay == null || Duration.ZERO.equals((Object)configuredMaxDelay)) {
            this.connectSensors();
        } else {
            long delay = (long)(Math.random() * (double)configuredMaxDelay.toMilliseconds());
            log.debug("Scheduled reconnection of sensors on {} in {}ms", (Object)this, (Object)delay);
            Timer timer = new Timer();
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    try {
                        if (SoftwareProcessImpl.this.getManagementSupport().isNoLongerManaged()) {
                            log.debug("Entity {} no longer managed; ignoring scheduled connect sensors on rebind", (Object)SoftwareProcessImpl.this);
                            return;
                        }
                        SoftwareProcessImpl.this.connectSensors();
                    }
                    catch (Throwable e) {
                        log.warn("Problem connecting sensors on rebind of " + SoftwareProcessImpl.this, e);
                        Exceptions.propagateIfFatal((Throwable)e);
                    }
                }
            }, delay);
        }
    }

    public void onManagementStarting() {
        super.onManagementStarting();
        Lifecycle state = (Lifecycle)this.getAttribute(SERVICE_STATE_ACTUAL);
        if (state == null || state == Lifecycle.CREATED) {
            this.setAttribute(SERVICE_UP, false);
            ServiceStateLogic.setExpectedState((Entity)this, (Lifecycle)Lifecycle.CREATED);
            this.setAttribute(SERVICE_STATE_ACTUAL, Lifecycle.CREATED);
        }
    }

    public void onManagementStarted() {
        super.onManagementStarted();
        Lifecycle state = (Lifecycle)this.getAttribute(SERVICE_STATE_ACTUAL);
        if (state != null && state != Lifecycle.CREATED) {
            this.postRebind();
        }
    }

    public void rebind() {
        Lifecycle.Transition expectedState = (Lifecycle.Transition)this.getAttribute(SERVICE_STATE_EXPECTED);
        if (expectedState == null || expectedState.getState() != Lifecycle.RUNNING) {
            log.warn("On rebind of {}, not calling software process rebind hooks because expected state is {}", (Object)this, (Object)expectedState);
            return;
        }
        Lifecycle actualState = (Lifecycle)this.getAttribute(SERVICE_STATE_ACTUAL);
        if (actualState == null || actualState != Lifecycle.RUNNING) {
            log.warn("Rebinding entity {}, even though actual state is {}. Expected state is {}", new Object[]{this, actualState, expectedState});
        }
        log.info("Rebind {} connecting to pre-running service", (Object)this);
        MachineLocation machine = this.getMachineOrNull();
        if (machine != null) {
            this.initDriver(machine);
            this.driver.rebind();
            if (log.isDebugEnabled()) {
                log.debug("On rebind of {}, re-created driver {}", (Object)this, (Object)this.driver);
            }
        } else {
            log.info("On rebind of {}, no MachineLocation found (with locations {}) so not generating driver", (Object)this, (Object)this.getLocations());
        }
        this.callRebindHooks();
    }

    public void waitForServiceUp() {
        Duration timeout = (Duration)this.getConfig(BrooklynConfigKeys.START_TIMEOUT);
        this.waitForServiceUp(timeout);
    }

    public void waitForServiceUp(Duration duration) {
        Entities.waitForServiceUp((Entity)this, (Duration)duration);
    }

    public void waitForServiceUp(TimeDuration duration) {
        this.waitForServiceUp(duration.toMilliseconds(), TimeUnit.MILLISECONDS);
    }

    public void waitForServiceUp(long duration, TimeUnit units) {
        Entities.waitForServiceUp((Entity)this, (Duration)Duration.of((long)duration, (TimeUnit)units));
    }

    @Deprecated
    public void checkModifiable() {
        Lifecycle state = (Lifecycle)this.getAttribute(SERVICE_STATE_ACTUAL);
        if (this.getAttribute(SERVICE_STATE_ACTUAL) == Lifecycle.RUNNING) {
            return;
        }
        if (this.getAttribute(SERVICE_STATE_ACTUAL) == Lifecycle.STARTING) {
            return;
        }
        throw new IllegalStateException("Cannot configure entity " + this + " in state " + state);
    }

    protected final void startInLocation(Collection<? extends Location> locations) {
    }

    protected final void startInLocation(Location location) {
    }

    protected final void startInLocation(MachineProvisioningLocation<?> location) {
    }

    protected final void startInLocation(MachineLocation machine) {
    }

    protected final void callStartHooks() {
    }

    protected Map<String, Object> obtainProvisioningFlags(MachineProvisioningLocation location) {
        ConfigBag result = ConfigBag.newInstance((Map)location.getProvisioningFlags((Collection)ImmutableList.of((Object)this.getClass().getName())));
        result.putAll((Map)this.getConfig((ConfigKey)PROVISIONING_PROPERTIES));
        if (result.get(CloudLocationConfig.INBOUND_PORTS) == null) {
            Collection<Integer> ports = this.getRequiredOpenPorts();
            Object requiredPorts = result.get(CloudLocationConfig.ADDITIONAL_INBOUND_PORTS);
            if (requiredPorts instanceof Integer) {
                ports.add((Integer)requiredPorts);
            } else if (requiredPorts instanceof Iterable) {
                for (Object o : (Iterable)requiredPorts) {
                    if (!(o instanceof Integer)) continue;
                    ports.add((Integer)o);
                }
            }
            if (ports != null && ports.size() > 0) {
                result.put(CloudLocationConfig.INBOUND_PORTS, ports);
            }
        }
        result.put(LocationConfigKeys.CALLER_CONTEXT, (Object)this);
        return result.getAllConfigMutable();
    }

    protected Collection<Integer> getRequiredOpenPorts() {
        MutableSet ports = MutableSet.copyOf((Iterable)((Iterable)this.getConfig(REQUIRED_OPEN_LOGIN_PORTS)));
        Map allConfig = this.config().getBag().getAllConfigAsConfigKeyMap();
        HashSet configKeys = Sets.newHashSet(allConfig.keySet());
        configKeys.addAll(this.getEntityType().getConfigKeys());
        for (ConfigKey k : configKeys) {
            Object value;
            if (PortRange.class.isAssignableFrom(k.getType())) {
                PortRange p = (PortRange)this.getConfig(k);
                if (p == null || p.isEmpty()) continue;
                ports.add(p.iterator().next());
                continue;
            }
            if (!k.getName().matches(".*\\.port") || !((value = this.getConfig(k)) instanceof Integer)) continue;
            ports.add((Integer)value);
        }
        log.debug("getRequiredOpenPorts detected default {} for {}", (Object)ports, (Object)this);
        return ports;
    }

    @Deprecated
    public String getLocalHostname() {
        return (String)Machines.findSubnetHostname((Entity)this).get();
    }

    protected void initDriver(MachineLocation machine) {
        SoftwareProcessDriver newDriver = this.doInitDriver(machine);
        if (newDriver == null) {
            throw new UnsupportedOperationException("cannot start " + this + " on " + machine + ": no driver available");
        }
        this.driver = newDriver;
    }

    protected SoftwareProcessDriver doInitDriver(MachineLocation machine) {
        if (this.driver != null) {
            if (this.driver instanceof AbstractSoftwareProcessDriver && machine.equals(((AbstractSoftwareProcessDriver)this.driver).getLocation())) {
                return this.driver;
            }
            log.warn("driver/location change is untested for {} at {}; changing driver and continuing", (Object)this, (Object)machine);
            return this.newDriver(machine);
        }
        return this.newDriver(machine);
    }

    public void waitForEntityStart() {
        if (log.isDebugEnabled()) {
            log.debug("waiting to ensure {} doesn't abort prematurely", (Object)this);
        }
        Duration startTimeout = (Duration)this.getConfig(START_TIMEOUT);
        CountdownTimer timer = startTimeout.countdownTimer();
        boolean isRunningResult = false;
        long delay = 100L;
        Exception firstFailure = null;
        while (!isRunningResult && !timer.isExpired()) {
            block11: {
                Time.sleep((long)delay);
                try {
                    isRunningResult = this.driver.isRunning();
                    if (log.isDebugEnabled()) {
                        log.debug("checked {}, 'is running' returned: {}", (Object)this, (Object)isRunningResult);
                    }
                }
                catch (Exception e) {
                    Exceptions.propagateIfFatal((Throwable)e);
                    isRunningResult = false;
                    if (this.driver != null) {
                        String msg = "checked " + this + ", 'is running' threw an exception; logging subsequent exceptions at debug level";
                        if (firstFailure == null) {
                            log.error(msg, (Throwable)e);
                        } else {
                            log.debug(msg, (Throwable)e);
                        }
                    } else {
                        log.error(this + " concurrent start and shutdown detected", (Throwable)e);
                    }
                    if (firstFailure != null) break block11;
                    firstFailure = e;
                }
            }
            delay = Math.min(delay * 11L / 10L, 5000L);
        }
        if (!isRunningResult) {
            String msg = "Software process entity " + this + " did not pass is-running check within " + "the required " + startTimeout + " limit (" + timer.getDurationElapsed().toStringRounded() + " elapsed)";
            if (firstFailure != null) {
                msg = msg + "; check failed at least once with exception: " + firstFailure.getMessage() + ", see logs for details";
            }
            log.warn(msg + " (throwing)");
            ServiceStateLogic.setExpectedState((Entity)this, (Lifecycle)Lifecycle.RUNNING);
            throw new IllegalStateException(msg, firstFailure);
        }
    }

    public final void start(final Collection<? extends Location> locations) {
        if (DynamicTasks.getTaskQueuingContext() != null) {
            this.doStart(locations);
        } else {
            Task task = Tasks.builder().name("start (sequential)").body(new Runnable(){

                @Override
                public void run() {
                    SoftwareProcessImpl.this.doStart(locations);
                }
            }).build();
            ((Task)Entities.submit((Entity)this, (TaskAdaptable)task)).getUnchecked();
        }
    }

    public final void stop() {
        if (DynamicTasks.getTaskQueuingContext() != null) {
            this.doStop();
        } else {
            Task task = Tasks.builder().name("stop").body(new Runnable(){

                @Override
                public void run() {
                    SoftwareProcessImpl.this.doStop();
                }
            }).build();
            ((Task)Entities.submit((Entity)this, (TaskAdaptable)task)).getUnchecked();
        }
    }

    public final void restart() {
        if (DynamicTasks.getTaskQueuingContext() != null) {
            this.doRestart(ConfigBag.EMPTY);
        } else {
            Task task = Tasks.builder().name("restart").body(new Runnable(){

                @Override
                public void run() {
                    SoftwareProcessImpl.this.doRestart(ConfigBag.EMPTY);
                }
            }).build();
            ((Task)Entities.submit((Entity)this, (TaskAdaptable)task)).getUnchecked();
        }
    }

    @Deprecated
    protected final void doStart(Collection<? extends Location> locations) {
        LIFECYCLE_TASKS.start(locations);
    }

    @Deprecated
    protected final void doStop() {
        LIFECYCLE_TASKS.stop();
    }

    @Deprecated
    protected final void doRestart(ConfigBag parameters) {
        LIFECYCLE_TASKS.restart(parameters);
    }

    @Deprecated
    protected final void doRestart() {
        this.doRestart(ConfigBag.EMPTY);
    }

    protected static class UpdatingNotUpFromServiceProcessIsRunning
    extends AbstractEnricher
    implements SensorEventListener<Object> {
        public void setEntity(EntityLocal entity) {
            super.setEntity(entity);
            this.subscribe((Entity)entity, (Sensor)SoftwareProcess.SERVICE_PROCESS_IS_RUNNING, this);
            this.subscribe((Entity)entity, (Sensor)Attributes.SERVICE_UP, this);
            this.onUpdated();
        }

        public void onEvent(SensorEvent<Object> event) {
            this.onUpdated();
        }

        protected void onUpdated() {
            Boolean isRunning = (Boolean)this.entity.getAttribute(SoftwareProcess.SERVICE_PROCESS_IS_RUNNING);
            if (Boolean.FALSE.equals(isRunning)) {
                ServiceStateLogic.ServiceNotUpLogic.updateNotUpIndicator((EntityLocal)this.entity, SoftwareProcess.SERVICE_PROCESS_IS_RUNNING, (Object)"The software process for this entity does not appear to be running");
                return;
            }
            if (Boolean.TRUE.equals(isRunning)) {
                ServiceStateLogic.ServiceNotUpLogic.clearNotUpIndicator((EntityLocal)this.entity, SoftwareProcess.SERVICE_PROCESS_IS_RUNNING);
                return;
            }
            Boolean isUp = (Boolean)this.entity.getAttribute(Attributes.SERVICE_UP);
            if (Boolean.TRUE.equals(isUp)) {
                ServiceStateLogic.ServiceNotUpLogic.clearNotUpIndicator((EntityLocal)this.entity, SoftwareProcess.SERVICE_PROCESS_IS_RUNNING);
                return;
            }
            ServiceStateLogic.ServiceNotUpLogic.updateNotUpIndicator((EntityLocal)this.entity, SoftwareProcess.SERVICE_PROCESS_IS_RUNNING, (Object)"No information on whether this service is running");
        }
    }
}

