/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.basic;

import brooklyn.entity.Entity;
import brooklyn.entity.basic.Attributes;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.Lifecycle;
import brooklyn.entity.basic.ServiceStateLogic;
import brooklyn.entity.basic.SoftwareProcess;
import brooklyn.entity.basic.SoftwareProcessImpl;
import brooklyn.entity.software.MachineLifecycleEffectorTasks;
import brooklyn.entity.trait.StartableMethods;
import brooklyn.location.Location;
import brooklyn.location.MachineLocation;
import brooklyn.location.MachineProvisioningLocation;
import brooklyn.management.TaskAdaptable;
import brooklyn.util.config.ConfigBag;
import brooklyn.util.task.DynamicTasks;
import brooklyn.util.text.Strings;
import com.google.common.annotations.Beta;
import com.google.common.base.Supplier;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class SoftwareProcessDriverLifecycleEffectorTasks
extends MachineLifecycleEffectorTasks {
    private static final Logger log = LoggerFactory.getLogger(SoftwareProcessDriverLifecycleEffectorTasks.class);

    @Override
    public void restart(ConfigBag parameters) {
        SoftwareProcess.RestartSoftwareParameters.RestartMachineMode isRestartMachine = (SoftwareProcess.RestartSoftwareParameters.RestartMachineMode)((Object)parameters.get(SoftwareProcess.RestartSoftwareParameters.RESTART_MACHINE_TYPED));
        if (isRestartMachine == null) {
            isRestartMachine = SoftwareProcess.RestartSoftwareParameters.RestartMachineMode.AUTO;
        }
        if (isRestartMachine == SoftwareProcess.RestartSoftwareParameters.RestartMachineMode.AUTO) {
            SoftwareProcess.RestartSoftwareParameters.RestartMachineMode restartMachineMode = isRestartMachine = this.getDefaultRestartStopsMachine() ? SoftwareProcess.RestartSoftwareParameters.RestartMachineMode.TRUE : SoftwareProcess.RestartSoftwareParameters.RestartMachineMode.FALSE;
        }
        if (isRestartMachine == SoftwareProcess.RestartSoftwareParameters.RestartMachineMode.TRUE) {
            log.debug("restart of " + this.entity() + " requested be applied at machine level");
            super.restart(parameters);
            return;
        }
        DynamicTasks.queue((String)"pre-restart", (Runnable)new Runnable(){

            @Override
            public void run() {
                SoftwareProcessDriverLifecycleEffectorTasks.this.preRestartCustom();
            }
        });
        log.debug("restart of " + this.entity() + " appears to have driver and hostname - doing driver-level restart");
        this.entity().getDriver().restart();
        this.restartChildren(parameters);
        DynamicTasks.queue((String)"post-restart", (Runnable)new Runnable(){

            @Override
            public void run() {
                SoftwareProcessDriverLifecycleEffectorTasks.this.postStartCustom();
                SoftwareProcessDriverLifecycleEffectorTasks.this.postRestartCustom();
                ServiceStateLogic.setExpectedState((Entity)SoftwareProcessDriverLifecycleEffectorTasks.this.entity(), (Lifecycle)Lifecycle.RUNNING);
            }
        });
    }

    @Override
    protected boolean getDefaultRestartStopsMachine() {
        if (this.entity().getDriver() == null) {
            log.debug("restart of " + this.entity() + " has no driver - doing machine-level restart");
            return true;
        }
        if (Strings.isEmpty((CharSequence)((CharSequence)this.entity().getAttribute(Attributes.HOSTNAME)))) {
            log.debug("restart of " + this.entity() + " has no hostname - doing machine-level restart");
            return true;
        }
        return false;
    }

    protected SoftwareProcessImpl entity() {
        return (SoftwareProcessImpl)super.entity();
    }

    @Override
    protected Map<String, Object> obtainProvisioningFlags(MachineProvisioningLocation<?> location) {
        return this.entity().obtainProvisioningFlags(location);
    }

    @Override
    protected void preStartCustom(MachineLocation machine) {
        this.entity().initDriver(machine);
        super.preStartCustom(machine);
        this.entity().preStart();
    }

    protected SoftwareProcess.ChildStartableMode getChildrenStartableModeEffective() {
        if (this.entity().getChildren().isEmpty()) {
            return SoftwareProcess.ChildStartableMode.NONE;
        }
        SoftwareProcess.ChildStartableMode result = (SoftwareProcess.ChildStartableMode)((Object)this.entity().getConfig(SoftwareProcess.CHILDREN_STARTABLE_MODE));
        if (result != null) {
            return result;
        }
        return SoftwareProcess.ChildStartableMode.NONE;
    }

    @Override
    protected String startProcessesAtMachine(Supplier<MachineLocation> machineS) {
        SoftwareProcess.ChildStartableMode mode = this.getChildrenStartableModeEffective();
        TaskAdaptable children = null;
        if (!mode.isDisabled) {
            children = StartableMethods.startingChildren((Entity)this.entity(), (Location)((Location)machineS.get()));
            if (!mode.isLate) {
                Entities.submit((Entity)this.entity(), (TaskAdaptable)children);
            }
        }
        this.entity().getDriver().start();
        String result = "Started with driver " + this.entity().getDriver();
        if (!mode.isDisabled) {
            if (mode.isLate) {
                DynamicTasks.waitForLast();
                if (mode.isBackground) {
                    Entities.submit((Entity)this.entity(), (TaskAdaptable)children);
                } else {
                    DynamicTasks.queue((TaskAdaptable)children);
                }
            }
            if (!mode.isBackground) {
                children.asTask().getUnchecked();
            }
            result = result + "; children started " + (Object)((Object)mode);
        }
        return result;
    }

    @Override
    protected void postStartCustom() {
        this.entity().postDriverStart();
        if (this.entity().connectedSensors) {
            log.debug("skipping connecting sensors for " + this.entity() + " in driver-tasks postStartCustom because already connected (e.g. restarting)");
        } else {
            log.debug("connecting sensors for " + this.entity() + " in driver-tasks postStartCustom because already connected (e.g. restarting)");
            this.entity().connectSensors();
        }
        this.entity().waitForServiceUp();
        this.entity().postStart();
    }

    @Override
    protected void preStopConfirmCustom() {
        super.preStopConfirmCustom();
        this.entity().preStopConfirmCustom();
    }

    @Override
    protected void preStopCustom() {
        super.preStopCustom();
        this.entity().preStop();
    }

    @Override
    protected void preRestartCustom() {
        super.preRestartCustom();
        this.entity().preRestart();
    }

    @Override
    protected void postRestartCustom() {
        super.postRestartCustom();
        this.entity().postRestart();
    }

    @Override
    protected String stopProcessesAtMachine() {
        String result;
        SoftwareProcess.ChildStartableMode mode = this.getChildrenStartableModeEffective();
        TaskAdaptable children = null;
        Exception childException = null;
        if (!mode.isDisabled) {
            children = StartableMethods.stoppingChildren((Entity)this.entity());
            if (mode.isBackground || !mode.isLate) {
                Entities.submit((Entity)this.entity(), (TaskAdaptable)children);
            } else {
                DynamicTasks.queue((TaskAdaptable)children);
                try {
                    DynamicTasks.waitForLast();
                }
                catch (Exception e) {
                    childException = e;
                }
            }
        }
        if (this.entity().getDriver() != null) {
            this.entity().getDriver().stop();
            result = "Driver stop completed";
        } else {
            result = "No driver (nothing to do here)";
        }
        if (!mode.isDisabled && !mode.isBackground) {
            try {
                children.asTask().get();
            }
            catch (Exception e) {
                childException = e;
                log.debug("Error stopping children; continuing and will rethrow if no other errors", (Throwable)e);
            }
        }
        if (childException != null) {
            throw new IllegalStateException(result + "; but error stopping child: " + childException, childException);
        }
        return result;
    }

    @Override
    protected void postStopCustom() {
        super.postStopCustom();
        this.entity().postStop();
    }
}

