/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.basic;

import brooklyn.config.ConfigKey;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.Attributes;
import brooklyn.entity.basic.BrooklynConfigKeys;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.Lifecycle;
import brooklyn.entity.trait.Startable;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.AttributeSensorAndConfigKey;
import brooklyn.event.basic.MapConfigKey;
import brooklyn.event.basic.Sensors;
import brooklyn.location.MachineProvisioningLocation;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.flags.SetFromFlag;
import brooklyn.util.time.Duration;
import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import java.util.Collection;
import java.util.Map;

public interface SoftwareProcess
extends Entity,
Startable {
    public static final AttributeSensor<String> HOSTNAME = Attributes.HOSTNAME;
    public static final AttributeSensor<String> ADDRESS = Attributes.ADDRESS;
    public static final AttributeSensor<String> SUBNET_HOSTNAME = Attributes.SUBNET_HOSTNAME;
    public static final AttributeSensor<String> SUBNET_ADDRESS = Attributes.SUBNET_ADDRESS;
    public static final ConfigKey<Collection<Integer>> REQUIRED_OPEN_LOGIN_PORTS = ConfigKeys.newConfigKey((TypeToken)new TypeToken<Collection<Integer>>(){}, (String)"requiredOpenLoginPorts", (String)"The port(s) to be opened, to allow login", (Object)ImmutableSet.of((Object)22));
    @SetFromFlag(value="startTimeout")
    public static final ConfigKey<Duration> START_TIMEOUT = BrooklynConfigKeys.START_TIMEOUT;
    @SetFromFlag(value="startLatch")
    public static final ConfigKey<Boolean> START_LATCH = BrooklynConfigKeys.START_LATCH;
    @SetFromFlag(value="setupLatch")
    public static final ConfigKey<Boolean> SETUP_LATCH = BrooklynConfigKeys.SETUP_LATCH;
    @SetFromFlag(value="installResourcesLatch")
    public static final ConfigKey<Boolean> INSTALL_RESOURCES_LATCH = BrooklynConfigKeys.INSTALL_RESOURCES_LATCH;
    @SetFromFlag(value="installLatch")
    public static final ConfigKey<Boolean> INSTALL_LATCH = BrooklynConfigKeys.INSTALL_LATCH;
    @SetFromFlag(value="runtimeResourcesLatch")
    public static final ConfigKey<Boolean> RUNTIME_RESOURCES_LATCH = BrooklynConfigKeys.RUNTIME_RESOURCES_LATCH;
    @SetFromFlag(value="customizeLatch")
    public static final ConfigKey<Boolean> CUSTOMIZE_LATCH = BrooklynConfigKeys.CUSTOMIZE_LATCH;
    @SetFromFlag(value="launchLatch")
    public static final ConfigKey<Boolean> LAUNCH_LATCH = BrooklynConfigKeys.LAUNCH_LATCH;
    @SetFromFlag(value="skipStart")
    public static final ConfigKey<Boolean> ENTITY_STARTED = BrooklynConfigKeys.SKIP_ENTITY_START;
    @SetFromFlag(value="skipStartIfRunning")
    public static final ConfigKey<Boolean> SKIP_ENTITY_START_IF_RUNNING = BrooklynConfigKeys.SKIP_ENTITY_START_IF_RUNNING;
    @SetFromFlag(value="skipInstall")
    public static final ConfigKey<Boolean> SKIP_INSTALLATION = BrooklynConfigKeys.SKIP_ENTITY_INSTALLATION;
    @SetFromFlag(value="preInstallCommand")
    public static final ConfigKey<String> PRE_INSTALL_COMMAND = BrooklynConfigKeys.PRE_INSTALL_COMMAND;
    @SetFromFlag(value="postInstallCommand")
    public static final ConfigKey<String> POST_INSTALL_COMMAND = BrooklynConfigKeys.POST_INSTALL_COMMAND;
    @SetFromFlag(value="preLaunchCommand")
    public static final ConfigKey<String> PRE_LAUNCH_COMMAND = BrooklynConfigKeys.PRE_LAUNCH_COMMAND;
    @SetFromFlag(value="postLaunchCommand")
    public static final ConfigKey<String> POST_LAUNCH_COMMAND = BrooklynConfigKeys.POST_LAUNCH_COMMAND;
    @SetFromFlag(value="version")
    public static final ConfigKey<String> SUGGESTED_VERSION = BrooklynConfigKeys.SUGGESTED_VERSION;
    @SetFromFlag(value="downloadUrl")
    public static final AttributeSensorAndConfigKey<String, String> DOWNLOAD_URL = Attributes.DOWNLOAD_URL;
    @SetFromFlag(value="downloadAddonUrls")
    public static final AttributeSensorAndConfigKey<Map<String, String>, Map<String, String>> DOWNLOAD_ADDON_URLS = Attributes.DOWNLOAD_ADDON_URLS;
    @SetFromFlag(value="installLabel")
    public static final ConfigKey<String> INSTALL_UNIQUE_LABEL = BrooklynConfigKeys.INSTALL_UNIQUE_LABEL;
    @SetFromFlag(value="expandedInstallDir")
    public static final AttributeSensorAndConfigKey<String, String> EXPANDED_INSTALL_DIR = BrooklynConfigKeys.EXPANDED_INSTALL_DIR;
    @SetFromFlag(value="installDir")
    public static final AttributeSensorAndConfigKey<String, String> INSTALL_DIR = BrooklynConfigKeys.INSTALL_DIR;
    @Deprecated
    public static final ConfigKey<String> SUGGESTED_INSTALL_DIR = BrooklynConfigKeys.SUGGESTED_INSTALL_DIR;
    @SetFromFlag(value="runDir")
    public static final AttributeSensorAndConfigKey<String, String> RUN_DIR = BrooklynConfigKeys.RUN_DIR;
    @Deprecated
    public static final ConfigKey<String> SUGGESTED_RUN_DIR = BrooklynConfigKeys.SUGGESTED_RUN_DIR;
    @SetFromFlag(value="preInstallFiles")
    @Beta
    public static final ConfigKey<Map<String, String>> PRE_INSTALL_FILES = ConfigKeys.newConfigKey((TypeToken)new TypeToken<Map<String, String>>(){}, (String)"files.preinstall", (String)"Mapping of files, to be copied before install, to destination name relative to installDir");
    @SetFromFlag(value="preInstallTemplates")
    @Beta
    public static final ConfigKey<Map<String, String>> PRE_INSTALL_TEMPLATES = ConfigKeys.newConfigKey((TypeToken)new TypeToken<Map<String, String>>(){}, (String)"templates.preinstall", (String)"Mapping of templates, to be filled in and copied before pre-install, to destination name relative to installDir");
    @SetFromFlag(value="installFiles")
    @Beta
    public static final ConfigKey<Map<String, String>> INSTALL_FILES = ConfigKeys.newConfigKey((TypeToken)new TypeToken<Map<String, String>>(){}, (String)"files.install", (String)"Mapping of files, to be copied before install, to destination name relative to installDir");
    @SetFromFlag(value="installTemplates")
    @Beta
    public static final ConfigKey<Map<String, String>> INSTALL_TEMPLATES = ConfigKeys.newConfigKey((TypeToken)new TypeToken<Map<String, String>>(){}, (String)"templates.install", (String)"Mapping of templates, to be filled in and copied before install, to destination name relative to installDir");
    @SetFromFlag(value="runtimeFiles")
    @Beta
    public static final ConfigKey<Map<String, String>> RUNTIME_FILES = ConfigKeys.newConfigKey((TypeToken)new TypeToken<Map<String, String>>(){}, (String)"files.runtime", (String)"Mapping of files, to be copied before customisation, to destination name relative to runDir");
    @SetFromFlag(value="runtimeTemplates")
    @Beta
    public static final ConfigKey<Map<String, String>> RUNTIME_TEMPLATES = ConfigKeys.newConfigKey((TypeToken)new TypeToken<Map<String, String>>(){}, (String)"templates.runtime", (String)"Mapping of templates, to be filled in and copied before customisation, to destination name relative to runDir");
    @SetFromFlag(value="env")
    public static final MapConfigKey<Object> SHELL_ENVIRONMENT = new MapConfigKey(Object.class, "shell.env", "Map of environment variables to pass to the runtime shell", (Map)MutableMap.of());
    @SetFromFlag(value="provisioningProperties")
    public static final MapConfigKey<Object> PROVISIONING_PROPERTIES = new MapConfigKey(Object.class, "provisioning.properties", "Custom properties to be passed in when provisioning a new machine", (Map)MutableMap.of());
    @SetFromFlag(value="maxRebindSensorsDelay")
    public static final ConfigKey<Duration> MAXIMUM_REBIND_SENSOR_CONNECT_DELAY = ConfigKeys.newConfigKey(Duration.class, (String)"softwareProcess.maxSensorRebindDelay", (String)"The maximum delay to apply when reconnecting sensors when rebinding to this entity. Brooklyn will wait a random amount of time, up to the value of this config key, to avoid a thundering herd problem when the entity shares its machine with several others. Set to null or to 0 to disable any delay.", (Object)Duration.TEN_SECONDS);
    @SetFromFlag(value="childStartMode")
    public static final ConfigKey<ChildStartableMode> CHILDREN_STARTABLE_MODE = ConfigKeys.newConfigKey(ChildStartableMode.class, (String)"children.startable.mode");
    public static final AttributeSensor<MachineProvisioningLocation> PROVISIONING_LOCATION = Sensors.newSensor(MachineProvisioningLocation.class, (String)"softwareservice.provisioningLocation", (String)"Location used to provision a machine where this is running");
    public static final AttributeSensor<Boolean> SERVICE_PROCESS_IS_RUNNING = Sensors.newBooleanSensor((String)"service.process.isRunning", (String)"Whether the process for the service is confirmed as running");
    public static final AttributeSensor<Lifecycle> SERVICE_STATE_ACTUAL = Attributes.SERVICE_STATE_ACTUAL;
    public static final AttributeSensor<Lifecycle.Transition> SERVICE_STATE_EXPECTED = Attributes.SERVICE_STATE_EXPECTED;
    public static final AttributeSensor<String> PID_FILE = Sensors.newStringSensor((String)"softwareprocess.pid.file", (String)"PID file");

    @Beta
    public static class StopSoftwareParameters {
        @Beta
        public static final ConfigKey<StopMode> STOP_PROCESS_MODE = ConfigKeys.newConfigKey(StopMode.class, (String)"stopProcessMode", (String)"When to stop the process with regard to the entity stateALWAYS will try to stop the process even if the entity is marked as stopped, IF_NOT_STOPPED stops the process only if the entity is not marked as stopped, NEVER doesn't stop the process.", (Object)((Object)StopMode.IF_NOT_STOPPED));
        @Beta
        public static final ConfigKey<StopMode> STOP_MACHINE_MODE = ConfigKeys.newConfigKey(StopMode.class, (String)"stopMachineMode", (String)"When to stop the machine with regard to the entity state. ALWAYS will try to stop the machine even if the entity is marked as stopped, IF_NOT_STOPPED stops the machine only if the entity is not marked as stopped, NEVER doesn't stop the machine.", (Object)((Object)StopMode.IF_NOT_STOPPED));
        @Deprecated
        @Beta
        public static final ConfigKey<Boolean> STOP_MACHINE = ConfigKeys.newBooleanConfigKey((String)"stopMachine", (String)("Whether to stop the machine provisioned for this entity:  'true', or 'false' are supported, with the default being 'true'. 'true' is equivalent to " + STOP_MACHINE_MODE.getName() + " = " + StopMode.IF_NOT_STOPPED.name() + "." + " 'false' is equivalent to " + STOP_MACHINE_MODE.getName() + " = " + StopMode.NEVER.name() + "."), (Boolean)true);

        public static enum StopMode {
            ALWAYS,
            IF_NOT_STOPPED,
            NEVER;

        }
    }

    @Beta
    public static class RestartSoftwareParameters {
        @Beta
        public static final ConfigKey<Boolean> RESTART_CHILDREN = ConfigKeys.newConfigKey(Boolean.class, (String)"restartChildren", (String)"Whether to restart children; default false", (Object)false);
        @Beta
        public static final ConfigKey<Object> RESTART_MACHINE = ConfigKeys.newConfigKey(Object.class, (String)"restartMachine", (String)"Whether to restart/replace the machine provisioned for this entity:  'true', 'false', or 'auto' are supported, with the default being 'auto' which means to restart or reprovision the machine if there is no simpler way known to restart the entity (for example, if the machine is unhealthy, it would not be possible to restart the process, not even via a stop-then-start sequence); if the machine was not provisioned for this entity, this parameter has no effect", (Object)RestartMachineMode.AUTO.toString().toLowerCase());
        @Beta
        public static final ConfigKey<RestartMachineMode> RESTART_MACHINE_TYPED = ConfigKeys.newConfigKey(RestartMachineMode.class, (String)"restartMachine");

        public static enum RestartMachineMode {
            TRUE,
            FALSE,
            AUTO;

        }
    }

    public static enum ChildStartableMode {
        NONE(true, false, false),
        FOREGROUND(false, false, false),
        FOREGROUND_LATE(false, false, true),
        BACKGROUND(false, true, false),
        BACKGROUND_LATE(false, true, true);

        public final boolean isDisabled;
        public final boolean isBackground;
        public final boolean isLate;

        private ChildStartableMode(boolean isDisabled, boolean isBackground, boolean isLate) {
            this.isDisabled = isDisabled;
            this.isBackground = isBackground;
            this.isLate = isLate;
        }
    }
}

