/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.basic;

import brooklyn.entity.Entity;
import brooklyn.entity.basic.AbstractEntity;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.SameServerDriverLifecycleEffectorTasks;
import brooklyn.entity.basic.SameServerEntity;
import brooklyn.entity.basic.ServiceStateLogic;
import brooklyn.entity.software.MachineLifecycleEffectorTasks;
import brooklyn.location.Location;
import brooklyn.management.Task;
import brooklyn.management.TaskAdaptable;
import brooklyn.policy.EnricherSpec;
import brooklyn.util.config.ConfigBag;
import brooklyn.util.task.DynamicTasks;
import brooklyn.util.task.Tasks;
import com.google.common.base.Preconditions;
import java.util.Collection;

public class SameServerEntityImpl
extends AbstractEntity
implements SameServerEntity {
    private static final MachineLifecycleEffectorTasks LIFECYCLE_TASKS = new SameServerDriverLifecycleEffectorTasks();

    protected void initEnrichers() {
        super.initEnrichers();
        this.addEnricher((EnricherSpec)ServiceStateLogic.newEnricherFromChildren());
    }

    public final void restart() {
        if (DynamicTasks.getTaskQueuingContext() != null) {
            this.doRestart(ConfigBag.EMPTY);
        } else {
            Task task = Tasks.builder().name("restart").body(new Runnable(){

                @Override
                public void run() {
                    SameServerEntityImpl.this.doRestart(ConfigBag.EMPTY);
                }
            }).build();
            ((Task)Entities.submit((Entity)this, (TaskAdaptable)task)).getUnchecked();
        }
    }

    public final void start(final Collection<? extends Location> locations) {
        Preconditions.checkNotNull(locations, (Object)"locations");
        if (DynamicTasks.getTaskQueuingContext() != null) {
            this.doStart(locations);
        } else {
            Task task = Tasks.builder().name("start").body(new Runnable(){

                @Override
                public void run() {
                    SameServerEntityImpl.this.doStart(locations);
                }
            }).build();
            ((Task)Entities.submit((Entity)this, (TaskAdaptable)task)).getUnchecked();
        }
    }

    public final void stop() {
        if (DynamicTasks.getTaskQueuingContext() != null) {
            this.doStop();
        } else {
            Task task = Tasks.builder().name("stop").body(new Runnable(){

                @Override
                public void run() {
                    SameServerEntityImpl.this.doStop();
                }
            }).build();
            ((Task)Entities.submit((Entity)this, (TaskAdaptable)task)).getUnchecked();
        }
    }

    protected void doStart(Collection<? extends Location> locations) {
        LIFECYCLE_TASKS.start(locations);
    }

    protected void doStop() {
        LIFECYCLE_TASKS.stop();
    }

    protected void doRestart(ConfigBag parameters) {
        LIFECYCLE_TASKS.restart(parameters);
    }

    @Deprecated
    protected final void doRestart() {
        this.doRestart(ConfigBag.EMPTY);
    }
}

