/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.basic;

import brooklyn.config.ConfigKey;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.SameServerEntity;
import brooklyn.entity.basic.SameServerEntityImpl;
import brooklyn.entity.software.MachineLifecycleEffectorTasks;
import brooklyn.entity.trait.StartableMethods;
import brooklyn.location.Location;
import brooklyn.location.MachineLocation;
import brooklyn.location.MachineProvisioningLocation;
import brooklyn.location.PortRange;
import brooklyn.location.basic.LocationConfigKeys;
import brooklyn.management.TaskAdaptable;
import brooklyn.util.collections.MutableSet;
import brooklyn.util.task.DynamicTasks;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SameServerDriverLifecycleEffectorTasks
extends MachineLifecycleEffectorTasks {
    private static final Logger LOG = LoggerFactory.getLogger(SameServerDriverLifecycleEffectorTasks.class);

    protected SameServerEntityImpl entity() {
        return (SameServerEntityImpl)super.entity();
    }

    protected Collection<Integer> getRequiredOpenPorts() {
        LinkedHashSet result = Sets.newLinkedHashSet();
        result.addAll(this.getRequiredOpenPorts(this.entity()));
        LOG.debug("getRequiredOpenPorts detected aggregated default {} for {}", (Object)result, (Object)this);
        return result;
    }

    protected Collection<Integer> getRequiredOpenPorts(Entity entity) {
        MutableSet ports = MutableSet.of((Object)22);
        for (ConfigKey k : entity.getEntityType().getConfigKeys()) {
            PortRange p;
            if (!PortRange.class.isAssignableFrom(k.getType()) || (p = (PortRange)entity.getConfig(k)) == null || p.isEmpty()) continue;
            ports.add(p.iterator().next());
        }
        LOG.debug("getRequiredOpenPorts detected default {} for {}", (Object)ports, (Object)entity);
        for (Entity child : entity.getChildren()) {
            ports.addAll(this.getRequiredOpenPorts(child));
        }
        return ports;
    }

    @Override
    protected Map<String, Object> obtainProvisioningFlags(MachineProvisioningLocation<?> location) {
        Map<String, Object> result = super.obtainProvisioningFlags(location);
        result.putAll(this.obtainProvisioningFlags(this.entity(), location));
        Collection<Integer> ports = this.getRequiredOpenPorts();
        if (result.containsKey("inboundPorts")) {
            ports.addAll((Collection)result.get("inboundPorts"));
        }
        if (!ports.isEmpty()) {
            result.put("inboundPorts", ports);
        }
        result.put(LocationConfigKeys.CALLER_CONTEXT.getName(), this.entity());
        return result;
    }

    protected Map<String, Object> obtainProvisioningFlags(Entity entity, MachineProvisioningLocation location) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        result.putAll(Maps.newLinkedHashMap((Map)location.getProvisioningFlags((Collection)ImmutableList.of((Object)entity.getEntityType().getName()))));
        result.putAll((Map)entity.getConfig(SameServerEntity.PROVISIONING_PROPERTIES));
        for (Entity child : entity.getChildren()) {
            result.putAll(this.obtainProvisioningFlags(child, location));
        }
        return result;
    }

    @Override
    protected String startProcessesAtMachine(Supplier<MachineLocation> machineS) {
        DynamicTasks.queueIfPossible((TaskAdaptable)StartableMethods.startingChildren((Entity)this.entity(), (Location)((Location)machineS.get()))).orSubmitAsync((Entity)this.entity()).getTask().getUnchecked();
        DynamicTasks.waitForLast();
        return "children started";
    }

    @Override
    protected String stopProcessesAtMachine() {
        TaskAdaptable children = StartableMethods.stoppingChildren((Entity)this.entity());
        DynamicTasks.queue((TaskAdaptable)children);
        Exception childException = null;
        try {
            DynamicTasks.waitForLast();
        }
        catch (Exception e) {
            childException = e;
        }
        try {
            children.asTask().get();
        }
        catch (Exception e) {
            childException = e;
            LOG.debug("Error stopping children; continuing and will rethrow if no other errors", (Throwable)e);
        }
        if (childException != null) {
            throw new IllegalStateException("error stopping child", childException);
        }
        return "children stopped";
    }
}

