/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.basic;

import brooklyn.config.ConfigKey;
import brooklyn.entity.basic.AbstractSoftwareProcessDriver;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.basic.VanillaWindowsProcess;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.Sensors;
import brooklyn.location.Location;
import brooklyn.location.basic.WinRmMachineLocation;
import brooklyn.util.exceptions.ReferenceWithError;
import brooklyn.util.repeat.Repeater;
import brooklyn.util.time.Duration;
import com.google.api.client.util.Strings;
import com.google.common.collect.ImmutableList;
import io.cloudsoft.winrm4j.winrm.WinRmToolResponse;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.python.core.PyException;

public abstract class AbstractSoftwareProcessWinRmDriver
extends AbstractSoftwareProcessDriver {
    AttributeSensor<String> WINDOWS_USERNAME = Sensors.newStringSensor((String)"windows.username", (String)"Default Windows username to be used when connecting to the Entity's VM");
    AttributeSensor<String> WINDOWS_PASSWORD = Sensors.newStringSensor((String)"windows.password", (String)"Default Windows password to be used when connecting to the Entity's VM");

    public AbstractSoftwareProcessWinRmDriver(EntityLocal entity, WinRmMachineLocation location) {
        super(entity, (Location)location);
        entity.setAttribute(this.WINDOWS_USERNAME, location.config().get(WinRmMachineLocation.USER));
        entity.setAttribute(this.WINDOWS_PASSWORD, location.config().get(WinRmMachineLocation.PASSWORD));
    }

    @Override
    public void runPreInstallCommand(String command) {
        this.execute((List<String>)ImmutableList.of((Object)command));
    }

    @Override
    public void setup() {
    }

    @Override
    public void runPostInstallCommand(String command) {
        this.execute((List<String>)ImmutableList.of((Object)command));
    }

    @Override
    public void runPreLaunchCommand(String command) {
        this.execute((List<String>)ImmutableList.of((Object)command));
    }

    @Override
    public void runPostLaunchCommand(String command) {
        this.execute((List<String>)ImmutableList.of((Object)command));
    }

    public WinRmMachineLocation getLocation() {
        return (WinRmMachineLocation)super.getLocation();
    }

    @Override
    public String getRunDir() {
        return "$HOME\\brooklyn-managed-processes\\apps\\" + this.entity.getApplicationId() + "\\entities\\" + this.getEntityVersionLabel() + "_" + this.entity.getId();
    }

    @Override
    public String getInstallDir() {
        return "$HOME\\brooklyn-managed-processes\\installs\\" + this.entity.getApplicationId() + "\\" + this.getEntityVersionLabel() + "_" + this.entity.getId();
    }

    @Override
    public int copyResource(Map<Object, Object> sshFlags, String source, String target, boolean createParentDir) {
        if (createParentDir) {
            this.createDirectory(this.getDirectory(target), "Creating resource directory");
        }
        return this.copyTo(new File(source), target);
    }

    @Override
    public int copyResource(Map<Object, Object> sshFlags, InputStream source, String target, boolean createParentDir) {
        if (createParentDir) {
            this.createDirectory(this.getDirectory(target), "Creating resource directory");
        }
        return this.copyTo(source, target);
    }

    @Override
    protected void createDirectory(String directoryName, String summaryForLogging) {
        this.getLocation().executePsScript("New-Item -path \"" + directoryName + "\" -type directory -ErrorAction SilentlyContinue");
    }

    protected WinRmToolResponse executeCommand(ConfigKey<String> regularCommandKey, ConfigKey<String> powershellCommandKey, boolean allowNoOp) {
        String regularCommand = (String)this.getEntity().getConfig(regularCommandKey);
        String powershellCommand = (String)this.getEntity().getConfig(powershellCommandKey);
        if (Strings.isNullOrEmpty((String)regularCommand) && Strings.isNullOrEmpty((String)powershellCommand)) {
            if (allowNoOp) {
                return new WinRmToolResponse("", "", 0);
            }
            throw new IllegalStateException(String.format("Exactly one of %s or %s must be set", regularCommandKey.getName(), powershellCommandKey.getName()));
        }
        if (!Strings.isNullOrEmpty((String)regularCommand) && !Strings.isNullOrEmpty((String)powershellCommand)) {
            throw new IllegalStateException(String.format("%s and %s cannot both be set", regularCommandKey.getName(), powershellCommandKey.getName()));
        }
        if (Strings.isNullOrEmpty((String)regularCommand)) {
            return this.getLocation().executePsScript((List)ImmutableList.of((Object)powershellCommand));
        }
        return this.getLocation().executeScript((List)ImmutableList.of((Object)regularCommand));
    }

    public int execute(List<String> script) {
        return this.getLocation().executeScript(script).getStatusCode();
    }

    public int executePsScriptNoRetry(List<String> psScript) {
        return this.getLocation().executePsScriptNoRetry(psScript).getStatusCode();
    }

    public int executePsScript(List<String> psScript) {
        return this.getLocation().executePsScript(psScript).getStatusCode();
    }

    public int copyTo(File source, String destination) {
        return this.getLocation().copyTo(source, destination);
    }

    public int copyTo(InputStream source, String destination) {
        return this.getLocation().copyTo(source, destination);
    }

    public void rebootAndWait() {
        try {
            this.executePsScriptNoRetry((List<String>)ImmutableList.of((Object)"Restart-Computer -Force"));
        }
        catch (PyException pyException) {
            // empty catch block
        }
        this.waitForWinRmStatus(false, (Duration)this.entity.getConfig(VanillaWindowsProcess.REBOOT_BEGUN_TIMEOUT));
        this.waitForWinRmStatus(true, (Duration)this.entity.getConfig(VanillaWindowsProcess.REBOOT_COMPLETED_TIMEOUT)).getWithError();
    }

    private String getDirectory(String fileName) {
        return fileName.substring(0, fileName.lastIndexOf("\\"));
    }

    private ReferenceWithError<Boolean> waitForWinRmStatus(final boolean requiredStatus, Duration timeout) {
        Callable<Boolean> checker = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                try {
                    return AbstractSoftwareProcessWinRmDriver.this.execute((List<String>)ImmutableList.of((Object)"hostname")) == 0 == requiredStatus;
                }
                catch (Exception e) {
                    return !requiredStatus;
                }
            }
        };
        return new Repeater().every(1L, TimeUnit.SECONDS).until((Callable)checker).limitTimeTo(timeout).runKeepingError();
    }
}

