/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.basic;

import brooklyn.entity.Entity;
import brooklyn.entity.basic.AbstractSoftwareProcessDriver;
import brooklyn.entity.basic.Attributes;
import brooklyn.entity.basic.BrooklynTaskTags;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.EntityInternal;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.basic.SoftwareProcess;
import brooklyn.entity.basic.lifecycle.NaiveScriptRunner;
import brooklyn.entity.basic.lifecycle.ScriptHelper;
import brooklyn.entity.drivers.downloads.DownloadResolver;
import brooklyn.entity.effector.EffectorTasks;
import brooklyn.entity.software.SshEffectorTasks;
import brooklyn.event.feed.ConfigToAttributes;
import brooklyn.location.Location;
import brooklyn.location.basic.SshMachineLocation;
import brooklyn.management.Task;
import brooklyn.management.TaskFactory;
import brooklyn.util.JavaGroovyEquivalents;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.guava.Maybe;
import brooklyn.util.internal.ssh.SshTool;
import brooklyn.util.mutex.WithMutexes;
import brooklyn.util.os.Os;
import brooklyn.util.ssh.BashCommands;
import brooklyn.util.stream.Streams;
import brooklyn.util.task.DynamicTasks;
import brooklyn.util.task.Tasks;
import brooklyn.util.task.system.ProcessTaskWrapper;
import brooklyn.util.text.StringPredicates;
import brooklyn.util.text.Strings;
import brooklyn.util.time.Duration;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSoftwareProcessSshDriver
extends AbstractSoftwareProcessDriver
implements NaiveScriptRunner {
    public static final Logger log = LoggerFactory.getLogger(AbstractSoftwareProcessSshDriver.class);
    public static final Logger logSsh = LoggerFactory.getLogger((String)"brooklyn.SSH");
    private volatile String installDir;
    private volatile String runDir;
    private volatile String expandedInstallDir;
    private final Object installDirSetupMutex = new Object();
    protected volatile DownloadResolver resolver;
    public static final String IGNORE_ENTITY_SSH_FLAGS = SshEffectorTasks.IGNORE_ENTITY_SSH_FLAGS.getName();
    public static final String INSTALLING = "installing";
    public static final String CUSTOMIZING = "customizing";
    public static final String LAUNCHING = "launching";
    public static final String CHECK_RUNNING = "check-running";
    public static final String STOPPING = "stopping";
    public static final String KILLING = "killing";
    public static final String RESTARTING = "restarting";
    public static final String PID_FILENAME = "pid.txt";
    public static final String USE_PID_FILE = "usePidFile";
    public static final String PROCESS_OWNER = "processOwner";
    public static final String NON_STANDARD_LAYOUT = "nonStandardLayout";
    public static final String INSTALL_INCOMPLETE = "installIncomplete";
    public static final String DEBUG = "debug";
    public static final List<String> VALID_FLAGS = ImmutableList.of((Object)"usePidFile", (Object)"processOwner", (Object)"nonStandardLayout", (Object)"installIncomplete", (Object)"debug");

    public AbstractSoftwareProcessSshDriver(EntityLocal entity, SshMachineLocation machine) {
        super(entity, (Location)machine);
        if (this.getSshFlags() != null && !this.getSshFlags().isEmpty()) {
            machine.configure(this.getSshFlags());
        }
        this.getInstallDir();
        this.getRunDir();
    }

    public SshMachineLocation getLocation() {
        return (SshMachineLocation)super.getLocation();
    }

    protected void setInstallDir(String installDir) {
        this.installDir = installDir;
        this.entity.setAttribute(SoftwareProcess.INSTALL_DIR, (Object)installDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getInstallDir() {
        if (this.installDir != null) {
            return this.installDir;
        }
        String existingVal = (String)this.getEntity().getAttribute(SoftwareProcess.INSTALL_DIR);
        if (Strings.isNonBlank((CharSequence)existingVal)) {
            this.installDir = existingVal;
            return this.installDir;
        }
        Object object = this.installDirSetupMutex;
        synchronized (object) {
            String installBasedir;
            this.setInstallLabel();
            Maybe minstallDir = this.getEntity().getConfigRaw(SoftwareProcess.INSTALL_DIR, false);
            if (!(minstallDir.isPresent() && minstallDir.get() != null || (installBasedir = ((EntityInternal)this.entity).getManagementContext().getConfig().getFirst(new String[]{"brooklyn.dirs.install"})) == null)) {
                log.warn("Using legacy 'brooklyn.dirs.install' setting for " + this.entity + "; may be removed in future versions.");
                this.setInstallDir(Os.tidyPath((String)Os.mergePathsUnix((String[])new String[]{installBasedir, this.getEntityVersionLabel() + "_" + this.entity.getId()})));
                return this.installDir;
            }
            this.setInstallDir(null);
            this.setInstallDir(Os.tidyPath((String)((String)ConfigToAttributes.apply((EntityLocal)this.getEntity(), SoftwareProcess.INSTALL_DIR))));
            return this.installDir;
        }
    }

    protected void setInstallLabel() {
        if (this.getEntity().getConfigRaw(SoftwareProcess.INSTALL_UNIQUE_LABEL, false).isPresentAndNonNull()) {
            return;
        }
        this.getEntity().setConfig(SoftwareProcess.INSTALL_UNIQUE_LABEL, (Object)(this.getEntity().getEntityType().getSimpleName() + (Strings.isNonBlank((CharSequence)this.getVersion()) ? "_" + this.getVersion() : "") + (Strings.isNonBlank((CharSequence)this.getInstallLabelExtraSalt()) ? "_" + this.getInstallLabelExtraSalt() : "")));
    }

    protected String getInstallLabelExtraSalt() {
        return null;
    }

    protected void setRunDir(String runDir) {
        this.runDir = runDir;
        this.entity.setAttribute(SoftwareProcess.RUN_DIR, (Object)runDir);
    }

    @Override
    public String getRunDir() {
        String runBasedir;
        if (this.runDir != null) {
            return this.runDir;
        }
        String existingVal = (String)this.getEntity().getAttribute(SoftwareProcess.RUN_DIR);
        if (Strings.isNonBlank((CharSequence)existingVal)) {
            this.runDir = existingVal;
            return this.runDir;
        }
        Maybe mRunDir = this.getEntity().getConfigRaw(SoftwareProcess.RUN_DIR, true);
        if (!(mRunDir.isPresent() && mRunDir.get() != null || (runBasedir = ((EntityInternal)this.entity).getManagementContext().getConfig().getFirst(new String[]{"brooklyn.dirs.run"})) == null)) {
            log.warn("Using legacy 'brooklyn.dirs.run' setting for " + this.entity + "; may be removed in future versions.");
            this.runDir = Os.mergePathsUnix((String[])new String[]{runBasedir, this.entity.getApplication().getId() + "/" + "entities" + "/" + this.getEntityVersionLabel() + "_" + this.entity.getId()});
            this.runDir = Os.tidyPath((String)this.runDir);
            this.getEntity().setAttribute(SoftwareProcess.RUN_DIR, (Object)this.runDir);
            return this.runDir;
        }
        this.setRunDir(Os.tidyPath((String)((String)ConfigToAttributes.apply((EntityLocal)this.getEntity(), SoftwareProcess.RUN_DIR))));
        return this.runDir;
    }

    public void setExpandedInstallDir(String val) {
        String oldVal = (String)this.getEntity().getAttribute(SoftwareProcess.EXPANDED_INSTALL_DIR);
        if (Strings.isNonBlank((CharSequence)oldVal) && !oldVal.equals(val)) {
            log.info("Resetting expandedInstallDir (to " + val + " from " + oldVal + ") for " + this.getEntity());
        }
        this.expandedInstallDir = val;
        this.getEntity().setAttribute(SoftwareProcess.EXPANDED_INSTALL_DIR, (Object)val);
    }

    public String getExpandedInstallDir() {
        if (this.expandedInstallDir != null) {
            return this.expandedInstallDir;
        }
        String existingVal = (String)this.getEntity().getAttribute(SoftwareProcess.EXPANDED_INSTALL_DIR);
        if (Strings.isNonBlank((CharSequence)existingVal)) {
            this.expandedInstallDir = existingVal;
            return this.expandedInstallDir;
        }
        String untidiedVal = (String)ConfigToAttributes.apply((EntityLocal)this.getEntity(), SoftwareProcess.EXPANDED_INSTALL_DIR);
        if (Strings.isNonBlank((CharSequence)untidiedVal)) {
            this.setExpandedInstallDir(Os.tidyPath((String)untidiedVal));
            return this.expandedInstallDir;
        }
        throw new IllegalStateException("expandedInstallDir is null; most likely install was not called for " + this.getEntity());
    }

    public SshMachineLocation getMachine() {
        return this.getLocation();
    }

    public String getHostname() {
        return (String)this.entity.getAttribute(Attributes.HOSTNAME);
    }

    public String getAddress() {
        return (String)this.entity.getAttribute(Attributes.ADDRESS);
    }

    public String getSubnetHostname() {
        return (String)this.entity.getAttribute(Attributes.SUBNET_HOSTNAME);
    }

    public String getSubnetAddress() {
        return (String)this.entity.getAttribute(Attributes.SUBNET_ADDRESS);
    }

    protected Map<String, Object> getSshFlags() {
        return SshEffectorTasks.getSshFlags((Entity)this.getEntity(), (Location)this.getMachine());
    }

    public int execute(String command, String summaryForLogging) {
        return this.execute((List<String>)ImmutableList.of((Object)command), summaryForLogging);
    }

    @Override
    public int execute(List<String> script, String summaryForLogging) {
        return this.execute(Maps.newLinkedHashMap(), script, summaryForLogging);
    }

    @Override
    public int execute(Map flags2, List<String> script, String summaryForLogging) {
        LinkedHashMap flags = Maps.newLinkedHashMap();
        if (!flags2.containsKey(IGNORE_ENTITY_SSH_FLAGS)) {
            flags.putAll(this.getSshFlags());
        }
        flags.putAll(flags2);
        Map<String, String> environment = (Map<String, String>)flags.get("env");
        if (environment == null) {
            environment = this.getShellEnvironment();
        }
        if (Tasks.current() != null) {
            if (environment != null) {
                Tasks.addTagDynamically((Object)BrooklynTaskTags.tagForEnvStream((String)"env", environment));
            }
            if (BrooklynTaskTags.stream((Task)Tasks.current(), (String)"stdin") == null) {
                Tasks.addTagDynamically((Object)BrooklynTaskTags.tagForStreamSoft((String)"stdin", (ByteArrayOutputStream)Streams.byteArrayOfString((String)Strings.join(script, (String)"\n"))));
            }
            if (BrooklynTaskTags.stream((Task)Tasks.current(), (String)"stdout") == null) {
                ByteArrayOutputStream stdout = new ByteArrayOutputStream();
                Tasks.addTagDynamically((Object)BrooklynTaskTags.tagForStreamSoft((String)"stdout", (ByteArrayOutputStream)stdout));
                ByteArrayOutputStream stderr = new ByteArrayOutputStream();
                Tasks.addTagDynamically((Object)BrooklynTaskTags.tagForStreamSoft((String)"stderr", (ByteArrayOutputStream)stderr));
                flags.put("out", stdout);
                flags.put("err", stderr);
            }
        }
        if (!flags.containsKey("logPrefix")) {
            flags.put("logPrefix", "" + this.entity.getId() + "@" + this.getLocation().getDisplayName());
        }
        return this.getMachine().execScript((Map)flags, summaryForLogging, script, environment);
    }

    @Override
    public void copyInstallResources() {
        this.getLocation().acquireMutex("installing " + JavaGroovyEquivalents.elvis((Object)this.entity, (Object)this), "installation lock at host for files and templates");
        try {
            super.copyInstallResources();
        }
        catch (Exception e) {
            log.warn("Error copying install resources", (Throwable)e);
            throw Exceptions.propagate((Throwable)e);
        }
        finally {
            this.getLocation().releaseMutex("installing " + JavaGroovyEquivalents.elvis((Object)this.entity, (Object)this));
        }
    }

    @Override
    public void runPreInstallCommand(String command) {
        this.execute((List<String>)ImmutableList.of((Object)command), "running pre-install commands");
    }

    @Override
    public void runPostInstallCommand(String command) {
        this.execute((List<String>)ImmutableList.of((Object)command), "running post-install commands");
    }

    @Override
    public void runPreLaunchCommand(String command) {
        this.execute((List<String>)ImmutableList.of((Object)command), "running pre-launch commands");
    }

    @Override
    public void runPostLaunchCommand(String command) {
        this.execute((List<String>)ImmutableList.of((Object)command), "running post-launch commands");
    }

    public Map<String, String> getShellEnvironment() {
        return Strings.toStringMap((Map)((Map)this.entity.getConfig(SoftwareProcess.SHELL_ENVIRONMENT)));
    }

    @Override
    public int copyResource(Map<Object, Object> sshFlags, String source, String target, boolean createParentDir) {
        int result;
        String destination;
        LinkedHashMap flags = Maps.newLinkedHashMap();
        if (!sshFlags.containsKey(IGNORE_ENTITY_SSH_FLAGS)) {
            flags.putAll(this.getSshFlags());
        }
        flags.putAll(sshFlags);
        String string = destination = Os.isAbsolutish((String)target) ? target : Os.mergePathsUnix((String[])new String[]{this.getRunDir(), target});
        if (createParentDir) {
            String parent;
            int lastSlashIndex = destination.lastIndexOf("/");
            String string2 = parent = lastSlashIndex > 0 ? destination.substring(0, lastSlashIndex) : null;
            if (parent != null) {
                this.getMachine().execCommands("createParentDir", (List)ImmutableList.of((Object)("mkdir -p " + parent)));
            }
        }
        if ((result = this.getMachine().installTo(this.resource, (Map)flags, source, destination)) == 0 && log.isDebugEnabled()) {
            log.debug("Copied file for {}: {} to {} - result {}", new Object[]{this.entity, source, destination, result});
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int copyResource(Map<Object, Object> sshFlags, InputStream source, String target, boolean createParentDir) {
        int result;
        String destination;
        LinkedHashMap flags = Maps.newLinkedHashMap();
        if (!sshFlags.containsKey(IGNORE_ENTITY_SSH_FLAGS)) {
            flags.putAll(this.getSshFlags());
        }
        flags.putAll(sshFlags);
        String string = destination = Os.isAbsolutish((String)target) ? target : Os.mergePathsUnix((String[])new String[]{this.getRunDir(), target});
        if (createParentDir) {
            String parent;
            int lastSlashIndex = destination.lastIndexOf("/");
            String string2 = parent = lastSlashIndex > 0 ? destination.substring(0, lastSlashIndex) : null;
            if (parent != null) {
                this.getMachine().execCommands("createParentDir", (List)ImmutableList.of((Object)("mkdir -p " + parent)));
            }
        }
        String prevBlockingDetails = Tasks.setBlockingDetails((String)("copying resource to server at " + destination));
        try {
            result = this.getMachine().copyTo((Map)flags, source, destination);
        }
        finally {
            Tasks.setBlockingDetails((String)prevBlockingDetails);
        }
        if (result == 0) {
            log.debug("copying stream complete; {} on {}", new Object[]{destination, this.getMachine()});
        } else {
            log.warn("copying stream failed; {} on {}: {}", new Object[]{destination, this.getMachine(), result});
        }
        return result;
    }

    public void checkNoHostnameBug() {
        try {
            ProcessTaskWrapper hostnameTask = ((ProcessTaskWrapper)DynamicTasks.queue(SshEffectorTasks.ssh("echo FOREMARKER; hostname; echo AFTMARKER"))).block();
            String stdout = Strings.getFragmentBetween((String)hostnameTask.getStdout(), (String)"FOREMARKER", (String)"AFTMARKER");
            if (hostnameTask.getExitCode() == 0 && Strings.isNonBlank((CharSequence)stdout)) {
                String hostname = stdout.trim();
                if (hostname.equals("(none)")) {
                    String newHostname = "br-" + this.getEntity().getId().toLowerCase();
                    log.info("Detected no-hostname bug with hostname " + hostname + " for " + this.getEntity() + "; renaming " + this.getMachine() + "  to hostname " + newHostname);
                    ((ProcessTaskWrapper)DynamicTasks.queue(SshEffectorTasks.ssh(BashCommands.setHostname((String)newHostname, null)))).block();
                }
            } else {
                log.debug("Hostname could not be determined for location " + EffectorTasks.findSshMachine() + "; not doing no-hostname bug check");
            }
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            log.warn("Error checking/fixing no-hostname bug (continuing): " + e, (Throwable)e);
        }
    }

    protected ScriptHelper newScript(String phase) {
        return this.newScript(Maps.newLinkedHashMap(), phase);
    }

    protected ScriptHelper newScript(Map<String, ?> flags, String phase) {
        if (!Entities.isManaged((Entity)this.getEntity())) {
            throw new IllegalStateException(this.getEntity() + " is no longer managed; cannot create script to run here (" + phase + ")");
        }
        if (!Iterables.all(flags.keySet(), (Predicate)StringPredicates.equalToAny(VALID_FLAGS))) {
            throw new IllegalArgumentException("Invalid flags passed: " + flags);
        }
        ScriptHelper s = new ScriptHelper(this, phase + " " + JavaGroovyEquivalents.elvis((Object)this.entity, (Object)this));
        if (!JavaGroovyEquivalents.groovyTruth(flags.get(NON_STANDARD_LAYOUT))) {
            if (JavaGroovyEquivalents.groovyTruth(flags.get(DEBUG))) {
                s.header.prepend((CharSequence)"set -x");
            }
            if (INSTALLING.equals(phase)) {
                s.useMutex((WithMutexes)this.getLocation(), "installation lock at host", "installing " + JavaGroovyEquivalents.elvis((Object)this.entity, (Object)this));
                s.header.append("export INSTALL_DIR=\"" + this.getInstallDir() + "\"", "mkdir -p $INSTALL_DIR", "cd $INSTALL_DIR", "test -f BROOKLYN && exit 0");
                if (!JavaGroovyEquivalents.groovyTruth(flags.get(INSTALL_INCOMPLETE))) {
                    s.footer.append((CharSequence)"date > $INSTALL_DIR/BROOKLYN");
                }
                s.environmentVariablesReset();
            }
            if (ImmutableSet.of((Object)CUSTOMIZING, (Object)LAUNCHING, (Object)CHECK_RUNNING, (Object)STOPPING, (Object)KILLING, (Object)RESTARTING, (Object[])new String[0]).contains((Object)phase)) {
                s.header.append("export RUN_DIR=\"" + this.getRunDir() + "\"", "mkdir -p $RUN_DIR", "cd $RUN_DIR");
            }
        }
        if (ImmutableSet.of((Object)LAUNCHING, (Object)RESTARTING).contains((Object)phase)) {
            s.failIfBodyEmpty();
        }
        if (ImmutableSet.of((Object)STOPPING, (Object)KILLING).contains((Object)phase) && !JavaGroovyEquivalents.groovyTruth(flags.get(USE_PID_FILE))) {
            s.failIfBodyEmpty();
        }
        if (ImmutableSet.of((Object)INSTALLING, (Object)LAUNCHING).contains((Object)phase)) {
            s.updateTaskAndFailOnNonZeroResultCode();
        }
        if (phase.equalsIgnoreCase(CHECK_RUNNING)) {
            s.setInessential();
            s.setTransient();
            s.setFlag(SshTool.PROP_CONNECT_TIMEOUT, Duration.TEN_SECONDS.toMilliseconds());
            s.setFlag(SshTool.PROP_SESSION_TIMEOUT, Duration.THIRTY_SECONDS.toMilliseconds());
            s.setFlag(SshTool.PROP_SSH_TRIES, 1);
        }
        if (JavaGroovyEquivalents.groovyTruth(flags.get(USE_PID_FILE))) {
            Object usePidFile = flags.get(USE_PID_FILE);
            String pidFile = (usePidFile instanceof CharSequence ? usePidFile : Os.mergePathsUnix((String[])new String[]{this.getRunDir(), PID_FILENAME})).toString();
            String processOwner = (String)flags.get(PROCESS_OWNER);
            if (LAUNCHING.equals(phase)) {
                this.entity.setAttribute(SoftwareProcess.PID_FILE, (Object)pidFile);
                s.footer.prepend((CharSequence)("echo $! > " + pidFile));
            } else if (CHECK_RUNNING.equals(phase)) {
                if (processOwner != null) {
                    s.body.append(BashCommands.sudoAsUser((String)processOwner, (String)("test -f " + pidFile)) + " || exit 1", "ps -p $(" + BashCommands.sudoAsUser((String)processOwner, (String)("cat " + pidFile)) + ")");
                } else {
                    s.body.append("test -f " + pidFile + " || exit 1", "ps -p `cat " + pidFile + "`");
                }
                s.requireResultCode((Predicate<? super Integer>)Predicates.or((Predicate)Predicates.equalTo((Object)0), (Predicate)Predicates.equalTo((Object)1)));
            } else if (STOPPING.equals(phase)) {
                if (processOwner != null) {
                    s.body.append("export PID=$(" + BashCommands.sudoAsUser((String)processOwner, (String)("cat " + pidFile)) + ")", "test -n \"$PID\" || exit 0", BashCommands.sudoAsUser((String)processOwner, (String)"kill $PID"), BashCommands.sudoAsUser((String)processOwner, (String)"kill -9 $PID"), BashCommands.sudoAsUser((String)processOwner, (String)("rm -f " + pidFile)));
                } else {
                    s.body.append("export PID=$(cat " + pidFile + ")", "test -n \"$PID\" || exit 0", "kill $PID", "kill -9 $PID", "rm -f " + pidFile);
                }
            } else if (KILLING.equals(phase)) {
                if (processOwner != null) {
                    s.body.append("export PID=$(" + BashCommands.sudoAsUser((String)processOwner, (String)("cat " + pidFile)) + ")", "test -n \"$PID\" || exit 0", BashCommands.sudoAsUser((String)processOwner, (String)"kill -9 $PID"), BashCommands.sudoAsUser((String)processOwner, (String)("rm -f " + pidFile)));
                } else {
                    s.body.append("export PID=$(cat " + pidFile + ")", "test -n \"$PID\" || exit 0", "kill -9 $PID", "rm -f " + pidFile);
                }
            } else if (RESTARTING.equals(phase)) {
                if (processOwner != null) {
                    s.footer.prepend(BashCommands.sudoAsUser((String)processOwner, (String)("test -f " + pidFile)) + " || exit 1", "ps -p $(" + BashCommands.sudoAsUser((String)processOwner, (String)("cat " + pidFile)) + ") || exit 1");
                } else {
                    s.footer.prepend("test -f " + pidFile + " || exit 1", "ps -p $(cat " + pidFile + ") || exit 1");
                }
            } else {
                log.warn("usePidFile: script option not valid for " + s.summary);
            }
        }
        return s;
    }

    @Override
    protected void createDirectory(String directoryName, String summaryForLogging) {
        ((ProcessTaskWrapper)DynamicTasks.queue((TaskFactory)((SshEffectorTasks.SshEffectorTaskFactory)SshEffectorTasks.ssh("mkdir -p " + directoryName).summary(summaryForLogging)).requiringExitCodeZero())).get();
    }

    public Set<Integer> getPortsUsed() {
        LinkedHashSet result = Sets.newLinkedHashSet();
        result.add(22);
        return result;
    }

    @Override
    public void setup() {
    }
}

