/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.basic;

import brooklyn.config.ConfigKey;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.BrooklynConfigKeys;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.basic.Lifecycle;
import brooklyn.entity.basic.ServiceStateLogic;
import brooklyn.entity.basic.SoftwareProcess;
import brooklyn.entity.basic.SoftwareProcessDriver;
import brooklyn.entity.drivers.EntityDriver;
import brooklyn.location.Location;
import brooklyn.management.TaskAdaptable;
import brooklyn.util.JavaGroovyEquivalents;
import brooklyn.util.ResourceUtils;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.os.Os;
import brooklyn.util.stream.ReaderInputStream;
import brooklyn.util.task.DynamicTasks;
import brooklyn.util.task.Tasks;
import brooklyn.util.text.Strings;
import brooklyn.util.text.TemplateProcessor;
import com.google.common.annotations.Beta;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSoftwareProcessDriver
implements SoftwareProcessDriver {
    private static final Logger log = LoggerFactory.getLogger(AbstractSoftwareProcessDriver.class);
    protected final EntityLocal entity;
    protected final ResourceUtils resource;
    protected final Location location;

    public AbstractSoftwareProcessDriver(EntityLocal entity, Location location) {
        this.entity = (EntityLocal)Preconditions.checkNotNull((Object)entity, (Object)"entity");
        this.location = (Location)Preconditions.checkNotNull((Object)location, (Object)"location");
        this.resource = ResourceUtils.create((Object)entity);
    }

    @Override
    public void rebind() {
    }

    @Override
    public void start() {
        boolean skipStart = false;
        Optional locationRunning = Optional.fromNullable((Object)this.getLocation().getConfig(BrooklynConfigKeys.SKIP_ENTITY_START_IF_RUNNING));
        Optional entityRunning = Optional.fromNullable((Object)this.entity.getConfig(BrooklynConfigKeys.SKIP_ENTITY_START_IF_RUNNING));
        Optional entityStarted = Optional.fromNullable((Object)this.entity.getConfig(BrooklynConfigKeys.SKIP_ENTITY_START));
        skipStart = (Boolean)locationRunning.or(entityRunning).or((Object)false) != false ? this.isRunning() : ((Boolean)entityStarted.or((Object)false)).booleanValue();
        if (!skipStart) {
            Optional entityInstalled;
            Optional locationInstalled;
            boolean skipInstall;
            DynamicTasks.queue((String)"copy-pre-install-resources", (Runnable)new Runnable(){

                @Override
                public void run() {
                    AbstractSoftwareProcessDriver.this.waitForConfigKey(BrooklynConfigKeys.PRE_INSTALL_RESOURCES_LATCH);
                    AbstractSoftwareProcessDriver.this.copyPreInstallResources();
                }
            });
            DynamicTasks.queue((String)"pre-install", (Runnable)new Runnable(){

                @Override
                public void run() {
                    AbstractSoftwareProcessDriver.this.preInstall();
                }
            });
            if (Strings.isNonBlank((CharSequence)((CharSequence)this.entity.getConfig(BrooklynConfigKeys.PRE_INSTALL_COMMAND)))) {
                DynamicTasks.queue((String)"pre-install-command", (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        AbstractSoftwareProcessDriver.this.runPreInstallCommand((String)AbstractSoftwareProcessDriver.this.entity.getConfig(BrooklynConfigKeys.PRE_INSTALL_COMMAND));
                    }
                });
            }
            if (!(skipInstall = ((Boolean)(locationInstalled = Optional.fromNullable((Object)this.getLocation().getConfig(BrooklynConfigKeys.SKIP_ENTITY_INSTALLATION))).or(entityInstalled = Optional.fromNullable((Object)this.entity.getConfig(BrooklynConfigKeys.SKIP_ENTITY_INSTALLATION))).or((Object)false)).booleanValue())) {
                DynamicTasks.queue((String)"setup", (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        AbstractSoftwareProcessDriver.this.waitForConfigKey(BrooklynConfigKeys.SETUP_LATCH);
                        AbstractSoftwareProcessDriver.this.setup();
                    }
                });
                DynamicTasks.queue((String)"copy-install-resources", (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        AbstractSoftwareProcessDriver.this.waitForConfigKey(BrooklynConfigKeys.INSTALL_RESOURCES_LATCH);
                        AbstractSoftwareProcessDriver.this.copyInstallResources();
                    }
                });
                DynamicTasks.queue((String)"install", (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        AbstractSoftwareProcessDriver.this.waitForConfigKey(BrooklynConfigKeys.INSTALL_LATCH);
                        AbstractSoftwareProcessDriver.this.install();
                    }
                });
            }
            if (Strings.isNonBlank((CharSequence)((CharSequence)this.entity.getConfig(BrooklynConfigKeys.POST_INSTALL_COMMAND)))) {
                DynamicTasks.queue((String)"post-install-command", (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        AbstractSoftwareProcessDriver.this.runPostInstallCommand((String)AbstractSoftwareProcessDriver.this.entity.getConfig(BrooklynConfigKeys.POST_INSTALL_COMMAND));
                    }
                });
            }
            DynamicTasks.queue((String)"customize", (Runnable)new Runnable(){

                @Override
                public void run() {
                    AbstractSoftwareProcessDriver.this.waitForConfigKey(BrooklynConfigKeys.CUSTOMIZE_LATCH);
                    AbstractSoftwareProcessDriver.this.customize();
                }
            });
            DynamicTasks.queue((String)"copy-runtime-resources", (Runnable)new Runnable(){

                @Override
                public void run() {
                    AbstractSoftwareProcessDriver.this.waitForConfigKey(BrooklynConfigKeys.RUNTIME_RESOURCES_LATCH);
                    AbstractSoftwareProcessDriver.this.copyRuntimeResources();
                }
            });
            if (Strings.isNonBlank((CharSequence)((CharSequence)this.entity.getConfig(BrooklynConfigKeys.PRE_LAUNCH_COMMAND)))) {
                DynamicTasks.queue((String)"pre-launch-command", (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        AbstractSoftwareProcessDriver.this.runPreLaunchCommand((String)AbstractSoftwareProcessDriver.this.entity.getConfig(BrooklynConfigKeys.PRE_LAUNCH_COMMAND));
                    }
                });
            }
            DynamicTasks.queue((String)"launch", (Runnable)new Runnable(){

                @Override
                public void run() {
                    AbstractSoftwareProcessDriver.this.waitForConfigKey(BrooklynConfigKeys.LAUNCH_LATCH);
                    AbstractSoftwareProcessDriver.this.launch();
                }
            });
            if (Strings.isNonBlank((CharSequence)((CharSequence)this.entity.getConfig(BrooklynConfigKeys.POST_LAUNCH_COMMAND)))) {
                DynamicTasks.queue((String)"post-launch-command", (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        AbstractSoftwareProcessDriver.this.runPostLaunchCommand((String)AbstractSoftwareProcessDriver.this.entity.getConfig(BrooklynConfigKeys.POST_LAUNCH_COMMAND));
                    }
                });
            }
        }
        DynamicTasks.queue((String)"post-launch", (Runnable)new Runnable(){

            @Override
            public void run() {
                AbstractSoftwareProcessDriver.this.postLaunch();
            }
        });
    }

    @Override
    public abstract void stop();

    public void preInstall() {
    }

    public abstract void runPreInstallCommand(String var1);

    public abstract void setup();

    public abstract void install();

    public abstract void runPostInstallCommand(String var1);

    public abstract void customize();

    public abstract void runPreLaunchCommand(String var1);

    public abstract void launch();

    public abstract void runPostLaunchCommand(String var1);

    @Override
    public void kill() {
        this.stop();
    }

    public void postLaunch() {
    }

    @Override
    public void restart() {
        DynamicTasks.queue((String)"stop (best effort)", (Runnable)new Runnable(){

            @Override
            public void run() {
                DynamicTasks.markInessential();
                boolean previouslyRunning = AbstractSoftwareProcessDriver.this.isRunning();
                try {
                    ServiceStateLogic.setExpectedState((Entity)AbstractSoftwareProcessDriver.this.getEntity(), (Lifecycle)Lifecycle.STOPPING);
                    AbstractSoftwareProcessDriver.this.stop();
                }
                catch (Exception e) {
                    if (previouslyRunning) {
                        log.warn(AbstractSoftwareProcessDriver.this.getEntity() + " restart: stop failed, when was previously running (ignoring)", (Throwable)e);
                        DynamicTasks.queue((TaskAdaptable)Tasks.fail((String)"Primary job failure (when previously running)", (Throwable)e));
                    }
                    log.debug(AbstractSoftwareProcessDriver.this.getEntity() + " restart: stop failed (but was not previously running, so not a surprise)", (Throwable)e);
                    DynamicTasks.queue((TaskAdaptable)Tasks.fail((String)"Primary job failure (when not previously running)", (Throwable)e));
                }
            }
        });
        if (this.doFullStartOnRestart()) {
            DynamicTasks.waitForLast();
            ServiceStateLogic.setExpectedState((Entity)this.getEntity(), (Lifecycle)Lifecycle.STARTING);
            this.start();
        } else {
            DynamicTasks.queue((String)"launch", (Runnable)new Runnable(){

                @Override
                public void run() {
                    ServiceStateLogic.setExpectedState((Entity)AbstractSoftwareProcessDriver.this.getEntity(), (Lifecycle)Lifecycle.STARTING);
                    AbstractSoftwareProcessDriver.this.launch();
                }
            });
            DynamicTasks.queue((String)"post-launch", (Runnable)new Runnable(){

                @Override
                public void run() {
                    AbstractSoftwareProcessDriver.this.postLaunch();
                }
            });
        }
    }

    @Beta
    protected boolean doFullStartOnRestart() {
        return false;
    }

    @Override
    public EntityLocal getEntity() {
        return this.entity;
    }

    public Location getLocation() {
        return this.location;
    }

    public InputStream getResource(String url) {
        return this.resource.getResourceFromUrl(url);
    }

    public void copyPreInstallResources() {
        this.copyResources((Map)this.entity.getConfig(SoftwareProcess.PRE_INSTALL_FILES), (Map)this.entity.getConfig(SoftwareProcess.PRE_INSTALL_TEMPLATES));
    }

    public void copyInstallResources() {
        this.copyResources((Map)this.entity.getConfig(SoftwareProcess.INSTALL_FILES), (Map)this.entity.getConfig(SoftwareProcess.INSTALL_TEMPLATES));
    }

    private void copyResources(Map<String, String> files, Map<String, String> templates) {
        boolean hasAnythingToCopy;
        boolean bl = hasAnythingToCopy = files != null && files.size() > 0 || templates != null && templates.size() > 0;
        if (hasAnythingToCopy) {
            String destination;
            String target;
            this.createDirectory(this.getInstallDir(), "create install directory");
            if (files != null && files.size() > 0) {
                for (String source : files.keySet()) {
                    target = files.get(source);
                    destination = Os.isAbsolutish((String)target) ? target : Os.mergePathsUnix((String[])new String[]{this.getInstallDir(), target});
                    this.copyResource(source, destination, true);
                }
            }
            if (templates != null && templates.size() > 0) {
                for (String source : templates.keySet()) {
                    target = templates.get(source);
                    destination = Os.isAbsolutish((String)target) ? target : Os.mergePathsUnix((String[])new String[]{this.getInstallDir(), target});
                    this.copyTemplate(source, destination, true, (Map<String, ?>)MutableMap.of());
                }
            }
        }
    }

    protected abstract void createDirectory(String var1, String var2);

    public void copyRuntimeResources() {
        try {
            Map runtimeTemplates;
            this.createDirectory(this.getRunDir(), "create run directory");
            Map runtimeFiles = (Map)this.entity.getConfig(SoftwareProcess.RUNTIME_FILES);
            if (runtimeFiles != null && runtimeFiles.size() > 0) {
                for (String source : runtimeFiles.keySet()) {
                    String target = (String)runtimeFiles.get(source);
                    String destination = Os.isAbsolutish((String)target) ? target : Os.mergePathsUnix((String[])new String[]{this.getRunDir(), target});
                    this.copyResource(source, destination, true);
                }
            }
            if ((runtimeTemplates = (Map)this.entity.getConfig(SoftwareProcess.RUNTIME_TEMPLATES)) != null && runtimeTemplates.size() > 0) {
                for (String source : runtimeTemplates.keySet()) {
                    String target = (String)runtimeTemplates.get(source);
                    String destination = Os.isAbsolutish((String)target) ? target : Os.mergePathsUnix((String[])new String[]{this.getRunDir(), target});
                    this.copyTemplate(source, destination, true, (Map<String, ?>)MutableMap.of());
                }
            }
        }
        catch (Exception e) {
            log.warn("Error copying runtime resources", (Throwable)e);
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public int copyTemplate(File template, String target) {
        return this.copyTemplate(template.toURI().toASCIIString(), target);
    }

    public int copyTemplate(String template, String target) {
        return this.copyTemplate(template, target, false, (Map<String, ?>)ImmutableMap.of());
    }

    public int copyTemplate(String template, String target, boolean createParent, Map<String, ?> extraSubstitutions) {
        String data = this.processTemplate(template, extraSubstitutions);
        return this.copyResource((Map<Object, Object>)MutableMap.of(), new StringReader(data), target, createParent);
    }

    public abstract int copyResource(Map<Object, Object> var1, String var2, String var3, boolean var4);

    public abstract int copyResource(Map<Object, Object> var1, InputStream var2, String var3, boolean var4);

    public int copyResource(File file, String target) {
        return this.copyResource(file.toURI().toASCIIString(), target);
    }

    public int copyResource(String resource, String target) {
        return this.copyResource((Map)MutableMap.of(), resource, target);
    }

    public int copyResource(String resource, String target, boolean createParentDir) {
        return this.copyResource((Map<Object, Object>)MutableMap.of(), resource, target, createParentDir);
    }

    public int copyResource(Map sshFlags, String source, String target) {
        return this.copyResource((Map<Object, Object>)sshFlags, source, target, false);
    }

    public int copyResource(Reader source, String target) {
        return this.copyResource((Map<Object, Object>)MutableMap.of(), source, target, false);
    }

    public int copyResource(Map<Object, Object> sshFlags, Reader source, String target, boolean createParent) {
        return this.copyResource(sshFlags, (InputStream)new ReaderInputStream(source), target, createParent);
    }

    public int copyResource(InputStream source, String target) {
        return this.copyResource((Map<Object, Object>)MutableMap.of(), source, target, false);
    }

    public String getResourceAsString(String url) {
        return this.resource.getResourceAsString(url);
    }

    public String processTemplate(File templateConfigFile, Map<String, Object> extraSubstitutions) {
        return this.processTemplate(templateConfigFile.toURI().toASCIIString(), extraSubstitutions);
    }

    public String processTemplate(File templateConfigFile) {
        return this.processTemplate(templateConfigFile.toURI().toASCIIString());
    }

    public String processTemplate(String templateConfigUrl) {
        return this.processTemplate(templateConfigUrl, (Map<String, ? extends Object>)ImmutableMap.of());
    }

    public String processTemplate(String templateConfigUrl, Map<String, ? extends Object> extraSubstitutions) {
        return this.processTemplateContents(this.getResourceAsString(templateConfigUrl), extraSubstitutions);
    }

    public String processTemplateContents(String templateContents) {
        return this.processTemplateContents(templateContents, (Map<String, ? extends Object>)ImmutableMap.of());
    }

    public String processTemplateContents(String templateContents, Map<String, ? extends Object> extraSubstitutions) {
        return TemplateProcessor.processTemplateContents((String)templateContents, (EntityDriver)this, extraSubstitutions);
    }

    protected void waitForConfigKey(ConfigKey<?> configKey) {
        Object val = this.entity.getConfig(configKey);
        if (val != null) {
            log.debug("{} finished waiting for {} (value {}); continuing...", new Object[]{this, configKey, val});
        }
    }

    protected String getEntityVersionLabel() {
        return this.getEntityVersionLabel("_");
    }

    protected String getEntityVersionLabel(String separator) {
        return JavaGroovyEquivalents.elvis((String)this.entity.getEntityType().getSimpleName(), (String)this.entity.getClass().getName()) + (this.getVersion() != null ? separator + this.getVersion() : "");
    }

    public String getVersion() {
        return (String)this.getEntity().getConfig(SoftwareProcess.SUGGESTED_VERSION);
    }

    public abstract String getRunDir();

    public abstract String getInstallDir();
}

