/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.zookeeper;

import brooklyn.catalog.Catalog;
import brooklyn.config.ConfigKey;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.SoftwareProcess;
import brooklyn.entity.proxying.ImplementedBy;
import brooklyn.entity.zookeeper.ZooKeeperNodeImpl;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.BasicAttributeSensor;
import brooklyn.event.basic.BasicAttributeSensorAndConfigKey;
import brooklyn.event.basic.PortAttributeSensorAndConfigKey;
import brooklyn.util.flags.SetFromFlag;

@Catalog(name="ZooKeeper Node", description="Apache ZooKeeper is a server which enables highly reliable distributed coordination.")
@ImplementedBy(value=ZooKeeperNodeImpl.class)
public interface ZooKeeperNode
extends SoftwareProcess {
    @SetFromFlag(value="version")
    public static final ConfigKey<String> SUGGESTED_VERSION = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SoftwareProcess.SUGGESTED_VERSION, (Object)"3.4.5");
    @SetFromFlag(value="zookeeperPort")
    public static final PortAttributeSensorAndConfigKey ZOOKEEPER_PORT = new PortAttributeSensorAndConfigKey("zookeeper.port", "Zookeeper port", (Object)"2181+");
    @SetFromFlag(value="zookeeperLeaderPort")
    public static final PortAttributeSensorAndConfigKey ZOOKEEPER_LEADER_PORT = new PortAttributeSensorAndConfigKey("zookeeper.leader.port", "Zookeeper leader ports", (Object)"2888+");
    @SetFromFlag(value="zookeeperElectionPort")
    public static final PortAttributeSensorAndConfigKey ZOOKEEPER_ELECTION_PORT = new PortAttributeSensorAndConfigKey("zookeeper.election.port", "Zookeeper election ports", (Object)"3888+");
    @SetFromFlag(value="downloadUrl")
    public static final BasicAttributeSensorAndConfigKey<String> DOWNLOAD_URL = new BasicAttributeSensorAndConfigKey(SoftwareProcess.DOWNLOAD_URL, (Object)"http://apache.fastbull.org/zookeeper/zookeeper-${version}/zookeeper-${version}.tar.gz");
    @SetFromFlag(value="zookeeperConfig")
    public static final ConfigKey<String> ZOOKEEPER_CONFIG_TEMPLATE = ConfigKeys.newStringConfigKey((String)"zookeeper.configTemplate", (String)"Zookeeper configuration template (in freemarker format)", (String)"classpath://brooklyn/entity/messaging/zookeeper/zoo.cfg");
    public static final AttributeSensor<Long> OUTSTANDING_REQUESTS = new BasicAttributeSensor(Long.class, "zookeeper.outstandingRequests", "Outstanding request count");
    public static final AttributeSensor<Long> PACKETS_RECEIVED = new BasicAttributeSensor(Long.class, "zookeeper.packets.received", "Total packets received");
    public static final AttributeSensor<Long> PACKETS_SENT = new BasicAttributeSensor(Long.class, "zookeeper.packets.sent", "Total packets sent");
    public static final AttributeSensor<Integer> MY_ID = new BasicAttributeSensor(Integer.class, "zookeeper.myid", "ZooKeeper node's myId");

    public Integer getZookeeperPort();

    public String getHostname();
}

