/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.zookeeper;

import brooklyn.entity.Entity;
import brooklyn.entity.basic.Attributes;
import brooklyn.entity.basic.EntityInternal;
import brooklyn.entity.group.AbstractMembershipTrackingPolicy;
import brooklyn.entity.group.DynamicClusterImpl;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.entity.zookeeper.ZooKeeperEnsemble;
import brooklyn.entity.zookeeper.ZooKeeperNode;
import brooklyn.event.AttributeSensor;
import brooklyn.location.Location;
import brooklyn.policy.PolicySpec;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperEnsembleImpl
extends DynamicClusterImpl
implements ZooKeeperEnsemble {
    private static final Logger log = LoggerFactory.getLogger(ZooKeeperEnsembleImpl.class);
    private static final AtomicInteger myId = new AtomicInteger();
    private MemberTrackingPolicy policy;

    protected EntitySpec<?> getMemberSpec() {
        return (EntitySpec)this.getConfig(MEMBER_SPEC, EntitySpec.create(ZooKeeperNode.class));
    }

    @Override
    public String getClusterName() {
        return (String)this.getAttribute((AttributeSensor)CLUSTER_NAME);
    }

    public void init() {
        log.info("Initializing the ZooKeeper Ensemble");
        super.init();
        this.policy = (MemberTrackingPolicy)this.addPolicy(((PolicySpec)PolicySpec.create(MemberTrackingPolicy.class).displayName("Members tracker")).configure((CharSequence)"group", (Object)this));
    }

    protected void initEnrichers() {
        super.initEnrichers();
    }

    public void start(Collection<? extends Location> locations) {
        super.start(locations);
        ArrayList zookeeperServers = Lists.newArrayList();
        for (Entity zookeeper : this.getMembers()) {
            zookeeperServers.add(zookeeper.getAttribute(Attributes.HOSTNAME));
        }
        this.setAttribute(ZOOKEEPER_SERVERS, zookeeperServers);
    }

    public static class MemberTrackingPolicy
    extends AbstractMembershipTrackingPolicy {
        protected void onEntityChange(Entity member) {
        }

        protected void onEntityAdded(Entity member) {
            if (member.getAttribute(ZooKeeperNode.MY_ID) == null) {
                ((EntityInternal)member).setAttribute(ZooKeeperNode.MY_ID, (Object)myId.incrementAndGet());
            }
        }

        protected void onEntityRemoved(Entity member) {
        }
    }
}

