/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.zookeeper;

import brooklyn.catalog.Catalog;
import brooklyn.config.ConfigKey;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.group.DynamicCluster;
import brooklyn.entity.proxying.ImplementedBy;
import brooklyn.entity.zookeeper.ZooKeeperEnsembleImpl;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.BasicAttributeSensorAndConfigKey;
import brooklyn.event.basic.Sensors;
import brooklyn.util.flags.SetFromFlag;
import com.google.common.reflect.TypeToken;
import java.util.List;

@Catalog(name="ZooKeeper ensemble", description="A cluster of ZooKeeper servers. Apache ZooKeeper enables highly reliable distributed coordination.")
@ImplementedBy(value=ZooKeeperEnsembleImpl.class)
public interface ZooKeeperEnsemble
extends DynamicCluster {
    @SetFromFlag(value="clusterName")
    public static final BasicAttributeSensorAndConfigKey<String> CLUSTER_NAME = new BasicAttributeSensorAndConfigKey(String.class, "zookeeper.cluster.name", "Name of the Zookeeper cluster", (Object)"BrooklynZookeeperCluster");
    @SetFromFlag(value="initialSize")
    public static final ConfigKey<Integer> INITIAL_SIZE = ConfigKeys.newConfigKeyWithDefault((ConfigKey)DynamicCluster.INITIAL_SIZE, (Object)3);
    public static final AttributeSensor<List<String>> ZOOKEEPER_SERVERS = Sensors.newSensor((TypeToken)new TypeToken<List<String>>(){}, (String)"zookeeper.servers", (String)"Hostnames to connect to cluster with");

    public String getClusterName();
}

