/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.messaging.storm;

import brooklyn.entity.Entity;
import brooklyn.entity.basic.Attributes;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.basic.SoftwareProcess;
import brooklyn.entity.drivers.EntityDriver;
import brooklyn.entity.java.JavaSoftwareProcessSshDriver;
import brooklyn.entity.messaging.storm.Storm;
import brooklyn.entity.messaging.storm.StormDriver;
import brooklyn.entity.zookeeper.ZooKeeperEnsemble;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.DependentConfiguration;
import brooklyn.location.basic.Machines;
import brooklyn.location.basic.SshMachineLocation;
import brooklyn.management.Task;
import brooklyn.management.TaskAdaptable;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.net.Networking;
import brooklyn.util.os.Os;
import brooklyn.util.ssh.BashCommands;
import brooklyn.util.time.Duration;
import brooklyn.util.time.Time;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StormSshDriver
extends JavaSoftwareProcessSshDriver
implements StormDriver {
    private static final Logger log = LoggerFactory.getLogger(StormSshDriver.class);

    public StormSshDriver(EntityLocal entity, SshMachineLocation machine) {
        super(entity, machine);
    }

    public String getRoleName() {
        return ((Storm.Role)((Object)this.entity.getConfig(Storm.ROLE))).name().toLowerCase();
    }

    public String getZeromqVersion() {
        return (String)this.entity.getConfig(Storm.ZEROMQ_VERSION);
    }

    public String getLocalDir() {
        return (String)Optional.fromNullable((Object)this.entity.getConfig(Storm.LOCAL_DIR)).or((Object)Os.mergePathsUnix((String[])new String[]{this.getRunDir(), "storm"}));
    }

    public String getNimbusHostname() {
        String result = (String)this.entity.getConfig(Storm.NIMBUS_HOSTNAME);
        if (result != null) {
            return result;
        }
        Entity nimbus = (Entity)this.entity.getConfig(Storm.NIMBUS_ENTITY);
        if (nimbus == null) {
            log.warn("No nimbus hostname available; using 'localhost'");
            return "localhost";
        }
        return (String)((Task)Entities.submit((Entity)this.entity, (TaskAdaptable)DependentConfiguration.attributeWhenReady((Entity)nimbus, (AttributeSensor)Attributes.HOSTNAME))).getUnchecked();
    }

    public Integer getUiPort() {
        return (Integer)this.entity.getAttribute((AttributeSensor)Storm.UI_PORT);
    }

    public Map<String, Integer> getPortMap() {
        return MutableMap.of((Object)"uiPort", (Object)this.getUiPort());
    }

    protected List<String> getCustomJavaConfigOptions() {
        List result = super.getCustomJavaConfigOptions();
        if ("nimbus".equals(this.getRoleName()) || "supervisor".equals(this.getRoleName())) {
            result.add("-verbose:gc");
            result.add("-XX:+PrintGCTimeStamps");
            result.add("-XX:+PrintGCDetails");
        }
        if ("ui".equals(this.getRoleName())) {
            result.add("-Xmx768m");
        }
        return result;
    }

    @Override
    public String getJvmOptsLine() {
        return (String)Optional.fromNullable(this.getShellEnvironment().get("JAVA_OPTS")).or((Object)"");
    }

    public List<String> getZookeeperServers() {
        ZooKeeperEnsemble zooKeeperEnsemble = (ZooKeeperEnsemble)this.entity.getConfig(Storm.ZOOKEEPER_ENSEMBLE);
        Supplier supplier = Entities.attributeSupplierWhenReady((Entity)zooKeeperEnsemble, ZooKeeperEnsemble.ZOOKEEPER_SERVERS);
        return (List)supplier.get();
    }

    public String getStormConfigTemplateUrl() {
        return (String)this.entity.getConfig(Storm.STORM_CONFIG_TEMPLATE_URL);
    }

    public void preInstall() {
        this.resolver = Entities.newDownloader((EntityDriver)this);
        this.setExpandedInstallDir(Os.mergePaths((String[])new String[]{this.getInstallDir(), this.resolver.getUnpackedDirectoryName(String.format("storm-%s", this.getVersion()))}));
    }

    public void install() {
        List urls = this.resolver.getTargets();
        String saveAs = this.resolver.getFilename();
        ImmutableList.Builder commands = ImmutableList.builder();
        if (!this.getLocation().getOsDetails().isMac()) {
            commands.add((Object)BashCommands.installPackage((Map)ImmutableMap.of((Object)"yum", (Object)"libuuid-devel", (Object)"apt", (Object)"build-essential uuid-dev pkg-config libtool automake"), (String)"libuuid-devel"));
            commands.add((Object)BashCommands.ifExecutableElse0((String)"yum", (String)BashCommands.sudo((String)"yum -y groupinstall 'Development Tools'")));
        }
        commands.add((Object)BashCommands.installPackage((Map)ImmutableMap.of((Object)"yum", (Object)"git"), (String)"git")).add((Object)BashCommands.INSTALL_UNZIP).addAll(this.installNativeDependencies()).addAll((Iterable)BashCommands.commandsToDownloadUrlsAs((List)urls, (String)saveAs)).add((Object)("unzip " + saveAs)).add((Object)("mkdir -p " + this.getLocalDir())).add((Object)("chmod 777 " + this.getLocalDir()));
        this.newScript((String)"installing").body.append((Collection)commands.build()).gatherOutput().execute();
    }

    public String getPidFile() {
        return Os.mergePathsUnix((String[])new String[]{this.getRunDir(), String.format("%s.pid", this.getRoleName())});
    }

    protected String getLogFileLocation() {
        return Os.mergePathsUnix((String[])new String[]{this.getRunDir(), "logs", String.format("%s.log", this.getRoleName())});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launch() {
        Object startMutex;
        boolean needsSleep = false;
        if (this.getRoleName().equals("supervisor")) {
            Entity nimbus = (Entity)this.entity.getConfig(Storm.NIMBUS_ENTITY);
            if (nimbus == null) {
                log.warn("No nimbus entity available; not blocking before starting supervisors");
            } else {
                Entities.waitForServiceUp((Entity)nimbus, (Duration)((Duration)this.entity.getConfig(SoftwareProcess.START_TIMEOUT)));
                needsSleep = true;
            }
        }
        String subnetHostname = (String)Machines.findSubnetOrPublicHostname((Entity)this.entity).get();
        log.info("Launching " + this.entity + " with role " + this.getRoleName() + " and " + "hostname (public) " + (String)this.getEntity().getAttribute(Attributes.HOSTNAME) + ", " + "hostname (subnet) " + subnetHostname + ")");
        Object object = startMutex = Optional.fromNullable((Object)this.entity.getConfig(Storm.START_MUTEX)).or(new Object());
        synchronized (object) {
            if (needsSleep) {
                Time.sleep((Duration)Duration.TEN_SECONDS);
            }
            this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)this.getPidFile()), (String)"launching").body.append((CharSequence)String.format("nohup ./bin/storm %s > %s 2>&1 &", this.getRoleName(), this.getLogFileLocation())).execute();
        }
    }

    public boolean isRunning() {
        return this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)this.getPidFile()), "check-running").execute() == 0;
    }

    public void stop() {
        this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)this.getPidFile()), "stopping").execute();
    }

    public void customize() {
        log.debug("Customizing {}", (Object)this.entity);
        Networking.checkPortsValid(this.getPortMap());
        this.newScript((String)"customizing").body.append((CharSequence)String.format("cp -R %s/* .", this.getExpandedInstallDir())).execute();
        String destinationConfigFile = Os.mergePathsUnix((String[])new String[]{this.getRunDir(), "conf/storm.yaml"});
        this.copyTemplate(this.getStormConfigTemplateUrl(), destinationConfigFile);
    }

    protected List<String> installNativeDependencies() {
        String zeromqUrl = String.format("http://download.zeromq.org/zeromq-%s.tar.gz", this.getZeromqVersion());
        String targz = String.format("zeromq-%s.tar.gz", this.getZeromqVersion());
        String jzmq = "https://github.com/nathanmarz/jzmq.git";
        ImmutableList.Builder commands = ImmutableList.builder();
        if (this.getLocation().getOsDetails().isMac()) {
            commands.add((Object)"export PATH=$PATH:/usr/local/bin").add((Object)"export JAVA_HOME=$(/usr/libexec/java_home)").add((Object)("cd " + this.getInstallDir())).add((Object)BashCommands.installPackage((Map)ImmutableMap.of((Object)"brew", (Object)"automake"), (String)"make")).add((Object)BashCommands.installPackage((Map)ImmutableMap.of((Object)"brew", (Object)"libtool"), (String)"libtool")).add((Object)BashCommands.installPackage((Map)ImmutableMap.of((Object)"brew", (Object)"pkg-config"), (String)"pkg-config")).add((Object)BashCommands.installPackage((Map)ImmutableMap.of((Object)"brew", (Object)"zeromq"), (String)"zeromq")).add((Object)"git clone https://github.com/asmaier/jzmq").add((Object)"cd jzmq").add((Object)"./autogen.sh").add((Object)"./configure").add((Object)"make").add((Object)BashCommands.sudo((String)"make install")).add((Object)("cd " + this.getInstallDir()));
        } else {
            commands.add((Object)"export JAVA_HOME=$(dirname $(readlink -m `which java`))/../../ || export JAVA_HOME=/usr/lib/jvm/java").add((Object)("cd " + this.getInstallDir())).add((Object)BashCommands.commandToDownloadUrlAs((String)zeromqUrl, (String)targz)).add((Object)("tar xzf " + targz)).add((Object)String.format("cd zeromq-%s", this.getZeromqVersion())).add((Object)"./configure").add((Object)"make").add((Object)BashCommands.sudo((String)"make install")).add((Object)("cd " + this.getInstallDir())).add((Object)("git clone " + jzmq)).add((Object)"cd jzmq").add((Object)"./autogen.sh").add((Object)"./configure").add((Object)BashCommands.ok((String)"pushd src ; touch classdist_noinst.stamp ; CLASSPATH=.:./.:$CLASSPATH javac -d . org/zeromq/ZMQ.java org/zeromq/App.java org/zeromq/ZMQForwarder.java org/zeromq/EmbeddedLibraryTools.java org/zeromq/ZMQQueue.java org/zeromq/ZMQStreamer.java org/zeromq/ZMQException.java")).add((Object)BashCommands.ok((String)"popd")).add((Object)"make").add((Object)BashCommands.sudo((String)"make install")).add((Object)("cd " + this.getInstallDir()));
        }
        return commands.build();
    }
}

