/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.messaging.storm;

import brooklyn.entity.basic.Attributes;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.basic.SoftwareProcessImpl;
import brooklyn.entity.java.JavaAppUtils;
import brooklyn.entity.java.JavaSoftwareProcessDriver;
import brooklyn.entity.messaging.storm.Storm;
import brooklyn.entity.messaging.storm.StormDriver;
import brooklyn.event.AttributeSensor;
import brooklyn.event.feed.jmx.JmxFeed;
import brooklyn.event.feed.jmx.JmxHelper;
import brooklyn.util.time.Duration;
import brooklyn.util.time.Time;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StormImpl
extends SoftwareProcessImpl
implements Storm {
    private static final Logger log = LoggerFactory.getLogger(StormImpl.class);
    public static final ObjectName STORM_MBEAN = JmxHelper.createObjectName((String)"backtype.storm.daemon.nimbus:type=*");
    private JmxHelper jmxHelper;
    private volatile JmxFeed jmxFeed;

    @Override
    public String getHostname() {
        return (String)this.getAttribute(HOSTNAME);
    }

    @Override
    public Storm.Role getRole() {
        return (Storm.Role)((Object)this.getConfig(ROLE));
    }

    @Override
    public String getStormConfigTemplateUrl() {
        return (String)this.getConfig(STORM_CONFIG_TEMPLATE_URL);
    }

    public Class<?> getDriverInterface() {
        return StormDriver.class;
    }

    public String getRoleName() {
        return this.getRole().name().toLowerCase();
    }

    protected void preStart() {
        this.setDefaultDisplayName("Storm Node (" + this.getRoleName() + ")");
        super.preStart();
    }

    protected void connectSensors() {
        super.connectSensors();
        Time.sleep((Duration)Duration.TEN_SECONDS);
        if (this.getRole() == Storm.Role.UI) {
            this.setAttribute(STORM_UI_URL, "http://" + (String)this.getAttribute(Attributes.HOSTNAME) + ":" + this.getAttribute((AttributeSensor)UI_PORT) + "/");
        }
        if (((JavaSoftwareProcessDriver)this.getDriver()).isJmxEnabled()) {
            this.jmxHelper = new JmxHelper((EntityLocal)this);
            this.jmxFeed = JavaAppUtils.connectMXBeanSensors((EntityLocal)this);
            this.connectServiceUpIsRunning();
        } else {
            log.warn("Storm running without JMX monitoring; limited visibility of service available");
            this.connectServiceUpIsRunning();
        }
    }

    public void disconnectSensors() {
        super.disconnectSensors();
        this.disconnectServiceUpIsRunning();
        if (this.jmxFeed != null) {
            this.jmxFeed.stop();
        }
        if (this.jmxHelper != null) {
            this.jmxHelper.terminate();
        }
    }
}

