/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.messaging.storm;

import brooklyn.config.ConfigKey;
import brooklyn.enricher.Enrichers;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.Attributes;
import brooklyn.entity.basic.BasicStartableImpl;
import brooklyn.entity.group.DynamicCluster;
import brooklyn.entity.messaging.storm.Storm;
import brooklyn.entity.messaging.storm.StormDeployment;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.entity.zookeeper.ZooKeeperEnsemble;
import brooklyn.event.Sensor;
import brooklyn.util.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StormDeploymentImpl
extends BasicStartableImpl
implements StormDeployment {
    private static final Logger log = LoggerFactory.getLogger(StormDeploymentImpl.class);

    public void init() {
        super.init();
        new ResourceUtils((Object)this).checkUrlExists((String)Storm.STORM_CONFIG_TEMPLATE_URL.getDefaultValue());
        this.setDefaultDisplayName("Storm Deployment");
        ZooKeeperEnsemble zooKeeperEnsemble = (ZooKeeperEnsemble)this.addChild(EntitySpec.create(ZooKeeperEnsemble.class).configure(ZooKeeperEnsemble.INITIAL_SIZE, this.getConfig(ZOOKEEPERS_COUNT)));
        this.setConfig(Storm.ZOOKEEPER_ENSEMBLE, zooKeeperEnsemble);
        Storm nimbus = (Storm)this.addChild(EntitySpec.create(Storm.class).configure(Storm.ROLE, (Object)Storm.Role.NIMBUS));
        this.setConfig(Storm.NIMBUS_ENTITY, nimbus);
        this.setConfig(Storm.START_MUTEX, new Object());
        this.addChild((EntitySpec)EntitySpec.create(DynamicCluster.class).configure(DynamicCluster.MEMBER_SPEC, (Object)EntitySpec.create(Storm.class).configure(Storm.ROLE, (Object)Storm.Role.SUPERVISOR)).configure((ConfigKey)DynamicCluster.INITIAL_SIZE, this.getConfig(SUPERVISORS_COUNT)).displayName("Storm Supervisor Cluster"));
        Storm ui = (Storm)this.addChild(EntitySpec.create(Storm.class).configure(Storm.ROLE, (Object)Storm.Role.UI));
        this.addEnricher(((Enrichers.PropagatorBuilder)Enrichers.builder().propagating(new Sensor[]{Storm.STORM_UI_URL}).from((Entity)ui)).build());
        this.addEnricher(((Enrichers.PropagatorBuilder)Enrichers.builder().propagating(new Sensor[]{Attributes.HOSTNAME}).from((Entity)nimbus)).build());
    }
}

