/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.messaging.storm;

import brooklyn.catalog.Catalog;
import brooklyn.config.ConfigKey;
import brooklyn.config.render.RendererHints;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.SoftwareProcess;
import brooklyn.entity.java.UsesJmx;
import brooklyn.entity.messaging.storm.StormImpl;
import brooklyn.entity.proxying.ImplementedBy;
import brooklyn.entity.zookeeper.ZooKeeperEnsemble;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.BasicAttributeSensorAndConfigKey;
import brooklyn.event.basic.PortAttributeSensorAndConfigKey;
import brooklyn.event.basic.Sensors;
import brooklyn.util.flags.SetFromFlag;

@Catalog(name="Storm Node", description="Apache Storm is a distributed realtime computation system. Storm makes it easy to reliably process unbounded streams of data, doing for realtime processing what Hadoop did for batch processing")
@ImplementedBy(value=StormImpl.class)
public interface Storm
extends SoftwareProcess,
UsesJmx {
    @SetFromFlag(value="version")
    public static final ConfigKey<String> SUGGESTED_VERSION = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SoftwareProcess.SUGGESTED_VERSION, (Object)"0.8.2");
    @SetFromFlag(value="nimbusHostname")
    public static final ConfigKey<String> NIMBUS_HOSTNAME = ConfigKeys.newStringConfigKey((String)"storm.nimbus.hostname");
    @SetFromFlag(value="nimbusEntity")
    public static final ConfigKey<Entity> NIMBUS_ENTITY = ConfigKeys.newConfigKey(Entity.class, (String)"storm.nimbus.entity");
    @SetFromFlag(value="downloadUrl")
    public static final BasicAttributeSensorAndConfigKey<String> DOWNLOAD_URL = new BasicAttributeSensorAndConfigKey(SoftwareProcess.DOWNLOAD_URL, (Object)"https://dl.dropboxusercontent.com/s/fl4kr7w0oc8ihdw/storm-${version}.zip");
    public static final ConfigKey<Object> START_MUTEX = ConfigKeys.newConfigKey(Object.class, (String)"storm.start.mutex");
    @SetFromFlag(value="role")
    public static final ConfigKey<Role> ROLE = ConfigKeys.newConfigKey(Role.class, (String)"storm.role", (String)"The Storm server role");
    @SetFromFlag(value="localDir")
    public static final ConfigKey<String> LOCAL_DIR = ConfigKeys.newStringConfigKey((String)"storm.local.dir", (String)"Setting for Storm local dir");
    @SetFromFlag(value="uiPort")
    public static final PortAttributeSensorAndConfigKey UI_PORT = new PortAttributeSensorAndConfigKey("storm.ui.port", "Storm UI port", (Object)"8080+");
    @SetFromFlag(value="thriftPort")
    public static final PortAttributeSensorAndConfigKey THRIFT_PORT = new PortAttributeSensorAndConfigKey("storm.thrift.port", "Storm Thrift port", (Object)"6627");
    @SetFromFlag(value="zookeeperEnsemble")
    public static final ConfigKey<ZooKeeperEnsemble> ZOOKEEPER_ENSEMBLE = ConfigKeys.newConfigKey(ZooKeeperEnsemble.class, (String)"storm.zookeeper.ensemble", (String)"Zookeeper ensemble entity");
    @SetFromFlag(value="stormConfigTemplateUrl")
    public static final ConfigKey<String> STORM_CONFIG_TEMPLATE_URL = ConfigKeys.newStringConfigKey((String)"storm.config.templateUrl", (String)"Template file (in freemarker format) for the storm.yaml config file", (String)"classpath://brooklyn/entity/messaging/storm/storm.yaml");
    @SetFromFlag(value="zeromqVersion")
    public static final ConfigKey<String> ZEROMQ_VERSION = ConfigKeys.newStringConfigKey((String)"storm.zeromq.version", (String)"zeromq version", (String)"2.1.7");
    public static final AttributeSensor<Boolean> SERVICE_UP_JMX = Sensors.newBooleanSensor((String)"storm.service.jmx.up", (String)"Whether JMX is up for this service");
    public static final AttributeSensor<String> STORM_UI_URL = StormUiUrl.STORM_UI_URL;

    public String getStormConfigTemplateUrl();

    public String getHostname();

    public Role getRole();

    public static class StormUiUrl {
        public static final AttributeSensor<String> STORM_UI_URL = Sensors.newStringSensor((String)"storm.ui.url", (String)"URL");

        static {
            RendererHints.register(STORM_UI_URL, (RendererHints.Hint)RendererHints.namedActionWithUrl());
        }
    }

    public static enum Role {
        NIMBUS,
        SUPERVISOR,
        UI;

    }
}

