/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.messaging.rabbit;

import brooklyn.entity.basic.AbstractSoftwareProcessSshDriver;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.basic.lifecycle.ScriptHelper;
import brooklyn.entity.drivers.EntityDriver;
import brooklyn.entity.messaging.amqp.AmqpServer;
import brooklyn.entity.messaging.rabbit.RabbitBroker;
import brooklyn.entity.messaging.rabbit.RabbitBrokerImpl;
import brooklyn.entity.messaging.rabbit.RabbitDriver;
import brooklyn.event.AttributeSensor;
import brooklyn.location.basic.SshMachineLocation;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.net.Networking;
import brooklyn.util.os.Os;
import brooklyn.util.ssh.BashCommands;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RabbitSshDriver
extends AbstractSoftwareProcessSshDriver
implements RabbitDriver {
    private static final Logger log = LoggerFactory.getLogger(RabbitSshDriver.class);
    private static final Map<String, String> CENTOS_VERSION_TO_EPEL_VERSION = ImmutableMap.of((Object)"5", (Object)"5-4", (Object)"6", (Object)"6-8", (Object)"7", (Object)"7-5");

    public RabbitSshDriver(RabbitBrokerImpl entity, SshMachineLocation machine) {
        super((EntityLocal)entity, machine);
    }

    protected String getLogFileLocation() {
        return this.getRunDir() + "/" + this.entity.getId() + ".log";
    }

    public Integer getAmqpPort() {
        return (Integer)this.entity.getAttribute((AttributeSensor)AmqpServer.AMQP_PORT);
    }

    public String getVirtualHost() {
        return (String)this.entity.getAttribute(AmqpServer.VIRTUAL_HOST_NAME);
    }

    public String getErlangVersion() {
        return (String)this.entity.getConfig(RabbitBroker.ERLANG_VERSION);
    }

    public RabbitBrokerImpl getEntity() {
        return (RabbitBrokerImpl)super.getEntity();
    }

    public void preInstall() {
        this.resolver = Entities.newDownloader((EntityDriver)this);
        this.setExpandedInstallDir(Os.mergePaths((String[])new String[]{this.getInstallDir(), this.resolver.getUnpackedDirectoryName(String.format("rabbitmq_server-%s", this.getVersion()))}));
    }

    public void install() {
        List urls = this.resolver.getTargets();
        String saveAs = this.resolver.getFilename();
        String osMajorVersion = this.getMachine().getOsDetails().getVersion();
        if (Strings.isNullOrEmpty((String)osMajorVersion)) {
            osMajorVersion = "7";
        } else {
            String string = osMajorVersion = osMajorVersion.indexOf(".") > 0 ? osMajorVersion.substring(0, osMajorVersion.indexOf(46)) : osMajorVersion;
            if (!CENTOS_VERSION_TO_EPEL_VERSION.keySet().contains(osMajorVersion)) {
                osMajorVersion = "7";
            }
        }
        String epelVersion = CENTOS_VERSION_TO_EPEL_VERSION.get(osMajorVersion);
        String osArchitecture = this.getMachine().getOsDetails().getArch();
        if (Strings.isNullOrEmpty((String)osArchitecture)) {
            osArchitecture = "x86_64";
        }
        ImmutableList commands = ImmutableList.builder().add((Object)BashCommands.chainGroup((String[])new String[]{"which yum", BashCommands.sudo((String)"yum -y update ca-certificates"), BashCommands.sudo((String)("rpm -Uvh " + String.format("http://download.fedoraproject.org/pub/epel/%s/%s/epel-release-%s.noarch.rpm", osMajorVersion, osArchitecture, epelVersion)))})).add((Object)BashCommands.ifExecutableElse0((String)"zypper", (String)BashCommands.chainGroup((String[])new String[]{BashCommands.ok((String)BashCommands.sudo((String)"zypper --non-interactive addrepo http://download.opensuse.org/repositories/devel:/languages:/erlang/SLE_11_SP3 erlang_sles_11")), BashCommands.ok((String)BashCommands.sudo((String)"zypper --non-interactive addrepo http://download.opensuse.org/repositories/devel:/languages:/erlang/openSUSE_11.4 erlang_suse_11")), BashCommands.ok((String)BashCommands.sudo((String)"zypper --non-interactive addrepo http://download.opensuse.org/repositories/devel:/languages:/erlang/openSUSE_12.3 erlang_suse_12")), BashCommands.ok((String)BashCommands.sudo((String)"zypper --non-interactive addrepo http://download.opensuse.org/repositories/devel:/languages:/erlang/openSUSE_13.1 erlang_suse_13"))}))).add((Object)BashCommands.installPackage((Map)ImmutableMap.of((Object)"apt", (Object)"erlang-nox erlang-dev", (Object)"port", (Object)("erlang@" + this.getErlangVersion() + "+ssl")), (String)"erlang")).addAll((Iterable)BashCommands.commandsToDownloadUrlsAs((List)urls, (String)saveAs)).add((Object)BashCommands.installExecutable((String)"tar")).add((Object)String.format("tar xvzf %s", saveAs)).build();
        this.newScript((String)"installing").failOnNonZeroResultCode().body.append((Collection)commands).execute();
    }

    public void customize() {
        Networking.checkPortsValid((Map)MutableMap.of((Object)"amqpPort", (Object)this.getAmqpPort()));
        ScriptHelper scriptHelper = this.newScript("customizing");
        scriptHelper.body.append((CharSequence)String.format("cp -R %s/* .", this.getExpandedInstallDir()));
        if (Boolean.TRUE.equals(this.entity.getConfig(RabbitBroker.ENABLE_MANAGEMENT_PLUGIN))) {
            scriptHelper.body.append((CharSequence)"./sbin/rabbitmq-plugins enable rabbitmq_management");
        }
        scriptHelper.failOnNonZeroResultCode();
        scriptHelper.execute();
        this.copyTemplate((String)this.entity.getConfig(RabbitBroker.CONFIG_TEMPLATE_URL), this.getConfigPath() + ".config");
    }

    public void launch() {
        this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)Boolean.valueOf((boolean)false)), (String)"launching").body.append(new CharSequence[]{"nohup ./sbin/rabbitmq-server > console-out.log 2> console-err.log &", "for i in {1..10}\ndo\n    grep 'broker running' console-out.log && exit\n    sleep 1\ndone", "echo \"Couldn't determine if rabbitmq-server is running\"", "exit 1"}).execute();
    }

    @Override
    public void configure() {
        this.newScript((String)"customizing").body.append(new CharSequence[]{"./sbin/rabbitmqctl add_vhost " + this.getEntity().getVirtualHost(), "./sbin/rabbitmqctl set_permissions -p " + this.getEntity().getVirtualHost() + " guest \".*\" \".*\" \".*\""}).execute();
    }

    public String getPidFile() {
        return "rabbitmq.pid";
    }

    public boolean isRunning() {
        return this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)Boolean.valueOf((boolean)false)), (String)"check-running").body.append((CharSequence)"./sbin/rabbitmqctl -q status").execute() == 0;
    }

    public void stop() {
        this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)Boolean.valueOf((boolean)false)), (String)"stopping").body.append((CharSequence)"./sbin/rabbitmqctl stop").execute();
    }

    public void kill() {
        this.stop();
    }

    @Override
    public Map<String, String> getShellEnvironment() {
        return MutableMap.builder().putAll(super.getShellEnvironment()).put((Object)"RABBITMQ_HOME", (Object)this.getRunDir()).put((Object)"RABBITMQ_LOG_BASE", (Object)this.getRunDir()).put((Object)"RABBITMQ_NODENAME", (Object)this.getEntity().getId()).put((Object)"RABBITMQ_NODE_PORT", (Object)this.getAmqpPort().toString()).put((Object)"RABBITMQ_PID_FILE", (Object)(this.getRunDir() + "/" + this.getPidFile())).put((Object)"RABBITMQ_CONFIG_FILE", (Object)this.getConfigPath()).build();
    }

    private String getConfigPath() {
        return this.getRunDir() + "/rabbitmq";
    }
}

