/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.messaging.rabbit;

import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.messaging.Queue;
import brooklyn.entity.messaging.rabbit.RabbitDestination;
import brooklyn.event.AttributeSensor;
import brooklyn.event.feed.ssh.SshFeed;
import brooklyn.event.feed.ssh.SshPollConfig;
import brooklyn.event.feed.ssh.SshPollValue;
import com.google.common.base.Function;
import com.google.common.base.Functions;

public class RabbitQueue
extends RabbitDestination
implements Queue {
    private SshFeed sshFeed;

    public String getName() {
        return this.getDisplayName();
    }

    @Override
    public void create() {
        this.setAttribute((AttributeSensor)QUEUE_NAME, this.getName());
        super.create();
    }

    @Override
    protected void connectSensors() {
        String runDir = this.getParent().getRunDir();
        String cmd = String.format("%s/sbin/rabbitmqctl list_queues -p /%s  | grep '%s'", runDir, this.getVirtualHost(), this.getQueueName());
        this.sshFeed = SshFeed.builder().entity((EntityLocal)this).machine(this.machine).poll((SshPollConfig)((SshPollConfig)new SshPollConfig(QUEUE_DEPTH_BYTES).env(this.shellEnvironment).command(cmd).onFailure(Functions.constant((Object)-1))).onSuccess((Function)new Function<SshPollValue, Integer>(){

            public Integer apply(SshPollValue input) {
                return 0;
            }
        })).poll((SshPollConfig)((SshPollConfig)new SshPollConfig(QUEUE_DEPTH_MESSAGES).env(this.shellEnvironment).command(cmd).onFailure(Functions.constant((Object)-1))).onSuccess((Function)new Function<SshPollValue, Integer>(){

            public Integer apply(SshPollValue input) {
                return 0;
            }
        })).build();
    }

    @Override
    protected void disconnectSensors() {
        if (this.sshFeed != null) {
            this.sshFeed.stop();
        }
        super.disconnectSensors();
    }

    @Override
    public String getQueueName() {
        return this.getName();
    }
}

