/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.messaging.rabbit;

import brooklyn.entity.Entity;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.SoftwareProcessImpl;
import brooklyn.entity.messaging.rabbit.RabbitBroker;
import brooklyn.entity.messaging.rabbit.RabbitDriver;
import brooklyn.entity.messaging.rabbit.RabbitQueue;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.event.AttributeSensor;
import com.google.common.base.Objects;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RabbitBrokerImpl
extends SoftwareProcessImpl
implements RabbitBroker {
    private static final Logger log = LoggerFactory.getLogger(RabbitBrokerImpl.class);

    @Override
    public String getVirtualHost() {
        return (String)this.getAttribute((AttributeSensor)VIRTUAL_HOST_NAME);
    }

    @Override
    public String getAmqpVersion() {
        return (String)this.getAttribute((AttributeSensor)AMQP_VERSION);
    }

    @Override
    public Integer getAmqpPort() {
        return (Integer)this.getAttribute((AttributeSensor)AMQP_PORT);
    }

    public RabbitDriver getDriver() {
        return (RabbitDriver)super.getDriver();
    }

    @Override
    public Map<String, String> getShellEnvironment() {
        return this.getDriver().getShellEnvironment();
    }

    @Override
    public String getRunDir() {
        return this.getDriver().getRunDir();
    }

    protected void postStart() {
        super.postStart();
        this.getDriver().configure();
    }

    @Override
    public void setBrokerUrl() {
        String urlFormat = "amqp://guest:guest@%s:%d/%s";
        this.setAttribute(BROKER_URL, String.format(urlFormat, this.getAttribute(HOSTNAME), this.getAttribute((AttributeSensor)AMQP_PORT), this.getAttribute((AttributeSensor)VIRTUAL_HOST_NAME)));
    }

    @Override
    public RabbitQueue createQueue(Map properties) {
        RabbitQueue result = (RabbitQueue)this.addChild(EntitySpec.create(RabbitQueue.class).configure(properties));
        Entities.manage((Entity)result);
        result.create();
        return result;
    }

    public Class<? extends RabbitDriver> getDriverInterface() {
        return RabbitDriver.class;
    }

    protected void connectSensors() {
        super.connectSensors();
        this.connectServiceUpIsRunning();
        this.setBrokerUrl();
        if (this.getEnableManagementPlugin()) {
            this.setAttribute(MANAGEMENT_URL, String.format("http://%s:%s/", this.getAttribute(HOSTNAME), this.getAttribute((AttributeSensor)MANAGEMENT_PORT)));
        }
    }

    public void disconnectSensors() {
        super.disconnectSensors();
        this.disconnectServiceUpIsRunning();
    }

    public boolean getEnableManagementPlugin() {
        return Boolean.TRUE.equals(this.getConfig(ENABLE_MANAGEMENT_PLUGIN));
    }

    public Integer getManagementPort() {
        return (Integer)this.getAttribute((AttributeSensor)MANAGEMENT_PORT);
    }

    protected Objects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("amqpPort", (Object)this.getAmqpPort());
    }
}

