/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.messaging.rabbit;

import brooklyn.catalog.Catalog;
import brooklyn.config.ConfigKey;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.SoftwareProcess;
import brooklyn.entity.messaging.MessageBroker;
import brooklyn.entity.messaging.amqp.AmqpServer;
import brooklyn.entity.messaging.rabbit.RabbitBrokerImpl;
import brooklyn.entity.messaging.rabbit.RabbitQueue;
import brooklyn.entity.proxying.ImplementedBy;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.BasicAttributeSensorAndConfigKey;
import brooklyn.event.basic.BasicConfigKey;
import brooklyn.event.basic.PortAttributeSensorAndConfigKey;
import brooklyn.event.basic.Sensors;
import brooklyn.util.flags.SetFromFlag;
import com.google.common.annotations.Beta;
import java.util.Map;

@Catalog(name="RabbitMQ Broker", description="RabbitMQ is an open source message broker software (i.e. message-oriented middleware) that implements the Advanced Message Queuing Protocol (AMQP) standard", iconUrl="classpath:///RabbitMQLogo.png")
@ImplementedBy(value=RabbitBrokerImpl.class)
public interface RabbitBroker
extends SoftwareProcess,
MessageBroker,
AmqpServer {
    @SetFromFlag(value="version")
    public static final ConfigKey<String> SUGGESTED_VERSION = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SoftwareProcess.SUGGESTED_VERSION, (Object)"2.8.7");
    @SetFromFlag(value="downloadUrl")
    public static final BasicAttributeSensorAndConfigKey<String> DOWNLOAD_URL = new BasicAttributeSensorAndConfigKey(SoftwareProcess.DOWNLOAD_URL, (Object)"http://www.rabbitmq.com/releases/rabbitmq-server/v${version}/rabbitmq-server-generic-unix-${version}.tar.gz");
    @SetFromFlag(value="erlangVersion")
    public static final BasicConfigKey<String> ERLANG_VERSION = new BasicConfigKey(String.class, "erlang.version", "Erlang runtime version", (Object)"R15B");
    @SetFromFlag(value="rabbitmqConfigTemplateUrl")
    public static final ConfigKey<String> CONFIG_TEMPLATE_URL = ConfigKeys.newStringConfigKey((String)"rabbitmq.templateUrl", (String)"Template file (in freemarker format) for the rabbitmq.config config file", (String)"classpath://brooklyn/entity/messaging/rabbit/rabbitmq.config");
    @SetFromFlag(value="amqpPort")
    public static final PortAttributeSensorAndConfigKey AMQP_PORT = AmqpServer.AMQP_PORT;
    @SetFromFlag(value="virtualHost")
    public static final BasicAttributeSensorAndConfigKey<String> VIRTUAL_HOST_NAME = AmqpServer.VIRTUAL_HOST_NAME;
    @SetFromFlag(value="amqpVersion")
    public static final BasicAttributeSensorAndConfigKey<String> AMQP_VERSION = new BasicAttributeSensorAndConfigKey(AmqpServer.AMQP_VERSION, (Object)"0-9-1");
    @SetFromFlag(value="managmentPort")
    public static final PortAttributeSensorAndConfigKey MANAGEMENT_PORT = new PortAttributeSensorAndConfigKey("rabbitmq.management.port", "Port on which management interface will be available", (Object)"15672+");
    public static final AttributeSensor<String> MANAGEMENT_URL = Sensors.newStringSensor((String)"rabbitmq.management.url", (String)"Management URL is only available if management plugin flag is true");
    @SetFromFlag(value="enableManagementPlugin")
    public static final ConfigKey<Boolean> ENABLE_MANAGEMENT_PLUGIN = ConfigKeys.newBooleanConfigKey((String)"rabbitmq.management.plugin", (String)"Management plugin will be enabled", (Boolean)false);

    public RabbitQueue createQueue(Map var1);

    @Beta
    public Map<String, String> getShellEnvironment();

    @Beta
    public String getRunDir();
}

