/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.messaging.qpid;

import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.messaging.qpid.QpidDestinationImpl;
import brooklyn.entity.messaging.qpid.QpidQueue;
import brooklyn.event.AttributeSensor;
import brooklyn.event.feed.jmx.JmxAttributePollConfig;
import brooklyn.event.feed.jmx.JmxFeed;
import brooklyn.util.exceptions.Exceptions;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class QpidQueueImpl
extends QpidDestinationImpl
implements QpidQueue {
    @Override
    public void onManagementStarting() {
        super.onManagementStarting();
        this.setAttribute((AttributeSensor)QUEUE_NAME, this.getName());
        try {
            this.exchange = new ObjectName(String.format("org.apache.qpid:type=VirtualHost.Exchange,VirtualHost=\"%s\",name=\"%s\",ExchangeType=direct", this.virtualHost, this.getExchangeName()));
        }
        catch (MalformedObjectNameException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    @Override
    protected void connectSensors() {
        String queue = String.format("org.apache.qpid:type=VirtualHost.Queue,VirtualHost=\"%s\",name=\"%s\"", this.virtualHost, this.getName());
        this.jmxFeed = JmxFeed.builder().entity((EntityLocal)this).helper(this.jmxHelper).pollAttribute(new JmxAttributePollConfig(QUEUE_DEPTH_BYTES).objectName(queue).attributeName("QueueDepth")).pollAttribute(new JmxAttributePollConfig(QUEUE_DEPTH_MESSAGES).objectName(queue).attributeName("MessageCount")).build();
    }

    @Override
    public String getExchangeName() {
        return "amq.direct";
    }
}

