/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.messaging.qpid;

import brooklyn.config.ConfigKey;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.java.UsesJmx;
import brooklyn.entity.messaging.jms.JMSDestinationImpl;
import brooklyn.entity.messaging.qpid.QpidBroker;
import brooklyn.entity.messaging.qpid.QpidDestination;
import brooklyn.event.AttributeSensor;
import brooklyn.event.feed.jmx.JmxFeed;
import brooklyn.event.feed.jmx.JmxHelper;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.flags.SetFromFlag;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class QpidDestinationImpl
extends JMSDestinationImpl
implements QpidDestination {
    public static final Logger log = LoggerFactory.getLogger(QpidDestination.class);
    @SetFromFlag
    String virtualHost;
    protected ObjectName virtualHostManager;
    protected ObjectName exchange;
    protected transient JmxHelper jmxHelper;
    protected volatile JmxFeed jmxFeed;

    public QpidBroker getParent() {
        return (QpidBroker)super.getParent();
    }

    @Override
    public void onManagementStarting() {
        super.onManagementStarting();
        try {
            if (this.virtualHost == null) {
                this.virtualHost = (String)this.getConfig((ConfigKey.HasConfigKey)QpidBroker.VIRTUAL_HOST_NAME);
            }
            this.setAttribute((AttributeSensor)QpidBroker.VIRTUAL_HOST_NAME, this.virtualHost);
            this.virtualHostManager = new ObjectName(String.format("org.apache.qpid:type=VirtualHost.VirtualHostManager,VirtualHost=\"%s\"", this.virtualHost));
            this.jmxHelper = new JmxHelper((EntityLocal)this.getParent());
        }
        catch (MalformedObjectNameException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    @Override
    protected void disconnectSensors() {
        if (this.jmxFeed != null) {
            this.jmxFeed.stop();
        }
    }

    @Override
    public void create() {
        this.jmxHelper.operation(this.virtualHostManager, "createNewQueue", new Object[]{this.getName(), this.getParent().getAttribute((AttributeSensor)UsesJmx.JMX_USER), true});
        this.jmxHelper.operation(this.exchange, "createNewBinding", new Object[]{this.getName(), this.getName()});
        this.connectSensors();
    }

    @Override
    public void delete() {
        this.jmxHelper.operation(this.exchange, "removeBinding", new Object[]{this.getName(), this.getName()});
        this.jmxHelper.operation(this.virtualHostManager, "deleteQueue", new Object[]{this.getName()});
        this.disconnectSensors();
    }

    @Override
    public String getQueueName() {
        if ("0-10".equals(this.getParent().getAmqpVersion())) {
            return String.format("'%s'/'%s'; { assert: never }", this.getExchangeName(), this.getName());
        }
        return this.getName();
    }
}

