/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.messaging.kafka;

import brooklyn.enricher.Enrichers;
import brooklyn.entity.Effector;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.AbstractEntity;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.group.DynamicCluster;
import brooklyn.entity.messaging.kafka.KafkaBroker;
import brooklyn.entity.messaging.kafka.KafkaCluster;
import brooklyn.entity.messaging.kafka.KafkaZooKeeper;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.entity.trait.Startable;
import brooklyn.entity.zookeeper.ZooKeeperNode;
import brooklyn.event.AttributeSensor;
import brooklyn.event.Sensor;
import brooklyn.event.basic.AttributeSensorAndConfigKey;
import brooklyn.event.feed.ConfigToAttributes;
import brooklyn.location.Location;
import brooklyn.util.collections.MutableList;
import brooklyn.util.exceptions.CompoundRuntimeException;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaClusterImpl
extends AbstractEntity
implements KafkaCluster {
    public static final Logger log = LoggerFactory.getLogger(KafkaClusterImpl.class);

    public void init() {
        super.init();
        this.setAttribute(SERVICE_UP, false);
        ConfigToAttributes.apply((EntityLocal)this, (AttributeSensorAndConfigKey)BROKER_SPEC);
        ConfigToAttributes.apply((EntityLocal)this, (AttributeSensorAndConfigKey)ZOOKEEPER);
        ConfigToAttributes.apply((EntityLocal)this, (AttributeSensorAndConfigKey)ZOOKEEPER_SPEC);
        log.debug("creating zookeeper child for {}", (Object)this);
        ZooKeeperNode zookeeper = (ZooKeeperNode)this.getAttribute((AttributeSensor)ZOOKEEPER);
        if (zookeeper == null) {
            EntitySpec zookeeperSpec = (EntitySpec)this.getAttribute((AttributeSensor)ZOOKEEPER_SPEC);
            if (zookeeperSpec == null) {
                log.debug("creating zookeeper using default spec for {}", (Object)this);
                zookeeperSpec = EntitySpec.create(KafkaZooKeeper.class);
                this.setAttribute((AttributeSensor)ZOOKEEPER_SPEC, zookeeperSpec);
            } else {
                log.debug("creating zookeeper using custom spec for {}", (Object)this);
            }
            zookeeper = (ZooKeeperNode)this.addChild(zookeeperSpec);
            if (Entities.isManaged((Entity)this)) {
                Entities.manage((Entity)zookeeper);
            }
            this.setAttribute((AttributeSensor)ZOOKEEPER, zookeeper);
        }
        log.debug("creating cluster child for {}", (Object)this);
        EntitySpec brokerSpec = (EntitySpec)this.getAttribute((AttributeSensor)BROKER_SPEC);
        if (brokerSpec == null) {
            log.debug("creating default broker spec for {}", (Object)this);
            brokerSpec = EntitySpec.create(KafkaBroker.class);
            this.setAttribute((AttributeSensor)BROKER_SPEC, brokerSpec);
        }
        DynamicCluster cluster = (DynamicCluster)this.addChild(EntitySpec.create(DynamicCluster.class).configure((CharSequence)"memberSpec", (Object)EntitySpec.create((EntitySpec)brokerSpec).configure(KafkaBroker.ZOOKEEPER, (Object)zookeeper)));
        if (Entities.isManaged((Entity)this)) {
            Entities.manage((Entity)cluster);
        }
        this.setAttribute(CLUSTER, cluster);
        this.connectSensors();
    }

    @Override
    public ZooKeeperNode getZooKeeper() {
        return (ZooKeeperNode)this.getAttribute((AttributeSensor)ZOOKEEPER);
    }

    @Override
    public DynamicCluster getCluster() {
        return (DynamicCluster)this.getAttribute(CLUSTER);
    }

    public void start(Collection<? extends Location> locations) {
        if (this.isLegacyConstruction()) {
            this.init();
        }
        if (locations.isEmpty()) {
            locations = this.getLocations();
        }
        Iterables.getOnlyElement(locations);
        this.addLocations(locations);
        MutableList childrenToStart = MutableList.of((Object)this.getCluster());
        if (this.getZooKeeper().getParent() == null) {
            this.addChild((Entity)this.getZooKeeper());
        }
        if (Objects.equal((Object)this, (Object)this.getZooKeeper().getParent())) {
            childrenToStart.add(this.getZooKeeper());
        }
        Entities.invokeEffector((EntityLocal)this, (Iterable)childrenToStart, (Effector)Startable.START, (Map)ImmutableMap.of((Object)"locations", (Object)locations)).getUnchecked();
    }

    public void stop() {
        ArrayList errors = Lists.newArrayList();
        if (this.getZooKeeper() != null && Objects.equal((Object)this, (Object)this.getZooKeeper().getParent())) {
            try {
                this.getZooKeeper().stop();
            }
            catch (Exception e) {
                errors.add(e);
            }
        }
        if (this.getCurrentSize() > 0) {
            try {
                this.getCluster().stop();
            }
            catch (Exception e) {
                errors.add(e);
            }
        }
        this.clearLocations();
        this.setAttribute(SERVICE_UP, false);
        if (errors.size() != 0) {
            throw new CompoundRuntimeException("Error stopping Kafka cluster", (Iterable)errors);
        }
    }

    public void restart() {
        ArrayList locations = Lists.newArrayList((Iterable)this.getLocations());
        this.stop();
        this.start(locations);
    }

    void connectSensors() {
        this.addEnricher(((Enrichers.PropagatorBuilder)Enrichers.builder().propagatingAllBut(new Sensor[]{SERVICE_UP}).from((Entity)this.getCluster())).build());
        this.addEnricher(((Enrichers.PropagatorBuilder)Enrichers.builder().propagating(new Sensor[]{SERVICE_UP}).from((Entity)this.getZooKeeper())).build());
    }

    public Collection<Entity> getMembers() {
        return this.getCluster().getMembers();
    }

    public boolean hasMember(Entity member) {
        return this.getCluster().hasMember(member);
    }

    public boolean addMember(Entity member) {
        return this.getCluster().addMember(member);
    }

    public boolean removeMember(Entity member) {
        return this.getCluster().removeMember(member);
    }

    public Integer getCurrentSize() {
        return this.getCluster().getCurrentSize();
    }

    public Integer resize(Integer desiredSize) {
        return this.getCluster().resize(desiredSize);
    }

    public <T extends Entity> T addMemberChild(EntitySpec<T> spec) {
        return (T)this.getCluster().addMemberChild(spec);
    }

    public <T extends Entity> T addMemberChild(T child) {
        return (T)this.getCluster().addMemberChild(child);
    }
}

