/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.messaging.kafka;

import brooklyn.catalog.Catalog;
import brooklyn.config.ConfigKey;
import brooklyn.entity.Entity;
import brooklyn.entity.Group;
import brooklyn.entity.basic.BrooklynConfigKeys;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.group.Cluster;
import brooklyn.entity.group.DynamicCluster;
import brooklyn.entity.messaging.kafka.KafkaBroker;
import brooklyn.entity.messaging.kafka.KafkaClusterImpl;
import brooklyn.entity.messaging.kafka.KafkaZooKeeper;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.entity.proxying.ImplementedBy;
import brooklyn.entity.trait.Resizable;
import brooklyn.entity.trait.Startable;
import brooklyn.entity.zookeeper.ZooKeeperNode;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.BasicAttributeSensor;
import brooklyn.event.basic.BasicAttributeSensorAndConfigKey;
import brooklyn.util.flags.SetFromFlag;
import brooklyn.util.time.Duration;

@Catalog(name="Kafka", description="Apache Kafka is a distributed publish-subscribe messaging system", iconUrl="classpath://brooklyn/entity/messaging/kafka/kafka-google-doorway.jpg")
@ImplementedBy(value=KafkaClusterImpl.class)
public interface KafkaCluster
extends Entity,
Startable,
Resizable,
Group {
    @SetFromFlag(value="startTimeout")
    public static final ConfigKey<Duration> START_TIMEOUT = BrooklynConfigKeys.START_TIMEOUT;
    @SetFromFlag(value="initialSize")
    public static final ConfigKey<Integer> INITIAL_SIZE = ConfigKeys.newConfigKeyWithDefault((ConfigKey)Cluster.INITIAL_SIZE, (Object)1);
    @SetFromFlag(value="zookeeper")
    public static final BasicAttributeSensorAndConfigKey<ZooKeeperNode> ZOOKEEPER = new BasicAttributeSensorAndConfigKey(ZooKeeperNode.class, "kafka.cluster.zookeeper", "The zookeeper for the cluster; if null a default be will created");
    @SetFromFlag(value="zookeeperSpec")
    public static final BasicAttributeSensorAndConfigKey<EntitySpec<KafkaZooKeeper>> ZOOKEEPER_SPEC = new BasicAttributeSensorAndConfigKey(EntitySpec.class, "kafka.cluster.zookeeperSpec", "Spec for creating the kafka zookeeper");
    @SetFromFlag(value="brokerSpec")
    public static final BasicAttributeSensorAndConfigKey<EntitySpec<KafkaBroker>> BROKER_SPEC = new BasicAttributeSensorAndConfigKey(EntitySpec.class, "kafka.cluster.brokerSpec", "Spec for Kafka broker entiites to be created");
    public static final AttributeSensor<DynamicCluster> CLUSTER = new BasicAttributeSensor(DynamicCluster.class, "kafka.cluster.brokerCluster", "Underlying Kafka broker cluster");

    public ZooKeeperNode getZooKeeper();

    public DynamicCluster getCluster();
}

